/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.core.skin;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidKey;
import org.eclipse.swt.graphics.Rectangle;

public class AndroidPressKey
implements IAndroidKey {
    private static final int FLIP_SLIDE_OPENED_ONLY = 0;
    private static final int FLIP_SLIDE_CLOSED_ONLY = 1;
    private static final int FLIP_SLIDE_OPENED_AND_CLOSED = 2;
    private final String name;
    private final String toolTip;
    private final String keycode;
    private final Rectangle keyArea;
    private final int flipSlideEnabledCode;
    private final Collection<String> morphingModeCollection = new LinkedHashSet<String>();

    public AndroidPressKey(String name, String keycode, String toolTip, int startx, int starty, int endx, int endy, String morphingModes, int flipEnabledCode) {
        this(name, keycode, toolTip, new Rectangle(startx, starty, endx - startx, endy - starty), morphingModes, flipEnabledCode);
    }

    public AndroidPressKey(String name, String keycode, String toolTip, Rectangle key, String morphingModes, int flipEnabledCode) {
        this.name = name;
        this.keycode = keycode;
        this.toolTip = toolTip;
        this.keyArea = key;
        this.flipSlideEnabledCode = flipEnabledCode;
        if (morphingModes != null) {
            StringTokenizer st = new StringTokenizer(morphingModes, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.morphingModeCollection.add(token);
            }
        }
    }

    @Override
    public String getKeysym() {
        return this.keycode;
    }

    @Override
    public boolean isInsideKey(int x, int y) {
        return this.keyArea.contains(x, y);
    }

    public int getEndx() {
        return this.keyArea.x + this.keyArea.width;
    }

    public int getEndy() {
        return this.keyArea.y + this.keyArea.height;
    }

    public boolean isFlipSlideValid(boolean isFlipSlideClosed) {
        boolean flipSlideValid = false;
        if (this.flipSlideEnabledCode == 2 || isFlipSlideClosed && this.flipSlideEnabledCode == 1 || !isFlipSlideClosed && this.flipSlideEnabledCode == 0) {
            flipSlideValid = true;
        }
        return flipSlideValid;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getToolTip() {
        return this.toolTip;
    }

    public int getStartx() {
        return this.keyArea.x;
    }

    public int getStarty() {
        return this.keyArea.y;
    }

    @Override
    public Rectangle getKeyArea() {
        return this.keyArea;
    }

    public boolean hasMorphingMode(String morphingMode) {
        if (morphingMode != null) {
            return this.morphingModeCollection.contains(morphingMode);
        }
        return false;
    }
}

