/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.core.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.model.AbstractInputLogic;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.utilities.TelnetFrameworkAndroid;

public class TelnetAndroidInput
extends AbstractInputLogic {
    public static final String EV_TYPE_SYN = "EV_SYN";
    public static final String EV_TYPE_KEY = "EV_KEY";
    public static final String EV_TYPE_ABS = "EV_ABS";
    public static final String EV_TYPE_SW = "EV_SW";
    public static final int EV_SW_LID = 0;
    public static final String EV_SYN_REPORT = "0";
    public static final String EV_ABS_X = "ABS_X";
    public static final String EV_ABS_Y = "ABS_Y";
    private static final String EV_TOUCH = "BTN_TOUCH";
    private final Map<Integer, String> SPECIAL_KEY_MAPPING = new HashMap<Integer, String>(){
        {
            this.put(0x1000003, "KEY_LEFT");
            this.put(0x1000001, "KEY_UP");
            this.put(0x1000004, "KEY_RIGHT");
            this.put(0x1000002, "KEY_DOWN");
        }
    };
    public static final int OPHONE_EV_TYPE_SYN = 0;
    public static final int OPHONE_EV_TYPE_KEY = 1;
    public static final int OPHONE_EV_TYPE_ABS = 3;
    public static final int OPHONE_EV_TYPE_SW = 5;
    public static final int OPHONE_EV_SW_LID = 0;
    public static final int OPHONE_EV_SYN_REPORT = 0;
    public static final int OPHONE_EV_ABS_X = 0;
    public static final int OPHONE_EV_ABS_Y = 1;
    private final Map<Integer, Integer> OPHONE_SPECIAL_KEY_MAPPING = new HashMap<Integer, Integer>(){
        {
            this.put(0x1000003, 105);
            this.put(0x1000001, 103);
            this.put(0x1000004, 106);
            this.put(0x1000002, 108);
        }
    };
    private static final int OPHONE_KEY_BACKSPACE = 14;
    private static final int OPHONE_KEY_SPACE = 57;
    private static final int OPHONE_KEY_ENTER = 28;
    private static final int OPHONE_EV_TOUCH = 330;
    private int oldX;
    private int oldY;
    private final TelnetFrameworkAndroid telnet = new TelnetFrameworkAndroid();

    @Override
    public void init(IAndroidEmulatorInstance instance) {
        super.init(instance);
        String deviceSerial = instance.getInstanceIdentifier();
        String serial = deviceSerial.substring(deviceSerial.length() - 4, deviceSerial.length());
        try {
            this.telnet.connect("localhost", Integer.parseInt(serial));
        }
        catch (IOException iOException) {}
    }

    @Override
    public void dispose() {
        try {
            this.telnet.disconnect();
        }
        catch (IOException iOException) {}
    }

    @Override
    public void sendMouseDown(int x, int y) {
        this.sendAndroidEvent(EV_TYPE_ABS, EV_ABS_X, x);
        this.sendAndroidEvent(EV_TYPE_ABS, EV_ABS_Y, y);
        if (SdkUtils.isOphoneSDK()) {
            this.sendAndroidEvent(EV_TYPE_KEY, 330, true);
            this.sendAndroidEvent(EV_TYPE_SYN, 0, 0);
        } else {
            this.sendAndroidEvent(EV_TYPE_KEY, EV_TOUCH, true);
            this.sendAndroidEvent(EV_TYPE_SYN, EV_SYN_REPORT, 0);
        }
        this.oldX = x;
        this.oldY = y;
    }

    @Override
    public void sendMouseUp(int x, int y) {
        if (SdkUtils.isOphoneSDK()) {
            this.sendAndroidEvent(EV_TYPE_KEY, 330, false);
            this.sendAndroidEvent(EV_TYPE_SYN, 0, 0);
        } else {
            this.sendAndroidEvent(EV_TYPE_KEY, EV_TOUCH, false);
            this.sendAndroidEvent(EV_TYPE_SYN, EV_SYN_REPORT, 0);
        }
    }

    @Override
    public void sendMouseMove(int x, int y) {
        if (this.oldX != x) {
            this.sendAndroidEvent(EV_TYPE_ABS, EV_ABS_X, x);
            this.oldX = x;
        }
        if (this.oldY != y) {
            this.sendAndroidEvent(EV_TYPE_ABS, EV_ABS_Y, y);
            this.oldY = y;
        }
        if (SdkUtils.isOphoneSDK()) {
            this.sendAndroidEvent(EV_TYPE_SYN, 0, 0);
        } else {
            this.sendAndroidEvent(EV_TYPE_SYN, EV_SYN_REPORT, 0);
        }
    }

    public void sendAndroidEvent(String type, String keysym, boolean pressed) {
        this.sendAndroidEvent(type, keysym, pressed ? 1 : 0);
    }

    public void sendAndroidEvent(String type, int keysym, boolean pressed) {
        this.sendAndroidEvent(type, keysym, pressed ? 1 : 0);
    }

    private void sendAndroidEvent(String type, int keysym, int i) {
        try {
            this.telnet.write("event send " + type + ":" + keysym + ":" + i, null);
        }
        catch (IOException iOException) {
            AndmoreLogger.error((String)"Failed to send generic event to Emulator");
        }
    }

    public void sendAndroidEvent(String type, String keysym) {
        this.sendAndroidEvent(type, keysym, true);
        this.sendAndroidEvent(type, keysym, false);
    }

    public void sendAndroidEvent(String type, int keysym) {
        this.sendAndroidEvent(type, keysym, true);
        this.sendAndroidEvent(type, keysym, false);
    }

    private void sendAndroidEvent(String type, String keysym, int value) {
        try {
            this.telnet.write("event send " + type + ":" + keysym + ":" + value, null);
        }
        catch (IOException iOException) {
            AndmoreLogger.error((String)"Failed to send generic event to Emulator");
        }
    }

    @Override
    public void sendKey(int character, int keycode, Properties keyCodeMap) {
        if (character > 0) {
            String keyCode;
            String text = String.valueOf((char)character);
            if (text.equals(" ")) {
                if (SdkUtils.isOphoneSDK()) {
                    this.sendAndroidEvent(EV_TYPE_KEY, 57);
                } else {
                    this.sendAndroidEvent(EV_TYPE_KEY, "KEY_SPACE");
                }
            } else if (text.equals("\b")) {
                if (SdkUtils.isOphoneSDK()) {
                    this.sendAndroidEvent(EV_TYPE_KEY, 14);
                } else {
                    this.sendAndroidEvent(EV_TYPE_KEY, "KEY_BACKSPACE");
                }
            } else if (text.equals("\r")) {
                if (SdkUtils.isOphoneSDK()) {
                    this.sendAndroidEvent(EV_TYPE_KEY, 28);
                } else {
                    this.sendAndroidEvent(EV_TYPE_KEY, "KEY_ENTER");
                }
            } else if (keyCodeMap != null && (keyCode = keyCodeMap.getProperty(text.toUpperCase().trim())) != null) {
                this.sendAndroidEvent(EV_TYPE_KEY, keyCode);
            }
        } else if (!SdkUtils.isOphoneSDK()) {
            String keycode_str = null;
            if (this.SPECIAL_KEY_MAPPING.containsKey(keycode)) {
                keycode_str = this.SPECIAL_KEY_MAPPING.get(keycode);
            }
            if (keycode_str != null) {
                this.sendAndroidEvent(EV_TYPE_KEY, keycode_str);
            }
        } else {
            if (this.OPHONE_SPECIAL_KEY_MAPPING.containsKey(keycode)) {
                keycode = this.OPHONE_SPECIAL_KEY_MAPPING.get(keycode);
            }
            if (keycode != -1) {
                this.sendAndroidEvent(EV_TYPE_KEY, keycode);
            }
        }
    }

    @Override
    public void sendClick(String code, boolean pressed) {
        this.sendAndroidEvent(EV_TYPE_KEY, code, pressed ? 1 : 0);
    }

    @Override
    public void sendClick(int code, boolean pressed) {
        this.sendAndroidEvent(EV_TYPE_KEY, code, pressed ? 1 : 0);
    }

    public void sendWindowScale(double zoomFactor) {
        try {
            this.telnet.write("window scale " + zoomFactor, null);
        }
        catch (IOException iOException) {
            AndmoreLogger.error((String)"Failed to send window scale to Emulator");
        }
    }
}

