/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.definition;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.model.IInputLogic;
import org.eclipse.andmore.android.emulator.device.definition.AndroidEmuDefBean;
import org.eclipse.andmore.android.emulator.device.definition.IAndroidEmuDefConstants;
import org.eclipse.andmore.android.emulator.logic.AbstractStartAndroidEmulatorLogic;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.sequoyah.device.common.utilities.PluginUtils;

public class AndroidEmuDefMgr
implements IAndroidEmuDefConstants {
    private static final Map<String, AndroidEmuDefBean> emuDefs = new LinkedHashMap<String, AndroidEmuDefBean>();
    private static final AndroidEmuDefMgr instance = new AndroidEmuDefMgr();

    private AndroidEmuDefMgr() {
        AndroidEmuDefMgr.readExtensions();
    }

    public static AndroidEmuDefMgr getInstance() {
        return instance;
    }

    private static void readExtensions() {
        IExtension[] emuDefExtensions;
        IExtension[] iExtensionArray = emuDefExtensions = EclipseUtils.getInstalledPlugins((String)"org.eclipse.andmore.android.emulator.androidEmulatorDefinition");
        int n = emuDefExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension emuDefExtension = iExtensionArray[n2];
            String id = emuDefExtension.getUniqueIdentifier();
            IConfigurationElement[] elements = emuDefExtension.getConfigurationElements();
            AndroidEmuDefBean bean = null;
            boolean extensionOk = true;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("skin")) {
                    String skinId = element.getAttribute("id");
                    String skinSize = element.getAttribute("size");
                    if (!skinId.equals("") && !skinSize.equals("")) {
                        bean = new AndroidEmuDefBean(emuDefExtension.getLabel(), skinId, skinSize);
                    } else {
                        extensionOk = false;
                    }
                }
                ++n4;
            }
            if (extensionOk) {
                emuDefs.put(id, bean);
            }
            ++n2;
        }
    }

    public Collection<String> getAllIds() {
        return emuDefs.keySet();
    }

    public String getDefaultId() {
        String defaultId = "";
        Collection<String> ids = this.getAllIds();
        if (!ids.isEmpty()) {
            Object[] idsArray = ids.toArray();
            defaultId = idsArray[0].toString();
        }
        return defaultId;
    }

    public String[] getAllNames() {
        String[] allNames = new String[emuDefs.size()];
        int i = 0;
        for (AndroidEmuDefBean bean : emuDefs.values()) {
            allNames[i++] = bean.getName();
        }
        return allNames;
    }

    public String getName(String emuDefId) {
        String name = emuDefId;
        AndroidEmuDefBean bean = emuDefs.get(emuDefId);
        if (bean != null) {
            name = bean.getName();
        }
        return name;
    }

    public String getSkinId(String emuDefId) {
        String skinId = "";
        AndroidEmuDefBean bean = emuDefs.get(emuDefId);
        if (bean != null) {
            skinId = bean.getSkinId();
        }
        return skinId;
    }

    public String getCommandLineArgumentsForEmuDefinition(String emuDefId) {
        String arguments = "";
        AndroidEmuDefBean bean = emuDefs.get(emuDefId);
        if (bean != null) {
            arguments = bean.getCommandLineArguments();
        }
        return arguments;
    }

    public IInputLogic getInputLogic(String emuDefId, IAndroidEmulatorInstance instance) {
        IInputLogic inputLogic = null;
        try {
            inputLogic = (IInputLogic)PluginUtils.getExecutable((String)emuDefId, (String)"inputLogic");
            inputLogic.init(instance);
        }
        catch (Exception exception) {
            AndmoreLogger.error((String)("Could not retrieve the input logic from definition " + emuDefId));
        }
        return inputLogic;
    }

    public AbstractStartAndroidEmulatorLogic getStartLogic(String emuDefId) {
        AbstractStartAndroidEmulatorLogic startLogic = null;
        AndroidEmuDefBean bean = emuDefs.get(emuDefId);
        try {
            if (bean.getStartLogic() == null) {
                bean.setStartLogic((AbstractStartAndroidEmulatorLogic)PluginUtils.getExecutable((String)emuDefId, (String)"startLogic"));
            }
            startLogic = bean.getStartLogic();
        }
        catch (Exception exception) {
            AndmoreLogger.error((String)("Could not retrieve the Start logic for " + emuDefId));
        }
        return startLogic;
    }
}

