/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.instance;

import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.utils.EmulatorCoreUtils;
import org.eclipse.andmore.android.emulator.device.instance.AndroidDeviceInstance;
import org.eclipse.sequoyah.device.framework.events.InstanceAdapter;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.model.IInstance;

public class AndroidDevInstListener
extends InstanceAdapter {
    public void instanceLoaded(InstanceEvent e) {
        IInstance instance = e.getInstance();
        if (instance instanceof IAndroidEmulatorInstance && instance.getStatus().equals("OFF")) {
            instance.setStatus("org.eclipse.andmore.android.emulator.status.notavailable");
        }
    }

    public void instanceDeleted(InstanceEvent ev) {
        IInstance instance = ev.getInstance();
        if (instance instanceof AndroidDeviceInstance) {
            SdkUtils.deleteVm((String)instance.getName());
        }
    }

    public void instanceTransitioned(InstanceEvent e) {
        IInstance instance = e.getInstance();
        if (instance instanceof AndroidDeviceInstance) {
            AndroidDeviceInstance androidDevice = (AndroidDeviceInstance)instance;
            AndmoreLogger.info((String)("The android device instance status was updated: " + instance + " Status: " + instance.getStatus()));
            if (androidDevice.isStarted()) {
                String transitionId = e.getTransitionId();
                if (transitionId != null && transitionId.equals("org.eclipse.andmore.android.emulator.startService")) {
                    EmulatorCoreUtils.refreshEmulatorViews();
                    AndmoreLogger.info((String)("The emulator " + instance + " transitioned to started state. Try to estabilish a VNC connection..."));
                }
            } else if (instance.getStatus().equals("org.eclipse.andmore.android.emulator.status.offline")) {
                androidDevice.resetRuntimeVariables();
                EmulatorCoreUtils.refreshEmulatorViews();
            }
        }
    }
}

