/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.ui;

import org.eclipse.andmore.android.emulator.device.IDevicePropertiesConstants;
import org.eclipse.andmore.android.emulator.device.instance.AndroidDeviceInstance;
import org.eclipse.andmore.android.emulator.device.ui.AbstractPropertiesComposite;
import org.eclipse.andmore.android.emulator.device.ui.InfoComposite;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class AndroidPropertiesPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IDevicePropertiesConstants {
    private AndroidDeviceInstance emuInstance;
    private InfoComposite infoComposite;
    private boolean defaultMessageNeedsReset = false;
    private String defaultMessage = this.getMessage();
    private AbstractPropertiesComposite.PropertyCompositeChangeListener compositeChangeListener = new AbstractPropertiesComposite.PropertyCompositeChangeListener(){

        @Override
        public void compositeChanged(AbstractPropertiesComposite.PropertyCompositeChangeEvent e) {
            String errorMessage = AndroidPropertiesPage.this.infoComposite.getErrorMessage();
            AndroidPropertiesPage.this.setErrorMessage(errorMessage);
            AndroidPropertiesPage.this.setValid(errorMessage == null && AndroidPropertiesPage.this.getMessage() == null);
            if (AndroidPropertiesPage.this.defaultMessageNeedsReset) {
                AndroidPropertiesPage.this.defaultMessageNeedsReset = false;
                AndroidPropertiesPage.this.setMessage(AndroidPropertiesPage.this.defaultMessage);
            }
        }
    };

    protected Control createContents(Composite parent) {
        ((PreferenceDialog)this.getContainer()).getTreeViewer().expandAll();
        this.noDefaultAndApplyButton();
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)mainLayout);
        this.infoComposite = new InfoComposite(composite, this.emuInstance.getProperties(), this.emuInstance.getName(), !this.emuInstance.isStarted());
        this.infoComposite.setLayoutData(new GridData(4, 4, true, true));
        AbstractPropertiesComposite.addCompositeChangeListener(this.compositeChangeListener);
        String initialMessage = this.infoComposite.getInfoMessage();
        if (initialMessage == null) {
            initialMessage = this.infoComposite.getErrorMessage();
            this.setValid(initialMessage == null);
        }
        if (initialMessage != null) {
            this.defaultMessageNeedsReset = true;
            this.setMessage(initialMessage, 1);
        }
        return composite;
    }

    public void setElement(IAdaptable element) {
        if (element instanceof AndroidDeviceInstance) {
            this.emuInstance = (AndroidDeviceInstance)element;
        }
        super.setElement(element);
    }

    public boolean performOk() {
        if (this.emuInstance != null) {
            this.emuInstance.setProperties(this.infoComposite.getPropertiesWorkingCopy());
            InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_UPDATED, (IInstance)this.emuInstance));
        }
        return super.performOk();
    }

    public void dispose() {
        AbstractPropertiesComposite.removeCompositeChangeListener(this.compositeChangeListener);
        this.infoComposite.dispose();
        super.dispose();
    }
}

