/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.ui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.exception.SkinException;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DpiScaleCalculatorDialog
extends Dialog {
    private Text screenSizeValue;
    private Button monitorDpiValueButton;
    private Text monitorDpiValue;
    private Text monitorSizeText;
    private Text resultDpivalueText;
    private Integer resultDpiValue;
    private Label resultScaleText;
    private Double resultScaleValue;
    private Text resultScaleValueText;
    private Label errorLabel;
    private final IAndroidSkin skin;
    private final Collection<String> errors = new ArrayList<String>();
    int size1 = -1;
    int size2 = -1;

    protected DpiScaleCalculatorDialog(Shell parentShell, IAndroidSkin skin) {
        super(parentShell);
        this.skin = skin;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(EmulatorNLS.DPISCALECALCULATOR_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = new Composite(parent, 4);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.errorLabel = new Label(mainComposite, 8);
        this.errorLabel.setForeground(new Color(null, 255, 0, 0));
        GridData data = new GridData(16384, 0x1000000, false, false, 2, 1);
        this.errorLabel.setLayoutData((Object)data);
        Label screenSizeLabel = new Label(mainComposite, 8);
        screenSizeLabel.setText(EmulatorNLS.DPISCALECALCULATOR_ScreenSize_Label);
        data = new GridData(16384, 0x1000000, false, false);
        screenSizeLabel.setLayoutData((Object)data);
        this.screenSizeValue = new Text(mainComposite, 2048);
        data = new GridData(4, 0, true, false);
        this.screenSizeValue.setLayoutData((Object)data);
        this.screenSizeValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DpiScaleCalculatorDialog.this.validate();
            }
        });
        Group monitorDpiGroup = new Group(mainComposite, 8);
        monitorDpiGroup.setText(EmulatorNLS.DPISCALECALCULATOR_MonitorDpi_Label);
        data = new GridData(4, 0x1000000, true, false, 2, 1);
        monitorDpiGroup.setLayoutData((Object)data);
        monitorDpiGroup.setLayout((Layout)new GridLayout(3, false));
        this.monitorDpiValueButton = new Button((Composite)monitorDpiGroup, 16);
        this.monitorDpiValueButton.setText(EmulatorNLS.DPISCALECALCULATOR_MonitorDpivalue_Label);
        this.monitorDpiValueButton.setSelection(true);
        this.monitorDpiValueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DpiScaleCalculatorDialog.this.monitorDpiValue.setEnabled(DpiScaleCalculatorDialog.this.monitorDpiValueButton.getSelection());
                DpiScaleCalculatorDialog.this.validate();
            }
        });
        data = new GridData(16384, 128, false, false, 1, 1);
        this.monitorDpiValueButton.setLayoutData((Object)data);
        this.monitorDpiValue = new Text((Composite)monitorDpiGroup, 2052);
        data = new GridData(4, 128, true, false, 2, 1);
        data.widthHint = 100;
        this.monitorDpiValue.setLayoutData((Object)data);
        this.monitorDpiValue.setEnabled(this.monitorDpiValueButton.getSelection());
        this.monitorDpiValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DpiScaleCalculatorDialog.this.validate();
            }
        });
        final Button calculateMonitorDpiButton = new Button((Composite)monitorDpiGroup, 16);
        calculateMonitorDpiButton.setText(EmulatorNLS.DPISCALECALCULATOR_MonitorDpiSize_Label);
        calculateMonitorDpiButton.setSelection(false);
        calculateMonitorDpiButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DpiScaleCalculatorDialog.this.monitorSizeText.setEnabled(calculateMonitorDpiButton.getSelection());
                DpiScaleCalculatorDialog.this.validate();
            }
        });
        this.monitorSizeText = new Text((Composite)monitorDpiGroup, 2052);
        data = new GridData(4, 0x1000000, true, false, 2, 1);
        this.monitorSizeText.setLayoutData((Object)data);
        this.monitorSizeText.setEnabled(calculateMonitorDpiButton.getSelection());
        this.monitorSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DpiScaleCalculatorDialog.this.validate();
            }
        });
        Group resultGroup = new Group(mainComposite, 8);
        resultGroup.setText(EmulatorNLS.DPISCALECALCULATOR_ResultGroup_Title);
        data = new GridData(4, 4, true, false, 2, 1);
        resultGroup.setLayoutData((Object)data);
        resultGroup.setLayout((Layout)new GridLayout(4, false));
        Label resultDpi = new Label((Composite)resultGroup, 8);
        resultDpi.setText(EmulatorNLS.DPISCALECALCULATOR_ResultMonitorDpi_Label);
        data = new GridData(16384, 0x1000000, false, false);
        resultDpi.setLayoutData((Object)data);
        this.resultDpivalueText = new Text((Composite)resultGroup, 72);
        data = new GridData(4, 0, true, false);
        this.resultDpivalueText.setLayoutData((Object)data);
        this.resultScaleText = new Label((Composite)resultGroup, 8);
        this.resultScaleText.setText(EmulatorNLS.DPISCALECALCULATOR_ResultScale_Label);
        data = new GridData(16384, 0x1000000, false, false);
        this.resultScaleText.setLayoutData((Object)data);
        this.resultScaleValueText = new Text((Composite)resultGroup, 72);
        data = new GridData(4, 0, true, false);
        this.resultScaleValueText.setLayoutData((Object)data);
        mainComposite.layout();
        mainComposite.pack();
        return null;
    }

    private void updateResult() {
        this.resultDpiValue = this.monitorDpiValueButton.getSelection() ? Integer.valueOf(Integer.parseInt(this.monitorDpiValue.getText())) : Integer.valueOf(this.calculateMonitorDpi());
        this.resultDpivalueText.setText(this.resultDpiValue.toString());
        this.resultScaleValue = this.calculateScale();
        this.resultScaleValueText.setText(this.resultScaleValue.toString());
    }

    private int calculateMonitorDpi() {
        float monitorSize = Float.parseFloat(this.monitorSizeText.getText());
        Dimension b = Toolkit.getDefaultToolkit().getScreenSize();
        float width = b.width;
        float height = b.height;
        float ratio = width / height;
        double dpi = Math.round((double)width / ((double)ratio * Math.sqrt(Math.pow(monitorSize, 2.0) / (1.0 + Math.pow(ratio, 2.0)))));
        return (int)dpi;
    }

    private double calculateScale() {
        double dpi = this.resultDpiValue.intValue();
        if (this.skin != null && this.size1 == -1 && this.size2 == -1) {
            try {
                Collection<String> layouts = this.skin.getAvailableLayouts();
                String defLayout = layouts.toArray()[0].toString();
                this.size1 = this.skin.getSkinBean(defLayout).getSkinPropertyValue("internalViewWidth");
                this.size2 = this.skin.getSkinBean(defLayout).getSkinPropertyValue("internalViewHeight");
            }
            catch (SkinException e) {
                AndmoreLogger.error(DpiScaleCalculatorDialog.class, (String)"Error while calculating scale", (Throwable)((Object)e));
            }
        }
        if (this.size1 > 0 && this.size2 > 0) {
            double diagonalPx = Math.sqrt(Math.pow(this.size1, 2.0) + Math.pow(this.size2, 2.0));
            double screenSize = Double.parseDouble(this.screenSizeValue.getText());
            double scale = screenSize * dpi / diagonalPx;
            return (double)Math.round(scale * 100.0) / 100.0;
        }
        this.getButton(0).setEnabled(false);
        return 1.0;
    }

    public void validate() {
        String REGEX_1 = EmulatorNLS.DPISCALECALCULATOR_Regex_TwoDigits;
        String ERROR_SCREEN_SIZE = EmulatorNLS.DPISCALECALCULATOR_Error_ScreenSize;
        String ERROR_DPI_VALUE = EmulatorNLS.DPISCALECALCULATOR_Error_MonitorDpi;
        String ERROR_MONITOR_SIZE = EmulatorNLS.DPISCALECALCULATOR_Error_MonitorSize;
        this.errors.clear();
        this.errorLabel.setText("");
        if (!this.screenSizeValue.getText().matches(REGEX_1)) {
            this.errors.add(ERROR_SCREEN_SIZE);
        }
        if (this.monitorDpiValueButton.getSelection() && !this.monitorDpiValue.getText().matches("\\d+")) {
            this.errors.add(ERROR_DPI_VALUE);
        }
        if (!this.monitorDpiValueButton.getSelection() && !this.monitorSizeText.getText().matches(REGEX_1)) {
            this.errors.add(ERROR_MONITOR_SIZE);
        }
        if (this.errors.size() > 0) {
            this.getButton(0).setEnabled(false);
            this.errorLabel.setText((String)this.errors.toArray()[0]);
            this.errorLabel.pack();
            this.resultDpivalueText.setText("");
            this.resultScaleValueText.setText("");
        } else {
            this.getButton(0).setEnabled(true);
            this.updateResult();
        }
    }

    public String getResultDpivalue() {
        return this.resultDpiValue.toString();
    }

    public String getResultScaleValue() {
        return this.resultScaleValue.toString();
    }
}

