/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.logic;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.core.exception.InstanceNotFoundException;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStopException;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.utils.EmulatorCoreUtils;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.AbstractStartAndroidEmulatorLogic;
import org.eclipse.andmore.android.emulator.logic.AndroidLogicUtils;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.andmore.android.emulator.logic.StartVncServerLogic;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.sequoyah.vnc.protocol.PluginProtocolActionDelegate;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.InvalidDefinitionException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.InvalidInputStreamDataException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.InvalidMessageException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.MessageHandleException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.ProtocolHandshakeException;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.ProtocolRawHandlingException;

public class AndroidExceptionHandler
implements IProtocolExceptionHandler {
    private int handlingLevel = 1;
    private boolean checkThreadRunning = false;
    private Lock lock = new ReentrantReadWriteLock().writeLock();
    private static Collection<String> stoppedWithFailure = new HashSet<String>();

    static {
        IJobManager manager = Job.getJobManager();
        manager.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus result;
                Job job = event.getJob();
                if (job.belongsTo(StartVncServerLogic.VNC_SERVER_JOB_FAMILY) && !(result = event.getResult()).isOK() && result.getSeverity() != 8) {
                    stoppedWithFailure.add(job.getName());
                }
            }

            public void scheduled(IJobChangeEvent event) {
                Job job = event.getJob();
                if (job.belongsTo(StartVncServerLogic.VNC_SERVER_JOB_FAMILY)) {
                    stoppedWithFailure.remove(job.getName());
                }
            }
        });
    }

    public void handleIOException(ProtocolHandle handle, IOException e) {
        AndmoreLogger.error((String)("A socket was broken while communicating to server. Cause: " + e.getMessage()));
        this.handleException(handle);
    }

    public void handleInvalidDefinitionException(ProtocolHandle handle, InvalidDefinitionException e) {
        AndmoreLogger.warn((String)("An invalid message definition was detected. Cause: " + e.getMessage()));
        this.handleException(handle);
    }

    public void handleInvalidInputStreamDataException(ProtocolHandle handle, InvalidInputStreamDataException e) {
        AndmoreLogger.error((String)"Some received data is not compatible with the expected definition. Restarting the protocol for synchronization.");
        this.handleException(handle);
    }

    public void handleInvalidMessageException(ProtocolHandle handle, InvalidMessageException e) {
        AndmoreLogger.warn((String)("A message was not constructed according to its definition. Cause: " + e.getMessage()));
        this.handleException(handle);
    }

    public void handleMessageHandleException(ProtocolHandle handle, MessageHandleException e) {
        AndmoreLogger.error((String)"A message handler has ended in error and has thrown an exception meaning the protocol cannot continue.");
        this.handleException(handle);
    }

    public void handleProtocolHandshakeException(ProtocolHandle handle, ProtocolHandshakeException e) {
        AndmoreLogger.error((String)"Could not initialize the protocol.");
        this.handleException(handle);
    }

    public void handleProtocolRawHandlingException(ProtocolHandle handle, ProtocolRawHandlingException e) {
        AndmoreLogger.error((String)"A raw field handler has ended in error and has thrown an exception meaning the protocol cannot continue.");
        this.handleException(handle);
    }

    private void handleException(ProtocolHandle handle) {
        IAndroidEmulatorInstance instance = null;
        if (this.lock.tryLock()) {
            try {
                try {
                    instance = EmulatorCoreUtils.getAndroidInstanceByHandle(handle);
                    try {
                        AndmoreLogger.debug((String)("Check if device is online: " + instance));
                        if (instance instanceof ISerialNumbered) {
                            String serialNumber = ((ISerialNumbered)instance).getSerialNumber();
                            AndroidLogicUtils.testDeviceStatus(serialNumber);
                        }
                    }
                    catch (Exception exception) {
                        AndmoreLogger.error((String)"Device is not online. Abort VNC session...");
                        this.abort(instance);
                    }
                    if (this.handlingLevel == 3 && this.canRestartServer(instance)) {
                        --this.handlingLevel;
                    }
                    if (this.handlingLevel == 1) {
                        this.restartClientOnly(handle);
                        ++this.handlingLevel;
                    } else if (this.handlingLevel == 2) {
                        this.restartServerAndClient(instance, handle);
                        ++this.handlingLevel;
                    } else if (this.delegateDecisionToUser(handle)) {
                        this.abort(instance);
                    }
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    this.lock.unlock();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private boolean canRestartServer(IAndroidEmulatorInstance instance) {
        String name = "VNC Server - " + instance.getName();
        return !stoppedWithFailure.contains(name);
    }

    private void restartClientOnly(final ProtocolHandle handle) {
        PluginProtocolActionDelegate.requestRestartProtocol((ProtocolHandle)handle);
        if (!this.checkThreadRunning) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    AndroidExceptionHandler.this.checkThreadRunning = true;
                    while (AndroidExceptionHandler.this.checkThreadRunning) {
                        if (PluginProtocolActionDelegate.isProtocolRunning((ProtocolHandle)handle)) {
                            AndroidExceptionHandler.this.handlingLevel = 1;
                            AndroidExceptionHandler.this.checkThreadRunning = false;
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
            new Thread(r).start();
        }
    }

    private void restartServerAndClient(IAndroidEmulatorInstance instance, ProtocolHandle handle) {
        block5: {
            try {
                if (instance instanceof IAndroidLogicInstance) {
                    IAndroidLogicInstance logicInstance = (IAndroidLogicInstance)instance;
                    AbstractStartAndroidEmulatorLogic logic = logicInstance.getStartLogic();
                    logic.execute(logicInstance, AbstractStartAndroidEmulatorLogic.LogicMode.TRANSFER_AND_CONNECT_VNC, logicInstance.getTimeout(), (IProgressMonitor)new NullProgressMonitor());
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    PluginProtocolActionDelegate.requestRestartProtocol((ProtocolHandle)handle);
                    break block5;
                }
                this.handlingLevel = 3;
            }
            catch (Exception exception) {
                this.handlingLevel = 3;
            }
        }
    }

    private boolean delegateDecisionToUser(ProtocolHandle handle) {
        boolean abort = true;
        AndmoreLogger.error((String)"Cannot reconnect to VM. Asking to the user if he/she wants to retry.");
        if (EclipseUtils.showQuestionDialog((String)EmulatorNLS.GEN_Question, (String)EmulatorNLS.QUESTION_AndroidExceptionHandler_ImpossibleToReconnect)) {
            AndmoreLogger.info((String)"User chose to retry to reconnect to emulator VNC server.");
            PluginProtocolActionDelegate.requestRestartProtocol((ProtocolHandle)handle);
            this.handlingLevel = 2;
            abort = false;
        }
        return abort;
    }

    private void abort(IAndroidEmulatorInstance instance) {
        AndmoreLogger.info((String)"User chose to stop the instance.");
        try {
            this.checkThreadRunning = false;
            instance.stop(true);
        }
        catch (InstanceStopException instanceStopException) {
            AndmoreLogger.error((String)"Error while running service for stopping virtual machine");
            EclipseUtils.showErrorDialog((String)EmulatorNLS.GEN_Error, (String)EmulatorNLS.EXC_AndroidExceptionHandler_CannotRunStopService);
        }
    }
}

