/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.logic;

import java.util.HashMap;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStartException;
import org.eclipse.andmore.android.emulator.core.exception.StartCancelledException;
import org.eclipse.andmore.android.emulator.core.exception.StartTimeoutException;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.AndroidExceptionHandler;
import org.eclipse.andmore.android.emulator.logic.AndroidLogicUtils;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogic;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.vnc.protocol.PluginProtocolActionDelegate;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;

public class ConnectVncLogic
implements IAndroidLogic {
    private static final String LOCALHOST_IP_ADDRESS = "127.0.0.1";
    public IJobChangeEvent vncServerDoneEvent = null;

    @Override
    public void execute(IAndroidLogicInstance instance, int timeout, IProgressMonitor monitor) throws StartTimeoutException, StartCancelledException, InstanceStartException {
        this.connectVnc(instance, timeout, monitor);
    }

    private void connectVnc(IAndroidLogicInstance instance, int timeout, IProgressMonitor monitor) throws StartTimeoutException, StartCancelledException, InstanceStartException {
        AndmoreLogger.info((String)("Trying to estabilish vnc connection with " + instance.getName()));
        long timeoutLimit = System.currentTimeMillis() + (long)timeout;
        try {
            this.startProtocol(instance, timeoutLimit, AndroidLogicUtils.getVncServerPortFoward(instance.getInstanceIdentifier()), monitor);
        }
        catch (StartTimeoutException ise) {
            AndmoreLogger.info((String)"The protocol or the emulator services could not be launched. Stopping the instance.");
            throw ise;
        }
        AndmoreLogger.info((String)("VNC Protocol is running for " + instance.getName()));
    }

    private void startProtocol(IAndroidEmulatorInstance instance, long timeoutLimit, int port, IProgressMonitor monitor) throws StartTimeoutException, StartCancelledException, InstanceStartException {
        try {
            monitor.beginTask(EmulatorNLS.MON_AndroidEmulatorStarter_ConnectingToEmulator, 100);
            monitor.setTaskName(EmulatorNLS.MON_AndroidEmulatorStarter_ConnectingToEmulator);
            this.testVncServer(instance);
            AndroidLogicUtils.testCanceled(monitor);
            this.requestStartProtocol(instance, port);
            ProtocolHandle handle = instance.getProtocolHandle();
            while (!PluginProtocolActionDelegate.isProtocolRunning((ProtocolHandle)handle)) {
                AndroidLogicUtils.testCanceled(monitor);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                AndroidLogicUtils.testTimeout(timeoutLimit, EmulatorNLS.EXC_AndroidEmulatorStarter_TimeoutWhileRunningProtocol);
            }
            monitor.worked(100);
        }
        finally {
            monitor.done();
        }
    }

    public void setVncServerDoneEvent(IJobChangeEvent jobEvent) {
        this.vncServerDoneEvent = jobEvent;
    }

    private void testVncServer(IAndroidEmulatorInstance instance) throws InstanceStartException {
        if (this.vncServerDoneEvent != null) {
            IStatus jobResult = this.vncServerDoneEvent.getResult();
            String reason = "";
            if (4 == jobResult.getSeverity()) {
                reason = jobResult.getMessage();
            } else if (Status.CANCEL_STATUS.equals(jobResult)) {
                reason = EmulatorNLS.INFO_ConnectVncLogic_UserCancelledVncServerStart;
            }
            String message = NLS.bind((String)EmulatorNLS.EXC_VncServerNotRunning, (Object[])new String[]{instance.getName(), reason});
            throw new InstanceStartException(message);
        }
    }

    private void requestStartProtocol(IAndroidEmulatorInstance androidInstance, int port) throws InstanceStartException {
        if (androidInstance != null) {
            ProtocolHandle handle = null;
            try {
                AndmoreLogger.info((String)"Requesting protocol start");
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("password", "");
                parameters.put("bypassProxy", new Boolean(true));
                AndroidExceptionHandler excHandler = new AndroidExceptionHandler();
                handle = PluginProtocolActionDelegate.requestStartProtocolAsClient((String)"vncProtocol38", (IProtocolExceptionHandler)excHandler, (String)LOCALHOST_IP_ADDRESS, (int)port, parameters);
                androidInstance.setProtocolHandle(handle);
            }
            catch (Exception exception) {
                AndmoreLogger.error((String)"There is an error at the protocol specification.");
                throw new InstanceStartException(EmulatorNLS.EXC_CouldNotStartProtocol);
            }
        } else {
            AndmoreLogger.error((String)"Could not start the protocol, because the provided instance is null");
            throw new InstanceStartException(EmulatorNLS.EXC_CouldNotStartProtocol);
        }
    }
}

