/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.service.reset;

import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.EmulatorPlugin;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.andmore.android.emulator.logic.reset.AndroidEmulatorReseter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;

public class ResetServiceHandler
extends ServiceHandler {
    private boolean userAgreed;

    public IServiceHandler newInstance() {
        return new ResetServiceHandler();
    }

    public IStatus runService(IInstance instance, Map<Object, Object> arguments, IProgressMonitor monitor) {
        Object forceObj;
        boolean force = false;
        if (arguments != null && (forceObj = arguments.get("force")) instanceof Boolean) {
            force = (Boolean)forceObj;
        }
        IStatus status = Status.OK_STATUS;
        if (!force && !this.userAgreed) {
            status = Status.CANCEL_STATUS;
        }
        if (status.isOK() && instance instanceof IAndroidLogicInstance) {
            status = AndroidEmulatorReseter.resetInstance((IAndroidLogicInstance)instance);
        }
        try {
            AndmoreLogger.collectUsageData((String)"reset", (String)"emulator", (String)"operation_executed", (String)"org.eclipse.andmore.android.emulator", (String)EmulatorPlugin.getDefault().getBundle().getVersion().toString());
        }
        catch (Throwable throwable) {}
        return status;
    }

    public IStatus updatingService(IInstance instance, IProgressMonitor monitor) {
        AndmoreLogger.info((String)"Updating reset service");
        return Status.OK_STATUS;
    }

    public IStatus singleInit(List<IInstance> instances) {
        int reset = EclipseUtils.showInformationDialog((String)EmulatorNLS.GEN_Warning, (String)EmulatorNLS.QUESTION_AndroidEmulatorReseter_ConfirmationText, (String[])new String[]{EmulatorNLS.QUESTION_AndroidEmulatorReseter_Yes, EmulatorNLS.QUESTION_AndroidEmulatorReseter_No}, (int)4);
        this.userAgreed = reset == 0;
        return Status.OK_STATUS;
    }
}

