/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.service.start;

import java.util.Map;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.EmulatorPlugin;
import org.eclipse.andmore.android.emulator.core.exception.StartCancelledException;
import org.eclipse.andmore.android.emulator.device.instance.AndroidDeviceInstance;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.AndroidLogicUtils;
import org.eclipse.andmore.android.emulator.logic.start.AndroidEmulatorStarter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;

public class StartEmulatorHandler
extends ServiceHandler {
    public IServiceHandler newInstance() {
        return new StartEmulatorHandler();
    }

    public IStatus runService(IInstance instance, Map<Object, Object> arguments, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            String description = "";
            if (!(instance instanceof AndroidDeviceInstance)) {
                AndmoreLogger.error((String)"Aborting start service. This is not an Android Emulator instance...");
                status = new Status(4, "org.eclipse.andmore.android.emulator", EmulatorNLS.ERR_StartEmulatorHandler_NotAnAndroidEmulator);
            } else {
                description = ((AndroidDeviceInstance)instance).getTarget();
                try {
                    AndroidLogicUtils.testCanceled(monitor);
                    status = AndroidEmulatorStarter.startInstance((AndroidDeviceInstance)instance, arguments, monitor);
                    AndmoreLogger.debug((String)("Finished Execution of the start emulator service... :" + instance + " Status => " + status));
                }
                catch (StartCancelledException startCancelledException) {
                    monitor.done();
                    status = Status.CANCEL_STATUS;
                }
            }
            description = "target=" + description;
            AndmoreLogger.collectUsageData((String)"started", (String)"emulator", (String)description, (String)"org.eclipse.andmore.android.emulator", (String)EmulatorPlugin.getDefault().getBundle().getVersion().toString());
        }
        catch (Throwable t) {
            AndmoreLogger.error((String)StartEmulatorHandler.class.toString(), (String)"An exception ocurred during emulator start up process.", (Throwable)t);
            status = new Status(4, "org.eclipse.andmore.android.emulator", "An exception ocurred during emulator start up process.");
        }
        return status;
    }

    public IStatus updatingService(IInstance instance, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }
}

