/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.handlers;

import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.ui.handlers.IHandlerConstants;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.PartInitException;

public class ShowViewHandler
extends AbstractHandler
implements IHandlerConstants {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String viewId = event.getParameter("activeViewId");
        try {
            if (viewId.equals("org.eclipse.andmore.android.emulator.androidView")) {
                AndmoreLogger.info((String)"Showing Main Display View by command execution");
                EclipseUtils.showView((String)"org.eclipse.andmore.android.emulator.mainDisplayView");
            } else if (viewId.equals("org.eclipse.andmore.android.emulator.mainDisplayView")) {
                AndmoreLogger.info((String)"Showing Android View by command execution");
                EclipseUtils.showView((String)"org.eclipse.andmore.android.emulator.androidView");
            } else {
                AndmoreLogger.info((String)"User tried to open an unknown view. Ignoring the action.");
            }
        }
        catch (PartInitException partInitException) {
            AndmoreLogger.error((String)"The views that were requested to be opened are not accessible programatically");
            EclipseUtils.showErrorDialog((String)EmulatorNLS.GEN_Error, (String)EmulatorNLS.EXC_AndroidView_ViewNotFound);
        }
        return null;
    }
}

