/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.view;

import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStopException;
import org.eclipse.andmore.android.emulator.core.exception.SkinException;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.ui.controls.maindisplay.MainDisplayComposite;
import org.eclipse.andmore.android.emulator.ui.view.AbstractAndroidView;
import org.eclipse.andmore.android.emulator.ui.view.AndroidViewData;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.vncviewer.config.IPropertiesFileHandler;
import org.eclipse.sequoyah.vnc.vncviewer.config.VNCConfiguration;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.img.SWTRemoteDisplayImg;
import org.eclipse.sequoyah.vnc.vncviewer.network.VNCProtocolData;
import org.eclipse.sequoyah.vnc.vncviewer.registry.VNCProtocolRegistry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.commands.ICommandService;

public class MainDisplayView
extends AbstractAndroidView {
    public static final String EMULATOR_MAIN_DISPLAY_VIEW_ID = "org.eclipse.andmore.android.emulator.mainDisplayView";

    @Override
    public String getViewId() {
        return EMULATOR_MAIN_DISPLAY_VIEW_ID;
    }

    @Override
    protected String getHelpId() {
        return "org.eclipse.andmore.android.emulator.maindisplay";
    }

    @Override
    protected void createWidgets(TabItem tab, IAndroidEmulatorInstance instance, AndroidViewData tabData) {
        try {
            tabData.loadSkin(instance);
            IAndroidSkin skin = tabData.getSkin();
            ProtocolHandle handle = instance.getProtocolHandle();
            VNCProtocolData data = VNCProtocolRegistry.getInstance().get(handle);
            if (data != null) {
                int baseWidth = skin.getSkinBean(instance.getCurrentLayout()).getSkinPropertyValue("internalViewWidth");
                int baseHeight = skin.getSkinBean(instance.getCurrentLayout()).getSkinPropertyValue("internalViewHeight");
                ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)tab.getParent(), 776);
                final MainDisplayComposite composite = new MainDisplayComposite((Composite)scrolledComposite, 8, baseWidth, baseHeight, instance);
                composite.setLayout((Layout)new FillLayout());
                SWTRemoteDisplay mainDisplay = this.createMainDisplay(composite, skin, instance, (ISWTPainter)data.getVncPainter());
                composite.setSize(baseWidth, baseHeight);
                scrolledComposite.setContent((Control)composite);
                tab.setControl((Control)scrolledComposite);
                scrolledComposite.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        composite.dispose();
                    }
                });
                tabData.setCliDisplay(null);
                tabData.setComposite(composite);
                tabData.setMainDisplay(mainDisplay);
            } else {
                AndmoreLogger.error((String)"The protocol object set in the device instance is not supported. Stopping the emulator instance...");
                EclipseUtils.showErrorDialog((String)EmulatorNLS.GEN_Error, (String)EmulatorNLS.ERR_AndroidView_ProtocolImplementerNotSupported);
                try {
                    instance.stop(true);
                }
                catch (InstanceStopException instanceStopException) {
                    AndmoreLogger.error((String)"Error while running service for stopping virtual machine");
                    EclipseUtils.showErrorDialog((String)EmulatorNLS.GEN_Error, (String)EmulatorNLS.EXC_General_CannotRunStopService);
                }
            }
        }
        catch (SkinException e) {
            AndmoreLogger.error((String)("The skin associated to this instance (" + instance.getName() + ") is not installed or is corrupted."));
            EclipseUtils.showErrorDialog((AndroidException)e);
            try {
                instance.stop(true);
            }
            catch (InstanceStopException instanceStopException) {
                AndmoreLogger.error((String)"Error while running service for stopping virtual machine");
                EclipseUtils.showErrorDialog((String)EmulatorNLS.GEN_Error, (String)EmulatorNLS.EXC_General_CannotRunStopService);
            }
        }
    }

    private SWTRemoteDisplay createMainDisplay(Composite parent, IAndroidSkin skin, IAndroidEmulatorInstance instance, ISWTPainter painter) {
        IPropertiesFileHandler handler = IAndroidSkin.DEFAULT_PROPS_HANDLER;
        String configFile = "resources/vnc_viewer.conf";
        VNCConfiguration config = new VNCConfiguration(configFile, handler);
        SWTRemoteDisplayImg mainDisplay = new SWTRemoteDisplayImg(parent, config.getConfigurationProperties(), handler, painter);
        mainDisplay.setBackground(new Color((Device)mainDisplay.getDisplay(), 0, 0, 0));
        mainDisplay.setLayout((Layout)new FillLayout());
        return mainDisplay;
    }

    @Override
    protected void refreshMenuElements() {
        IViewSite viewSite = this.getViewSite();
        ICommandService service = (ICommandService)viewSite.getService(ICommandService.class);
        service.refreshElements("org.eclipse.andmore.android.emulator.ui.change.zoom", null);
        service.refreshElements("org.eclipse.andmore.android.emulator.ui.change.layout", null);
    }
}

