/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.launch.ui;

import java.util.Collection;
import java.util.Properties;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.devices.DevicesManager;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.launch.LaunchUtils;
import org.eclipse.andmore.android.launch.i18n.LaunchNLS;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DeviceSelectionDialog
extends ElementListSelectionDialog {
    private static final String DEV_SELECTION_CONTEXT_HELP_ID = "org.eclipse.andmore.android.launch.deviceSelectionDialog";

    public DeviceSelectionDialog(Shell parent, String description, final IProject project) {
        super(parent, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String result = "";
                if (element instanceof ISerialNumbered) {
                    String target;
                    IInstance instance;
                    Properties properties;
                    ISerialNumbered serialNumbered = (ISerialNumbered)element;
                    result = serialNumbered.getDeviceName();
                    if (serialNumbered instanceof IAndroidEmulatorInstance) {
                        IAndroidEmulatorInstance emulatorInstance = (IAndroidEmulatorInstance)serialNumbered;
                        int emulatorApi = emulatorInstance.getAPILevel();
                        String emulatorTarget = emulatorInstance.getTarget();
                        result = String.valueOf(result) + " (" + emulatorTarget + ", Api version " + emulatorApi + ")";
                    } else if (serialNumbered instanceof IInstance && (properties = (instance = (IInstance)serialNumbered).getProperties()) != null && (target = properties.getProperty("ro.build.version.release")) != null) {
                        result = String.valueOf(result) + " (Android " + target + ")";
                    }
                }
                return result;
            }

            public Image getImage(Object element) {
                Image img = null;
                ISerialNumbered serialNumbered = (ISerialNumbered)element;
                IStatus compatible = LaunchUtils.isCompatible(project, serialNumbered);
                if (compatible.getSeverity() == 2) {
                    img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                }
                return img;
            }
        });
        this.setTitle(LaunchNLS.UI_LaunchComposite_SelectDeviceScreenTitle);
        this.setMessage(description);
        Collection instances = DevicesManager.getInstance().getAllDevicesSorted();
        if (project != null && instances != null && instances.size() > 0) {
            Collection<ISerialNumbered> filteredInstances = LaunchUtils.filterInstancesByProject(instances, project);
            Object[] filteredInstancesArray = filteredInstances.toArray();
            this.setElements(filteredInstancesArray);
        }
        this.setHelpAvailable(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, DEV_SELECTION_CONTEXT_HELP_ID);
    }
}

