/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.logger.collector.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.andmore.android.common.utilities.FileUtil;

public class ZipUtil {
    private static final int BUFFER = 2048;
    private File outputFile = null;
    private File directory = null;
    private ZipOutputStream zos = null;
    private final String currentDirectory;

    public ZipUtil(String outputFile, String directory) throws IOException {
        this(new File(outputFile), new File(directory));
    }

    public ZipUtil(File outputFile, File directory) throws IOException {
        this.outputFile = outputFile;
        this.directory = directory;
        this.currentDirectory = directory.getAbsolutePath();
    }

    public final void zip() throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.outputFile);
            this.zos = new ZipOutputStream(fos);
            this.zipDir(this.directory);
            this.zos.flush();
        }
        finally {
            try {
                this.zos.close();
                fos.close();
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
    }

    private final void zipDir(File dir) throws IOException {
        if (!dir.getPath().equals(this.currentDirectory)) {
            String entryName = dir.getPath().substring(this.currentDirectory.length() + 1);
            entryName = entryName.replace('\\', '/');
            ZipEntry ze = new ZipEntry(String.valueOf(entryName) + "/");
            if (dir != null && dir.exists()) {
                ze.setTime(dir.lastModified());
            } else {
                ze.setTime(System.currentTimeMillis());
            }
            ze.setSize(0L);
            ze.setMethod(0);
            ze.setCrc(new CRC32().getValue());
            this.zos.putNextEntry(ze);
        }
        if (dir.exists() && dir.isDirectory()) {
            File[] fileList = dir.listFiles();
            int i = 0;
            while (i < fileList.length) {
                if (fileList[i].isDirectory()) {
                    this.zipDir(fileList[i]);
                }
                if (fileList[i].isFile()) {
                    this.zipFile(fileList[i]);
                }
                ++i;
            }
        }
    }

    private void zipFile(File file) throws IOException {
        if (!file.equals(this.outputFile)) {
            BufferedInputStream bis = null;
            try {
                int byteCount;
                bis = new BufferedInputStream(new FileInputStream(file), 2048);
                String entryName = file.getPath().substring(this.currentDirectory.length() + 1);
                entryName = entryName.replace('\\', '/');
                ZipEntry fileEntry = new ZipEntry(entryName);
                this.zos.putNextEntry(fileEntry);
                byte[] data = new byte[2048];
                while ((byteCount = bis.read(data, 0, 2048)) != -1) {
                    this.zos.write(data, 0, byteCount);
                }
            }
            finally {
                bis.close();
            }
        }
    }

    public static void unzip(String zipFilePath, String destDirPath) throws IOException {
        try {
            File zipFile = new File(zipFilePath);
            File folder = new File(destDirPath);
            ZipFile zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                ZipUtil.unzipEntry(zip, entry, folder);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while trying to unzip jar file");
        }
    }

    private static void unzipEntry(ZipFile zipFile, ZipEntry zipEntry, File folder) throws IOException {
        if (zipEntry.isDirectory()) {
            FileUtil.mkdir((String)new File(folder, zipEntry.getName()).getPath());
        } else {
            File outputFile = new File(folder, zipEntry.getName());
            if (!outputFile.getParentFile().exists()) {
                FileUtil.mkdir((String)outputFile.getParentFile().getPath());
            }
            BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outputFile));
            try {
                FileUtil.copy((File)new File(zipFile.getName()), (File)outputFile);
            }
            finally {
                os.close();
                is.close();
            }
        }
    }
}

