/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.remote.handlers;

import java.net.InetAddress;
import java.util.Map;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.remote.RemoteDevicePlugin;
import org.eclipse.andmore.android.remote.i18n.RemoteDeviceNLS;
import org.eclipse.andmore.android.remote.ui.wireless.WirelessWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;
import org.eclipse.ui.PlatformUI;

public class WirelessServiceHandler
extends ServiceHandler {
    private static final int TIMEOUT_REACH_IP = 30000;
    private static final int MIN_SDK_VERSION = 6;

    public IServiceHandler newInstance() {
        return new WirelessServiceHandler();
    }

    public IStatus runService(IInstance instance, Map<Object, Object> arguments, final IProgressMonitor monitor) {
        final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        subMonitor.beginTask(RemoteDeviceNLS.WirelessServiceHandler_MsgLaunchingWirelessConnection, 1000);
        final ISerialNumbered device = (ISerialNumbered)instance;
        int deviceSdkVersion = -1;
        try {
            deviceSdkVersion = Integer.parseInt(DDMSFacade.getDeviceProperty((String)device.getSerialNumber(), (String)"ro.build.version.sdk"));
            subMonitor.worked(100);
        }
        catch (Exception e) {
            AndmoreLogger.error(WirelessServiceHandler.class, (String)"Problems trying to retrieve handset's sdk version.", (Throwable)e);
        }
        if (!subMonitor.isCanceled() && deviceSdkVersion < 6 && deviceSdkVersion != -1) {
            EclipseUtils.showErrorDialog((String)RemoteDeviceNLS.WirelessWizard_TitleWirelessConnectionModeWizard, (String)RemoteDeviceNLS.ERR_WirelessWizard_NOT_VALID_SDK);
        } else if (!subMonitor.isCanceled()) {
            subMonitor.setTaskName(RemoteDeviceNLS.WirelessServiceHandler_MsgRetrievingDeviceIPNumber);
            final String host = DDMSFacade.getWirelessIPfromHandset((String)device.getSerialNumber(), (IProgressMonitor)monitor);
            subMonitor.worked(300);
            if (host == null) {
                EclipseUtils.showErrorDialog((String)RemoteDeviceNLS.WirelessWizard_TitleWirelessConnectionModeWizard, (String)RemoteDeviceNLS.ERR_WirelessWizard_No_IP);
            } else if (!subMonitor.isCanceled()) {
                subMonitor.setTaskName(RemoteDeviceNLS.WirelessServiceHandler_MsgPingingIPAddress);
                InetAddress ipAddress = null;
                boolean canReachIPAddress = true;
                if (!subMonitor.isCanceled()) {
                    try {
                        ipAddress = InetAddress.getByName(host);
                        canReachIPAddress = ipAddress != null && ipAddress.isReachable(30000);
                        subMonitor.worked(200);
                    }
                    catch (Exception e) {
                        canReachIPAddress = false;
                        AndmoreLogger.error(((Object)((Object)this)).getClass(), (String)NLS.bind((String)RemoteDeviceNLS.ERR_WirelessWizard_Reach_IP, (Object)host), (Throwable)e);
                    }
                    if (!canReachIPAddress) {
                        EclipseUtils.showErrorDialog((String)RemoteDeviceNLS.WirelessWizard_TitleWirelessConnectionModeWizard, (String)NLS.bind((String)RemoteDeviceNLS.ERR_WirelessWizard_Reach_IP, (Object)host));
                    } else if (!subMonitor.isCanceled()) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                subMonitor.worked(400);
                                WirelessWizard wizard = new WirelessWizard();
                                wizard.setInstance(device);
                                wizard.setIp(host);
                                wizard.setProgressMonitor(monitor);
                                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                                dialog.open();
                            }
                        });
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus updatingService(IInstance arg0, IProgressMonitor arg1) {
        return Status.OK_STATUS;
    }

    public void setService(IService service) {
        super.setService(service);
        if (service != null) {
            service.setVisible(RemoteDevicePlugin.isWifiServiceEnabled());
        }
    }
}

