/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.json;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.andmore.android.json.JSONValue;
import org.eclipse.andmore.android.json.JSONValueParser;

public class JSONArray
extends JSONValue {
    private final List<JSONValue> value;

    public JSONArray(List<JSONValue> value) {
        this.value = value;
    }

    @Override
    public List<JSONValue> getValue() {
        return this.value;
    }

    static JSONValue parseValues(List<Character> json) {
        Stack<Character> stack = new Stack<Character>();
        ArrayList<JSONValue> values = new ArrayList<JSONValue>();
        boolean parsed = false;
        while (!parsed) {
            Character next = json.get(0);
            if (next.charValue() == '[') {
                json.remove(0);
                stack.push(Character.valueOf('['));
                continue;
            }
            if (next.charValue() == ']') {
                json.remove(0);
                if (((Character)stack.pop()).charValue() != '[') {
                    throw new IllegalArgumentException();
                }
                parsed = true;
                continue;
            }
            if (next.charValue() == ' ' || next.charValue() == '\r' || next.charValue() == '\n' || next.charValue() == ',') {
                json.remove(0);
                continue;
            }
            values.add(JSONValueParser.parse(json));
        }
        return new JSONArray(values);
    }

    public String toString() {
        String string = "[";
        Iterator<JSONValue> objectIterator = this.value.iterator();
        while (objectIterator.hasNext()) {
            string = String.valueOf(string) + objectIterator.next().toString();
            if (!objectIterator.hasNext()) continue;
            string = String.valueOf(string) + ",";
        }
        string = String.valueOf(string) + "]";
        return string;
    }
}

