/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android;

import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AndroidPlugin
extends AbstractUIPlugin {
    private static final String ANDROID_SDK_CONTENT_LOADER_JOB = "Android SDK Content Loader";
    private final LinkedList<Runnable> listeners = new LinkedList();
    protected boolean sdkLoaded = false;
    public static final String PLUGIN_ID = "org.eclipse.andmore.android";
    public static final String PERSPECTIVE_ID = "org.eclipse.andmore.android.perspective";
    public static final String Android_Nature = "org.eclipe.andmore.AndroidNature";
    public static final String ANDROID_MOTOROLA_BRAND_ICON_PATH = "icons/obj16/plate16.png";
    public static final String SHALL_UNEMBED_EMULATORS_PREF_KEY = "shallUnembedEmulators";
    private static AndroidPlugin plugin;
    public static final String NDK_LOCATION_PREFERENCE = "org.eclipse.andmore.android.ndkpath";
    public static final String CYGWIN_LOCATION_PREFERENCE = "org.eclipse.andmore.android.cigwinpath";
    public static final String WARN_ABOUT_HPROF_PREFERENCE = "org.eclipse.andmore.android.warnAboutHprofSaveAction";
    public static final String GCC_VERSION_PROPERTY = "gccversion";
    public static final String PLATFORM_PROPERTY = "platform";
    public static final String SRC_LOCATION_PROPERTY = "srclocation";
    public static final String OBJ_LOCATION_PROPERTY = "objlocation";
    public static final String LIB_LOCATION_PROPERTY = "liblocation";

    public void start(BundleContext context) throws Exception {
        AndmoreLogger.debug(AndroidPlugin.class, (String)"Starting Andmore Plugin...");
        super.start(context);
        plugin = this;
        Thread t = new Thread("DDMS Setup"){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    AndmoreLogger.debug(AndroidPlugin.class, (String)"Starting DDMS facade WITHOUT using listener...");
                    DDMSFacade.setup();
                    AndmoreLogger.debug(AndroidPlugin.class, (String)"DDMS facade started WITHOUT using listener.");
                } else {
                    workbench.addWindowListener(new IWindowListener(){

                        public void windowActivated(IWorkbenchWindow window) {
                        }

                        public void windowDeactivated(IWorkbenchWindow window) {
                        }

                        public void windowClosed(IWorkbenchWindow window) {
                        }

                        public void windowOpened(IWorkbenchWindow window) {
                            AndmoreLogger.debug(AndroidPlugin.class, (String)"Starting DDMS facade using listener...");
                            DDMSFacade.setup();
                            AndmoreLogger.debug(AndroidPlugin.class, (String)"DDMS facade started using listener.");
                        }
                    });
                }
            }
        };
        this.getPreferenceStore().setDefault(SHALL_UNEMBED_EMULATORS_PREF_KEY, true);
        IJobManager manager = Job.getJobManager();
        manager.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                String jobName;
                Job job = event.getJob();
                if (job != null && (jobName = job.getName()) != null && jobName.equals(AndroidPlugin.ANDROID_SDK_CONTENT_LOADER_JOB)) {
                    AndroidPlugin.this.sdkLoaded = true;
                    AndmoreLogger.debug((Object)((Object)AndroidPlugin.this), (String)"Notify SDK loader listeners");
                    HashSet setListeners = new HashSet(AndroidPlugin.this.listeners);
                    for (Runnable listener : setListeners) {
                        try {
                            listener.run();
                        }
                        catch (Throwable e) {
                            AndmoreLogger.error(AndroidPlugin.class, (String)"Error while handling SDK loader procedure.", (Throwable)e);
                        }
                    }
                }
            }
        });
        t.start();
        AndmoreLogger.debug(AndroidPlugin.class, (String)"Andmore Plugin started.");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public void addSDKLoaderListener(Runnable listener) {
        this.listeners.addLast(listener);
        if (this.sdkLoaded) {
            listener.run();
        }
    }

    public void removeSDKLoaderListener(Runnable listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public static AndroidPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AndroidPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

