/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android;

import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmuilib.ScreenShotDialog;
import com.android.sdklib.IAndroidTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.AndmoreEventManager;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.DdmsRunnable;
import org.eclipse.andmore.android.FileListingReceiver;
import org.eclipse.andmore.android.IDatabaseListingListener;
import org.eclipse.andmore.android.InstallPackageBean;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.wizards.installapp.DeployWizard;
import org.eclipse.andmore.android.wizards.installapp.UninstallAppWizard;
import org.eclipse.andmore.android.wizards.mat.DumpHPROFWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class DDMSUtils {
    private static final Map<String, FileListingService> deviceFileListingServiceMap = new HashMap<String, FileListingService>();
    private static final String APK_FILE_EXTENSION = "apk";
    private static final String ADB_INSTALL_OVERWRITE = "-r";
    private static final String PM_CMD = "pm";
    private static final String MONKEY_CMD = "monkey";
    private static final String PM_UNINSTALL_DIRECTIVE = "uninstall";
    private static final String PM_LIST_DIRECTIVE = "list";
    private static final String PM_PACKAGES_DIRECTIVE = "packages";
    private static final String PM_PACKAGES_DIRECTIVE_FORCE = "-f";
    private static final String MONKEY_PACKAGES_DIRECTIVE = " -p ";
    private static final String INSTALL_CMD = "install";
    private static final String SUCCESS_CONSTANT = "Success";
    private static final DdmsRunnable disconnectedListener = new DdmsRunnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(String serialNumber) {
            Map map = deviceFileListingServiceMap;
            synchronized (map) {
                deviceFileListingServiceMap.remove(serialNumber);
            }
        }
    };

    static {
        AndmoreEventManager.asyncAddDeviceChangeListeners(null, disconnectedListener);
    }

    public static void takeScreenshot(final String serialNumber) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ScreenShotDialog sshot = new ScreenShotDialog(new Shell(shell));
                sshot.open(DDMSFacade.getDeviceBySerialNumber(serialNumber));
            }
        });
    }

    public static void getApplicationDatabases(String serialNumber, String applicationName, IDatabaseListingListener listener) {
        LinkedList<String> pathSegments = new LinkedList<String>();
        pathSegments.add("data");
        pathSegments.add("data");
        pathSegments.add(applicationName);
        pathSegments.add("databases");
        FileListingService fileListing = DDMSUtils.getFileListingService(serialNumber);
        if (fileListing != null) {
            FileListingService.FileEntry root = fileListing.getRoot();
            FileListingService.FileEntry[] children = null;
            children = fileListing.getChildren(root, true, (FileListingService.IListingReceiver)new FileListingReceiver(pathSegments, fileListing, listener));
            if (children != null) {
                ArrayList<String> databases = new ArrayList<String>();
                FileListingService.FileEntry temp1 = null;
                FileListingService.FileEntry temp2 = root;
                while (children != null) {
                    if (pathSegments.size() > 0) {
                        String theSegment = pathSegments.remove(0);
                        temp1 = temp2.findChild(theSegment);
                        if (temp1 != null) {
                            temp2 = temp1;
                            children = fileListing.getChildren(temp2, true, (FileListingService.IListingReceiver)new FileListingReceiver(pathSegments, fileListing, listener));
                            continue;
                        }
                        children = null;
                        listener.databasesFound(databases);
                        continue;
                    }
                    if (children != null) {
                        FileListingService.FileEntry[] fileEntryArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FileListingService.FileEntry child = fileEntryArray[n2];
                            if (child.getName().endsWith(".db")) {
                                databases.add(child.getName());
                            }
                            ++n2;
                        }
                        children = null;
                    }
                    listener.databasesFound(databases);
                }
            }
        }
    }

    public static List<String> getApplicationDatabases(String serialNumber, String applicationName) throws IOException {
        new ArrayList();
        String appDbPath = "/data/data/" + applicationName + "/databases/";
        Collection<String> commandOutput = DDMSFacade.execRemoteApp(serialNumber, "ls " + appDbPath, (IProgressMonitor)new NullProgressMonitor());
        ArrayList<String> dbPathCandidates = new ArrayList<String>(commandOutput.size() + 10);
        for (String commandOutline : commandOutput) {
            String[] strings;
            String[] stringArray = strings = commandOutline.split(" ");
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.trim().endsWith(".db")) {
                    dbPathCandidates.add(string);
                }
                ++n2;
            }
        }
        return dbPathCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileListingService getFileListingService(String serialNumber) {
        FileListingService fileListing = null;
        IDevice dev = DDMSFacade.getDeviceBySerialNumber(serialNumber);
        if (dev != null) {
            Object object = dev;
            synchronized (object) {
                fileListing = deviceFileListingServiceMap.get(serialNumber);
            }
            if (fileListing == null) {
                fileListing = dev.getFileListingService();
                object = deviceFileListingServiceMap;
                synchronized (object) {
                    deviceFileListingServiceMap.put(serialNumber, fileListing);
                }
            }
        }
        return fileListing;
    }

    public static String[] getCurrentEmulatorLanguageAndCountry(String serialNumber) {
        ArrayList<String[]> commands = DDMSUtils.createCurrentEmulatorLanguageAndCountryCommand(serialNumber);
        String[] responses = new String[2];
        String[] languageCommand = commands.get(0);
        String[] countryCommand = commands.get(1);
        String languageCommandResult = null;
        String countryCommandResult = null;
        try {
            languageCommandResult = DDMSFacade.executeCommand(languageCommand, null);
            countryCommandResult = DDMSFacade.executeCommand(countryCommand, null);
            responses[0] = languageCommandResult.replaceAll("\\n$", "");
            responses[1] = countryCommandResult.replaceAll("\\n$", "");
        }
        catch (IOException iOException) {
            AndmoreLogger.error((String)"Deploy: Could not execute adb current language command.");
        }
        return responses;
    }

    public static InstallPackageBean installPackageWizard() {
        final InstallPackageBean bean = new InstallPackageBean();
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ISelection selection;
                    String defaultPath = null;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
                        IStructuredSelection workbenchSSelection = (IStructuredSelection)selection;
                        for (Object o : workbenchSSelection.toList()) {
                            IFile file;
                            if (!(o instanceof IFile) || !(file = (IFile)o).getFileExtension().equalsIgnoreCase(DDMSUtils.APK_FILE_EXTENSION)) continue;
                            defaultPath = file.getLocation().toOSString();
                        }
                    }
                    DeployWizard wizard = new DeployWizard(defaultPath);
                    wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
                    WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    dialog.setPageSize(500, 200);
                    if (dialog.open() == 0) {
                        bean.setPackagePath(wizard.getPackagePath());
                        bean.setCanOverwrite(wizard.canOverwrite());
                    }
                }
                catch (Throwable e) {
                    AndmoreLogger.error(DDMSFacade.class, (String)"Error executing deploy wizard", (Throwable)e);
                }
            }
        });
        return bean;
    }

    public static IStatus installPackage(String serialNumber, InstallPackageBean bean) {
        IStatus status = Status.CANCEL_STATUS;
        if (bean.getPackagePath() != null && bean.getCanOverwrite() != null) {
            IOConsoleOutputStream consoleOut = null;
            try {
                consoleOut = EclipseUtils.getStudioConsoleOutputStream((boolean)true);
                status = DDMSUtils.installPackage(serialNumber, bean.getPackagePath(), bean.getCanOverwrite(), (OutputStream)consoleOut);
            }
            finally {
                try {
                    if (consoleOut != null) {
                        consoleOut.close();
                    }
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Install App: could not close console stream" + e.getMessage()));
                }
            }
        }
        if (status.isOK()) {
            AndmoreEventManager.fireEvent(AndmoreEventManager.EventType.PACKAGE_INSTALLED, serialNumber);
        }
        return status;
    }

    public static IStatus installPackage(String serialNumber, String path, DeployWizard.INSTALL_TYPE installationType, OutputStream processOut) {
        IStatus status = null;
        if (installationType.equals((Object)DeployWizard.INSTALL_TYPE.UNINSTALL)) {
            status = DDMSUtils.uninstallPackage(new File(path), serialNumber, processOut);
        }
        boolean overwrite = installationType.equals((Object)DeployWizard.INSTALL_TYPE.OVERWRITE);
        status = DDMSUtils.installPackage(serialNumber, path, overwrite, processOut);
        return status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IStatus uninstallPackage(File path, String serialNumber, OutputStream processOut) {
        Status returnStatus = null;
        if (path == null) return new Status(4, "org.eclipse.andmore.android", AndroidNLS.ERR_DDMSFacade_UninstallPackage);
        if (!path.exists()) return new Status(4, "org.eclipse.andmore.android", AndroidNLS.ERR_DDMSFacade_UninstallPackage);
        if (!path.isFile()) return new Status(4, "org.eclipse.andmore.android", AndroidNLS.ERR_DDMSFacade_UninstallPackage);
        IDevice dev = DDMSFacade.getDeviceBySerialNumber(serialNumber);
        String apiLevel = dev.getProperty("ro.build.version.sdk");
        IAndroidTarget target = SdkUtils.getTargetByAPILevel(Integer.parseInt(apiLevel));
        String aaptPath = SdkUtils.getTargetAAPTPath(target);
        if (aaptPath != null) {
            String[] aaptComm = new String[]{aaptPath, "d", "badging", path.toString()};
            InputStreamReader reader = null;
            BufferedReader bufferedReader = null;
            try {
                try {
                    Process aapt = Runtime.getRuntime().exec(aaptComm);
                    reader = new InputStreamReader(aapt.getInputStream());
                    bufferedReader = new BufferedReader(reader);
                    String infoLine = bufferedReader.readLine();
                    infoLine = infoLine.split(" ")[1].split("=")[1].replaceAll("'", "");
                    returnStatus = DDMSUtils.uninstallPackage(serialNumber, infoLine, processOut);
                    return returnStatus;
                }
                catch (Exception e) {
                    returnStatus = new Status(4, "org.eclipse.andmore.android", AndroidNLS.ERR_DDMSFacade_UninstallPackageException, (Throwable)e);
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        if (bufferedReader == null) return returnStatus;
                        bufferedReader.close();
                        return returnStatus;
                    }
                    catch (IOException e2) {
                        AndmoreLogger.error((String)("Uninstall app could not close stream. " + e2.getMessage()));
                    }
                }
                return returnStatus;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Uninstall app could not close stream. " + e.getMessage()));
                }
            }
        }
        AndmoreLogger.error(DDMSFacade.class, (String)"Impossible to check APK package name. No android targets found inside SDK");
        return returnStatus;
    }

    public static IStatus uninstallPackage(String serialNumber, String packageName, OutputStream processOutput) {
        IStatus status = Status.OK_STATUS;
        String[] command = DDMSUtils.createUninstallCommand(serialNumber, packageName);
        try {
            String commandResult = DDMSFacade.executeCommand(command, processOutput);
            if (!commandResult.toLowerCase().contains(SUCCESS_CONSTANT.toLowerCase())) {
                status = new Status(4, "org.eclipse.andmore.android", String.valueOf(AndroidNLS.ERR_DDMSFacade_UninstallPackageError) + ": " + packageName);
            }
        }
        catch (Exception e) {
            status = new Status(4, "org.eclipse.andmore.android", AndroidNLS.ERR_DDMSFacade_UninstallPackageException, (Throwable)e);
            AndmoreLogger.error(DDMSFacade.class, (String)("Failed to remove package: " + packageName + ". " + e.getMessage()));
        }
        return status;
    }

    public static IStatus runMonkey(String serialNumber, String allPackages, OutputStream processOutput, String otherCmd) {
        IStatus status = Status.OK_STATUS;
        String[] command = DDMSUtils.createMonkeyCommand(serialNumber, allPackages, otherCmd);
        try {
            DDMSFacade.executeCommand(command, processOutput);
        }
        catch (Exception e) {
            EclipseUtils.showErrorDialog((String)AndroidNLS.UI_MonkeyError_Title, (String)AndroidNLS.UI_MonkeyError_Msg);
            AndmoreLogger.error(DDMSFacade.class, (String)("Failed to run monkey command: " + command + " " + e.getMessage()));
        }
        return status;
    }

    private static IStatus uninstallPackages(String serialNumber, ArrayList<String> packagesToUninstall, OutputStream outputStream) {
        MultiStatus returnStatus = null;
        for (String packageToUninstall : packagesToUninstall) {
            AndmoreLogger.info(DDMSUtils.class, (String)("Removing package: " + packageToUninstall));
            IStatus temp = DDMSUtils.uninstallPackage(serialNumber, packageToUninstall, outputStream);
            if (temp.isOK()) continue;
            if (returnStatus == null) {
                returnStatus = new MultiStatus("org.eclipse.andmore.android", 0, AndroidNLS.ERR_DDMSFacade_UninstallPackageError, null);
            }
            ((MultiStatus)returnStatus).add(temp);
        }
        return returnStatus == null ? Status.OK_STATUS : returnStatus;
    }

    private static IStatus runMonkey(String serialNumber, ArrayList<String> packagesToRunMonkey, OutputStream outputStream, String otherCmds) {
        MultiStatus returnStatus = null;
        String allPackages = "";
        for (String packageToRunMonkey : packagesToRunMonkey) {
            allPackages = String.valueOf(allPackages) + MONKEY_PACKAGES_DIRECTIVE + packageToRunMonkey;
        }
        AndmoreLogger.info(DDMSUtils.class, (String)("Running monkey for: " + allPackages));
        IStatus temp = DDMSUtils.runMonkey(serialNumber, allPackages, outputStream, otherCmds);
        if (!temp.isOK()) {
            if (returnStatus == null) {
                returnStatus = new MultiStatus("org.eclipse.andmore.android", 0, AndroidNLS.ERR_DDMSFacade_MonkeyError, null);
            }
            ((MultiStatus)returnStatus).add(temp);
        }
        return returnStatus == null ? Status.OK_STATUS : returnStatus;
    }

    public static IStatus uninstallPackage(final String serialNumber) {
        final ArrayList<String> packagesToUninstall = new ArrayList<String>();
        IStatus status = null;
        final UninstallAppWizard[] wizard = new UninstallAppWizard[1];
        Thread listingThread = new Thread("listPackages"){

            @Override
            public void run() {
                Map<String, String> installedPackages = null;
                try {
                    installedPackages = DDMSUtils.listInstalledPackages(serialNumber);
                }
                catch (IOException iOException) {
                    installedPackages = new HashMap<String, String>(0);
                }
                while (wizard[0] == null) {
                    try {
                        4.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                wizard[0].setAvailablePackages(installedPackages);
            }
        };
        listingThread.start();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                UninstallAppWizard unAppWiz = new UninstallAppWizard();
                WizardDialog dialog = new WizardDialog(new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()), (IWizard)unAppWiz);
                wizard[0] = unAppWiz;
                dialog.open();
                List<String> selectedPackages = wizard[0].getSelectedPackages();
                if (selectedPackages != null) {
                    for (String aPackage : selectedPackages) {
                        packagesToUninstall.add(aPackage);
                    }
                }
            }
        });
        if (packagesToUninstall.size() > 0) {
            IOConsoleOutputStream consoleOut = null;
            try {
                consoleOut = EclipseUtils.getStudioConsoleOutputStream((boolean)true);
                status = DDMSUtils.uninstallPackages(serialNumber, packagesToUninstall, (OutputStream)consoleOut);
            }
            finally {
                try {
                    if (consoleOut != null) {
                        consoleOut.close();
                    }
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Uninstall App: could not close console stream" + e.getMessage()));
                }
            }
        }
        if (status != null) {
            if (status.isOK()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AndroidNLS.UI_UninstallApp_SucessDialogTitle, (String)AndroidNLS.UI_UninstallApp_Message);
                    }
                });
                AndmoreEventManager.fireEvent(AndmoreEventManager.EventType.PACKAGE_UNINSTALLED, serialNumber);
            } else {
                EclipseUtils.showErrorDialog((String)AndroidNLS.UI_UninstallApp_ERRDialogTitle, (String)AndroidNLS.UI_UninstallApp_ERRUninstallApp, status);
            }
        }
        return Status.OK_STATUS;
    }

    private static ILaunchConfiguration createLaunchConfiguration(String deviceName) {
        ILaunchConfiguration config = null;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType andmoreLaunchType = launchManager.getLaunchConfigurationType("monkeyLaunchConfigurationType");
        String launchConfigurationName = launchManager.generateUniqueLaunchConfigurationNameFrom("New_configuration");
        try {
            ILaunchConfigurationWorkingCopy workingCopy = andmoreLaunchType.newInstance(null, launchConfigurationName);
            workingCopy.setAttribute("org.eclipse.andmore.android.monkey.instanceName", deviceName);
            config = workingCopy.doSave();
        }
        catch (CoreException e) {
            EclipseUtils.showErrorDialog((String)AndroidNLS.UI_MonkeyError_Title, (String)e.getMessage());
        }
        return config;
    }

    public static IStatus runMonkey(String serialNumber, String deviceName) {
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("monkeyLaunchConfigurationType");
        try {
            ILaunchConfiguration[] launchs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            ILaunchConfiguration launchConfig = null;
            int i = 0;
            while (i < launchs.length) {
                launchConfig = launchs[i];
                String configDeviceName = launchConfig.getAttribute("org.eclipse.andmore.android.monkey.instanceName", "");
                if (configDeviceName.equals(deviceName)) break;
                launchConfig = null;
                ++i;
            }
            if (launchConfig == null) {
                launchConfig = DDMSUtils.createLaunchConfiguration(deviceName);
            }
            ILaunchGroup lc = DebugUITools.getLaunchGroup((ILaunchConfiguration)launchConfig, (String)"run");
            StructuredSelection selection = new StructuredSelection((Object)launchConfig);
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable((IStructuredSelection)selection, lc){
                private final /* synthetic */ IStructuredSelection val$selection;
                private final /* synthetic */ ILaunchGroup val$lc;
                {
                    this.val$selection = iStructuredSelection;
                    this.val$lc = iLaunchGroup;
                }

                @Override
                public void run() {
                    DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()), (IStructuredSelection)this.val$selection, (String)this.val$lc.getIdentifier(), null);
                }
            });
        }
        catch (CoreException e) {
            AndmoreLogger.error((String)("Monkey: could not open the launch configuration dialog " + e.getMessage()));
        }
        AndmoreLogger.collectUsageData((String)"executed", (String)MONKEY_CMD, (String)"Monkey executed", (String)"org.eclipse.andmore.android", (String)AndroidPlugin.getDefault().getBundle().getBundleContext().getBundle().getVersion().toString());
        return Status.OK_STATUS;
    }

    public static IStatus runMonkey(String serialNumber, ArrayList<String> packagesToRunMonkey, String otherCmds) {
        if (packagesToRunMonkey.size() > 0) {
            IOConsoleOutputStream consoleOut = null;
            try {
                consoleOut = EclipseUtils.getStudioConsoleOutputStream((boolean)true);
                DDMSUtils.runMonkey(serialNumber, packagesToRunMonkey, (OutputStream)consoleOut, otherCmds);
            }
            finally {
                try {
                    if (consoleOut != null) {
                        consoleOut.close();
                    }
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Monkey: could not close console stream" + e.getMessage()));
                }
            }
        }
        return Status.OK_STATUS;
    }

    public static Map<String, String> listInstalledPackages(String serialNumber) throws IOException {
        LinkedHashMap<String, String> packages = new LinkedHashMap<String, String>();
        String sdkPath = SdkUtils.getSdkPath();
        String[] command = new String[]{String.valueOf(sdkPath) + "platform-tools" + File.separator + "adb", "-s", serialNumber, "shell", PM_CMD, PM_LIST_DIRECTIVE, PM_PACKAGES_DIRECTIVE, PM_PACKAGES_DIRECTIVE_FORCE};
        String commResult = DDMSFacade.executeCommand(command, null);
        String[] packageList = null;
        if (commResult != null && commResult.length() > 0 && !commResult.contains("system running?")) {
            packageList = commResult.trim().replaceAll("\n\n", "\n").split("\n");
            int i = 0;
            String aPackage = null;
            String[] packageUnit = null;
            while (i < packageList.length) {
                String[] splittedPackage;
                if (packageList[i].toLowerCase().contains("package:") && (splittedPackage = packageList[i].split(":")).length >= 2 && (packageUnit = (aPackage = splittedPackage[1].trim()).split("=")).length > 1) {
                    packages.put(packageUnit[1], packageUnit[0]);
                }
                ++i;
            }
        }
        return packages;
    }

    public static IStatus installPackage(String serialNumber, String path, boolean canOverwrite, OutputStream processOut) {
        IStatus status = Status.OK_STATUS;
        if (serialNumber == null) {
            AndmoreLogger.error((String)"Abort deploy operation. Serial number is null.");
            status = new Status(4, "org.eclipse.andmore.android", AndroidNLS.ERR_DDMSFacade_SerialNumberNullPointer);
        }
        if (status.isOK() && !DDMSFacade.isDeviceOnline(serialNumber)) {
            AndmoreLogger.error((String)"Abort deploy operation. Device is not online.");
            status = new Status(4, "org.eclipse.andmore.android", "");
        }
        String command_results = "";
        if (status.isOK()) {
            try {
                String[] cmd = DDMSUtils.createInstallCommand(canOverwrite, path, serialNumber);
                command_results = DDMSFacade.executeCommand(cmd, processOut, serialNumber);
                if (!command_results.contains(SUCCESS_CONSTANT)) {
                    status = new Status(4, "org.eclipse.andmore.android", "Error executing the operation. Execution results: " + command_results);
                }
            }
            catch (IOException e) {
                AndmoreLogger.error((String)"Deploy: Could not execute adb install command.");
                status = new Status(4, "org.eclipse.andmore.android", e.getMessage());
            }
        }
        return status;
    }

    public static void changeLanguage(final String serialNumber, final String language, final String country) {
        if (language != null || country != null) {
            Thread thead = new Thread(new Runnable(){

                @Override
                public void run() {
                    String[] cmd = DDMSUtils.createChangeLanguageCommand(serialNumber, language, country);
                    try {
                        IOConsoleOutputStream consoleOut = EclipseUtils.getStudioConsoleOutputStream((boolean)true);
                        if (language != null) {
                            consoleOut.write(String.valueOf(AndroidNLS.UI_ChangeLang_Language) + " " + language + "\n");
                        }
                        if (country != null) {
                            consoleOut.write(String.valueOf(AndroidNLS.UI_ChangeLang_Country) + " " + country + "\n");
                        }
                        DDMSFacade.executeCommand(cmd, (OutputStream)consoleOut);
                        consoleOut.write("\n " + serialNumber + ":" + AndroidNLS.UI_ChangeLang_Restart_Device_Manually + "\n\n");
                        AndmoreEventManager.fireEvent(AndmoreEventManager.EventType.LANGUAGE_CHANGED, serialNumber);
                    }
                    catch (IOException iOException) {
                        AndmoreLogger.error((String)"Language: Could not execute adb change language command.");
                    }
                }
            });
            thead.start();
        }
    }

    private static String[] createChangeLanguageCommand(String serialNumber, String language, String country) {
        String[] cmdTemp;
        File f;
        String sdkPath = SdkUtils.getSdkPath();
        String CHANGE_LANGUAGE_CMD = "";
        if (language != null) {
            CHANGE_LANGUAGE_CMD = String.valueOf(CHANGE_LANGUAGE_CMD) + "setprop persist.sys.language " + language;
        }
        if (country != null) {
            CHANGE_LANGUAGE_CMD = String.valueOf(CHANGE_LANGUAGE_CMD) + (CHANGE_LANGUAGE_CMD.length() > 0 ? ";" : "") + "setprop persist.sys.country " + country;
        }
        if (!(f = new File(String.valueOf(sdkPath) + "platform-tools" + File.separator)).exists()) {
            AndmoreLogger.error((String)("Language: Could not find tools folder on " + sdkPath + "platform-tools" + File.separator));
        } else if (!f.isDirectory()) {
            AndmoreLogger.error((String)("Language: Invalid tools folder " + sdkPath + "platform-tools" + File.separator));
        }
        String[] cmd = cmdTemp = new String[]{String.valueOf(sdkPath) + "platform-tools" + File.separator + "adb", "-s", serialNumber, "shell", CHANGE_LANGUAGE_CMD};
        return cmd;
    }

    private static ArrayList<String[]> createCurrentEmulatorLanguageAndCountryCommand(String serialNumber) {
        String sdkPath = SdkUtils.getSdkPath();
        String GET_LANGUAGE_CMD = "getprop persist.sys.language";
        String GET_COUNTRY_CMD = "getprop persist.sys.country";
        File f = new File(String.valueOf(sdkPath) + "platform-tools" + File.separator);
        if (!f.exists()) {
            AndmoreLogger.error((String)("Language: Could not find tools folder on " + sdkPath + "platform-tools" + File.separator));
        } else if (!f.isDirectory()) {
            AndmoreLogger.error((String)("Language: Invalid tools folder " + sdkPath + "platform-tools" + File.separator));
        }
        String[] langCmdTemp = new String[]{String.valueOf(sdkPath) + "platform-tools" + File.separator + "adb", "-s", serialNumber, "shell", GET_LANGUAGE_CMD};
        String[] countryCmdTemp = new String[]{String.valueOf(sdkPath) + "platform-tools" + File.separator + "adb", "-s", serialNumber, "shell", GET_COUNTRY_CMD};
        String[] languageCommand = langCmdTemp;
        String[] countryCommand = countryCmdTemp;
        ArrayList<String[]> commands = new ArrayList<String[]>();
        commands.add(0, languageCommand);
        commands.add(1, countryCommand);
        return commands;
    }

    private static String[] createInstallCommand(boolean canOverwrite, String path, String serialNumber) {
        String[] cmd;
        String sdkPath = SdkUtils.getSdkPath();
        File f = new File(String.valueOf(sdkPath) + "platform-tools" + File.separator);
        if (!f.exists()) {
            AndmoreLogger.error((String)("Deploy: Could not find tools folder on " + sdkPath + "platform-tools" + File.separator));
        } else if (!f.isDirectory()) {
            AndmoreLogger.error((String)("Deploy: Invalid tools folder " + sdkPath + "platform-tools" + File.separator));
        }
        if (canOverwrite) {
            String[] cmdTemp = new String[]{String.valueOf(sdkPath) + "platform-tools" + File.separator + "adb", "-s", serialNumber, INSTALL_CMD, ADB_INSTALL_OVERWRITE, path};
            cmd = cmdTemp;
        } else {
            String[] cmdTemp;
            cmd = cmdTemp = new String[]{String.valueOf(sdkPath) + "platform-tools" + File.separator + "adb", "-s", serialNumber, INSTALL_CMD, path};
        }
        return cmd;
    }

    private static String[] createUninstallCommand(String serialNumber, String packageName) {
        String sdkPath = SdkUtils.getSdkPath();
        File f = new File(String.valueOf(sdkPath) + "platform-tools" + File.separator);
        if (!f.exists()) {
            AndmoreLogger.error((String)("Run: Could not find tools folder on " + sdkPath + "platform-tools" + File.separator));
        } else if (!f.isDirectory()) {
            AndmoreLogger.error((String)("Run: Invalid tools folder " + sdkPath + "platform-tools" + File.separator));
        }
        String[] cmd = new String[]{String.valueOf(sdkPath) + "platform-tools" + File.separator + "adb", "-s", serialNumber, "shell", PM_CMD, PM_UNINSTALL_DIRECTIVE, packageName};
        return cmd;
    }

    private static String[] createMonkeyCommand(String serialNumber, String packagesName, String otherCmd) {
        String sdkPath = SdkUtils.getSdkPath();
        File f = new File(String.valueOf(sdkPath) + "platform-tools" + File.separator);
        if (!f.exists()) {
            AndmoreLogger.error((String)("Run: Could not find tools folder on " + sdkPath + "platform-tools" + File.separator));
        } else if (!f.isDirectory()) {
            AndmoreLogger.error((String)("Run: Invalid tools folder " + sdkPath + "platform-tools" + File.separator));
        }
        String[] cmd = new String[]{String.valueOf(sdkPath) + "platform-tools" + File.separator + "adb", "-s", serialNumber, "shell", MONKEY_CMD, packagesName, otherCmd};
        return cmd;
    }

    public static IStatus dumpHPROF(final String serialNumber, IProgressMonitor monitor) {
        final String[] selectedAppSet = new String[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                DumpHPROFWizard dumpHPROFWizard = new DumpHPROFWizard(serialNumber);
                WizardDialog dialog = new WizardDialog(new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()), (IWizard)dumpHPROFWizard);
                dialog.open();
                selectedAppSet[0] = dumpHPROFWizard.getSelectedApp();
            }
        });
        IStatus status = selectedAppSet[0] != null ? DDMSFacade.dumpHprofFile(selectedAppSet[0], serialNumber, monitor) : Status.CANCEL_STATUS;
        return status;
    }

    public static int getDeviceApiVersion(String serialNumber) {
        int deviceSdkVersion = -1;
        String deviceProperty = DDMSFacade.getDeviceProperty(serialNumber, "ro.build.version.sdk");
        if (deviceProperty != null) {
            deviceSdkVersion = Integer.parseInt(deviceProperty);
        }
        return deviceSdkVersion;
    }

    public static boolean remoteFileExists(String serialNumber, String remotePath) throws IOException {
        boolean found = false;
        Collection<String> results = DDMSFacade.execRemoteApp(serialNumber, "ls " + FileUtil.getEscapedPath((String)remotePath, (String)"linux"), (IProgressMonitor)new NullProgressMonitor());
        for (String result : results) {
            if (!result.equals(remotePath)) continue;
            found = true;
            break;
        }
        return found;
    }
}

