/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdkuilib.internal.widgets.MessageBoxLog;
import com.android.utils.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.android.Sample;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.manifest.AndroidProjectManifestFile;
import org.eclipse.andmore.android.model.manifest.AndroidManifestFile;
import org.eclipse.andmore.android.model.manifest.dom.AndroidManifestNode;
import org.eclipse.andmore.android.model.manifest.dom.UsesSDKNode;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SdkUtils {
    public static final int API_LEVEL_FOR_PLATFORM_VERSION_3_0_0 = 11;
    public static final String VM_CONFIG_FILENAME = "config.ini";
    public static final String USERIMAGE_FILENAME = "userdata-qemu.img";
    public static final String[] STATEDATA_FILENAMES = new String[]{"cache.img", "userdata.img", "emulator-user.ini"};
    public static final String EMU_CONFIG_SKIN_NAME_PROPERTY = "skin.name";

    public static Sdk getCurrentSdk() {
        return Sdk.getCurrent();
    }

    public static String getSdkPath() {
        String sdkDir = null;
        Sdk sdk = SdkUtils.getCurrentSdk();
        if (sdk != null) {
            sdkDir = sdk.getSdkOsLocation();
        }
        return sdkDir;
    }

    public static String getSdkToolsPath() {
        return AndmoreAndroidPlugin.getOsSdkToolsFolder();
    }

    public static IAndroidTarget getTargetByAPILevel(Integer apiLevel) {
        IAndroidTarget returnTarget = null;
        IAndroidTarget[] iAndroidTargetArray = SdkUtils.getAllTargets();
        int n = iAndroidTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAndroidTarget target = iAndroidTargetArray[n2];
            if (target.getVersion().getApiLevel() == apiLevel.intValue()) {
                returnTarget = target;
            }
            ++n2;
        }
        return returnTarget;
    }

    public static String getTargetAAPTPath(IAndroidTarget target) {
        IAndroidTarget realTarget = null;
        if (target == null) {
            AndmoreLogger.warn(SdkUtils.class, (String)"Trying to find a suitable aapt application to use");
            IAndroidTarget[] allTargets = Sdk.getCurrent().getTargets();
            if (allTargets.length > 0) {
                realTarget = allTargets[0];
            }
        } else {
            realTarget = target;
        }
        while (realTarget != null && !realTarget.isPlatform()) {
            realTarget = realTarget.getParent();
        }
        if (realTarget == null) {
            AndmoreLogger.warn(SdkUtils.class, (String)"No aapt executable found: do you have an Android platform installed?");
        }
        return realTarget != null ? realTarget.getPath(1) : null;
    }

    public static String getAdbPath() {
        return AndmoreAndroidPlugin.getOsAbsoluteAdb();
    }

    public static void reloadAvds() {
        try {
            SdkUtils.getVmManager().reloadAvds(NullSdkLogger.getLogger());
        }
        catch (Exception exception) {
            AndmoreLogger.error(SdkUtils.class, (String)"Error while reloading AVDs");
        }
    }

    public static AvdManager getVmManager() {
        AvdManager vmManager = null;
        Sdk sdk = SdkUtils.getCurrentSdk();
        if (sdk != null) {
            vmManager = sdk.getAvdManager();
        }
        return vmManager;
    }

    public static IAndroidTarget[] getAllTargets() {
        IAndroidTarget[] allTargets = null;
        Sdk sdk = SdkUtils.getCurrentSdk();
        if (sdk != null) {
            allTargets = sdk.getTargets();
        }
        return allTargets;
    }

    public static IAndroidTarget getTargetByName(String name) {
        IAndroidTarget ret = null;
        if (name != null && name.length() > 0) {
            IAndroidTarget[] allTargets = SdkUtils.getAllTargets();
            int i = 0;
            while (i < allTargets.length) {
                if (name.equals(allTargets[i].getName())) {
                    ret = allTargets[i];
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    public static AvdInfo[] getAllVms() {
        AvdInfo[] allVmInfo = null;
        AvdManager vmManager = SdkUtils.getVmManager();
        if (vmManager != null) {
            allVmInfo = vmManager.getAllAvds();
        }
        return allVmInfo;
    }

    public static AvdInfo[] getAllValidVms() {
        AvdInfo[] validVmInfo = null;
        AvdManager vmManager = SdkUtils.getVmManager();
        if (vmManager != null) {
            validVmInfo = vmManager.getValidAvds();
        }
        return validVmInfo;
    }

    public static Collection<String> getAllVmNames() {
        LinkedList<String> vmNames = new LinkedList<String>();
        AvdInfo[] avdInfoArray = SdkUtils.getAllVms();
        int n = avdInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            AvdInfo vm = avdInfoArray[n2];
            vmNames.add(vm.getName());
            ++n2;
        }
        return vmNames;
    }

    public static Collection<String> getAllValidVmNames() {
        LinkedList<String> vmNames = new LinkedList<String>();
        AvdInfo[] allAvds = SdkUtils.getAllValidVms();
        if (allAvds != null) {
            AvdInfo[] avdInfoArray = allAvds;
            int n = allAvds.length;
            int n2 = 0;
            while (n2 < n) {
                AvdInfo vm = avdInfoArray[n2];
                vmNames.add(vm.getName());
                ++n2;
            }
        }
        return vmNames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSkin(AvdInfo vmInfo) {
        String skin = "";
        File configFile = vmInfo.getConfigFile();
        Properties p = new Properties();
        FileInputStream configFileStream = null;
        try {
            configFileStream = new FileInputStream(configFile);
            p.load(configFileStream);
            skin = p.getProperty(EMU_CONFIG_SKIN_NAME_PROPERTY);
        }
        catch (FileNotFoundException e) {
            AndmoreLogger.error(SdkUtils.class, (String)("Error getting VM skin definition. Could not find file " + configFile.getAbsolutePath()), (Throwable)e);
            if (configFileStream == null) return skin;
            try {
                ((InputStream)configFileStream).close();
                return skin;
            }
            catch (IOException iOException) {}
            return skin;
        }
        catch (IOException e) {
            try {
                AndmoreLogger.error(SdkUtils.class, (String)("Error getting VM skin definition. Could not access file " + configFile.getAbsolutePath()), (Throwable)e);
                if (configFileStream == null) return skin;
            }
            catch (Throwable throwable) {
                if (configFileStream == null) throw throwable;
                try {
                    ((InputStream)configFileStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)configFileStream).close();
                return skin;
            }
            catch (IOException iOException) {}
            return skin;
        }
        if (configFileStream == null) return skin;
        try {
            ((InputStream)configFileStream).close();
            return skin;
        }
        catch (IOException iOException) {}
        return skin;
    }

    public static AvdInfo getValidVm(String vmName) {
        AvdInfo vmInfo = null;
        AvdManager vmManager = SdkUtils.getVmManager();
        if (vmManager != null) {
            vmInfo = vmManager.getAvd(vmName, true);
        }
        return vmInfo;
    }

    public static AvdInfo getVm(String vmName) {
        AvdInfo vmInfo = null;
        AvdManager vmManager = SdkUtils.getVmManager();
        if (vmManager != null) {
            vmInfo = vmManager.getAvd(vmName, false);
        }
        return vmInfo;
    }

    public static AvdInfo createVm(String folder, String name, IAndroidTarget target, String abiType, String skinName, String useSnapshot, String sdCard) throws CoreException {
        AvdInfo vmInfo;
        SdkUtils.getVmManager();
        if (abiType == null) {
            abiType = "armeabi";
        }
        if ((vmInfo = null) == null) {
            String errMsg = NLS.bind((String)AndroidNLS.EXC_SdkUtils_CannotCreateTheVMInstance, (Object)name);
            Status status = new Status(4, "org.eclipse.andmore", errMsg);
            throw new CoreException((IStatus)status);
        }
        return vmInfo;
    }

    public static void deleteVm(String name) {
        AvdInfo avdToDelete;
        AvdManager vmManager = SdkUtils.getVmManager();
        AvdInfo avdInfo = avdToDelete = vmManager != null ? vmManager.getAvd(name, false) : null;
        if (avdToDelete != null) {
            try {
                File avdDir;
                String path;
                if (avdToDelete.getIniFile() != null && avdToDelete.getIniFile().exists()) {
                    avdToDelete.getIniFile().delete();
                }
                if ((path = avdToDelete.getDataFolderPath()) != null && (avdDir = new File(path)).exists()) {
                    FileUtil.deleteDirRecursively((File)avdDir);
                }
                vmManager.removeAvd(avdToDelete);
            }
            catch (Exception e) {
                AndmoreLogger.error((String)("Could not delete AVD: " + e.getMessage()));
            }
        }
    }

    public static File getUserdataDir(String vmName) {
        AvdInfo vminfo = SdkUtils.getValidVm(vmName);
        File userdataDir = null;
        if (vminfo != null) {
            String vmpath = vminfo.getDataFolderPath();
            userdataDir = new File(vmpath);
        }
        return userdataDir;
    }

    public static File getUserdataFile(String vmName) {
        File userdataDir = SdkUtils.getUserdataDir(vmName);
        File userdataFile = null;
        if (userdataDir != null) {
            userdataFile = new File(userdataDir, USERIMAGE_FILENAME);
        }
        return userdataFile;
    }

    public static List<File> getStateDataFiles(String vmName) {
        File userdataDir = SdkUtils.getUserdataDir(vmName);
        ArrayList<File> stateDataFiles = null;
        if (userdataDir != null) {
            stateDataFiles = new ArrayList<File>();
            int i = 0;
            while (i < STATEDATA_FILENAMES.length) {
                stateDataFiles.add(new File(userdataDir, STATEDATA_FILENAMES[i]));
                ++i;
            }
        }
        return stateDataFiles;
    }

    public static Object[] getSamples(IAndroidTarget target) {
        List<Object> samples = new ArrayList();
        File samplesFolder = new File(target.getPath(4));
        samples = SdkUtils.findSamples(samplesFolder, target);
        return samples.toArray();
    }

    private static List<Sample> findSamples(File folder, IAndroidTarget target) {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        if (folder.exists() && folder.isDirectory()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File sampleFolder = fileArray[n2];
                if (sampleFolder.isDirectory()) {
                    if (Sample.isSample(sampleFolder)) {
                        samples.add(new Sample(sampleFolder, target));
                    } else {
                        samples.addAll(SdkUtils.findSamples(sampleFolder, target));
                    }
                }
                ++n2;
            }
        }
        return samples;
    }

    public static Object[] getTargets(Sdk sdk) {
        IAndroidTarget[] targets = null;
        if (sdk != null) {
            targets = sdk.getTargets();
        }
        return targets;
    }

    public static void associate(IProject project, IAndroidTarget target) {
        try {
            Sdk.getCurrent().initProject(project, target);
        }
        catch (Exception exception) {
            AndmoreLogger.error(SdkUtils.class, (String)("Error associating project " + project.getName() + " with target " + target.getName()));
        }
    }

    public static IAndroidTarget getTarget(IProject project) {
        IAndroidTarget target = null;
        if (project != null) {
            target = Sdk.getCurrent().getTarget(project);
        }
        return target;
    }

    public static String getMinSdkVersion(IProject project) {
        String minSdkVersion = "";
        try {
            AndroidManifestFile androidManifestFile = AndroidProjectManifestFile.getFromProject((IProject)project);
            UsesSDKNode usesSdkNode = (UsesSDKNode)androidManifestFile.getNode(AndroidManifestNode.NodeType.UsesSdk);
            if (usesSdkNode != null) {
                minSdkVersion = usesSdkNode.getMinSdkVersion();
            }
        }
        catch (AndroidException e) {
            AndmoreLogger.error((String)("Error getting min sdk version. " + e.getMessage()));
        }
        catch (CoreException e) {
            AndmoreLogger.error((String)("Error getting min sdk version. " + e.getMessage()));
        }
        return minSdkVersion;
    }

    public static String[] getActivityActions(IProject project) {
        String[] attributeValues = new String[]{};
        if (project != null && project.isOpen()) {
            IAndroidTarget target = SdkUtils.getTarget(project);
            AndroidTargetData targetData = Sdk.getCurrent().getTargetData(target);
            if (targetData != null) {
                attributeValues = targetData.getAttributeValues("action", "android:name", "activity");
            }
        }
        return attributeValues;
    }

    public static String[] getServiceActions(IProject project) {
        String[] attributeValues = new String[]{};
        if (project != null && project.isOpen()) {
            IAndroidTarget target = SdkUtils.getTarget(project);
            AndroidTargetData targetData = Sdk.getCurrent().getTargetData(target);
            if (targetData != null) {
                attributeValues = targetData.getAttributeValues("action", "android:name", "service");
            }
        }
        return attributeValues;
    }

    public static String[] getReceiverActions(IProject project) {
        String[] attributeValues = new String[]{};
        if (project != null && project.isOpen()) {
            IAndroidTarget target = SdkUtils.getTarget(project);
            AndroidTargetData targetData = Sdk.getCurrent().getTargetData(target);
            if (targetData != null) {
                attributeValues = targetData.getAttributeValues("action", "android:name", "receiver");
            }
        }
        return attributeValues;
    }

    public static String[] getIntentFilterCategories(IProject project) {
        String[] attributeValues = new String[]{};
        if (project != null && project.isOpen()) {
            IAndroidTarget target = SdkUtils.getTarget(project);
            AndroidTargetData targetData = Sdk.getCurrent().getTargetData(target);
            if (targetData != null) {
                attributeValues = targetData.getAttributeValues("category", "android:name");
            }
        }
        return attributeValues;
    }

    public static int getApiVersionNumberForProject(IProject project) {
        AndroidVersion version;
        int api = 0;
        IAndroidTarget target = SdkUtils.getTarget(project);
        if (target != null && (version = target.getVersion()) != null) {
            api = version.getApiLevel();
        }
        return api;
    }

    public static String getTargetNameForProject(IProject project) {
        IAndroidTarget target = SdkUtils.getTarget(project);
        return target != null ? target.getName() : "";
    }

    public static boolean isPlatformTarget(String avdName) {
        IAndroidTarget target = SdkUtils.getValidVm(avdName).getTarget();
        return target != null ? target.isPlatform() : false;
    }

    public static boolean isProjectTargetAPlatform(IProject project) {
        IAndroidTarget target = SdkUtils.getTarget(project);
        return target != null ? target.isPlatform() : false;
    }

    public static boolean isPlatformTarget(IAndroidTarget target) {
        return target != null ? target.isPlatform() : false;
    }

    public static Map<String, String> getAPKConfigurationsForProject(IProject project) {
        HashMap apkConfigurations = null;
        if (project != null && project.isOpen()) {
            Sdk.getCurrent();
            apkConfigurations = new HashMap(0);
        }
        return apkConfigurations;
    }

    public static String getBaseTarget(String name) {
        IAndroidTarget target = SdkUtils.getValidVm(name).getTarget();
        while (!target.isPlatform()) {
            target = target.getParent();
        }
        return target.getName();
    }

    public static boolean isOphoneSDK() {
        IAndroidTarget[] targets;
        boolean result = false;
        FilenameFilter omsFilenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.equals("oms.jar");
            }
        };
        Sdk sdk = SdkUtils.getCurrentSdk();
        IAndroidTarget[] iAndroidTargetArray = targets = sdk.getTargets();
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IAndroidTarget target = iAndroidTargetArray[n2];
            File folder = new File(target.getLocation());
            if (folder.list(omsFilenameFilter).length > 0) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    public static boolean isJILSdk() {
        boolean result = false;
        FilenameFilter jilFilenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.equals("internal.jar");
            }
        };
        Sdk sdk = SdkUtils.getCurrentSdk();
        if (sdk != null) {
            IAndroidTarget[] targets;
            IAndroidTarget[] iAndroidTargetArray = targets = sdk.getTargets();
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                IAndroidTarget target = iAndroidTargetArray[n2];
                File folder = new File(target.getLocation());
                if (folder.list(jilFilenameFilter).length > 0) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static String getEmulatorWindowName(String avdName, int port) {
        String windowName = "";
        windowName = SdkUtils.isJILSdk() ? "JIL Emulator (" + avdName + ":" + port + ")" : (SdkUtils.isOphoneSDK() ? "OPhone Emulator (" + avdName + ":" + port + ")" : String.valueOf(port) + ":" + avdName);
        return windowName;
    }

    public static boolean isLibraryProject(IProject project) {
        return Sdk.getProjectState((IProject)project) != null ? Sdk.getProjectState((IProject)project).isLibrary() : false;
    }

    public static String[] getIntentFilterPermissions(IProject project) {
        String[] attributeValues = new String[]{};
        if (project != null && project.isOpen()) {
            IAndroidTarget target = SdkUtils.getTarget(project);
            AndroidTargetData targetData = Sdk.getCurrent().getTargetData(target);
            if (targetData != null) {
                attributeValues = targetData.getAttributeValues("uses-permission", "android:name");
            }
        }
        return attributeValues;
    }

    public static IStatus repairAvd(AvdInfo avdInfo) {
        IStatus status = Status.OK_STATUS;
        AvdManager avdManager = Sdk.getCurrent().getAvdManager();
        Display display = PlatformUI.getWorkbench().getDisplay();
        MessageBoxLog log = new MessageBoxLog(String.format("Result of updating AVD '%s':", avdInfo.getName()), display, false);
        try {
            avdManager.updateAvd(avdInfo, (ILogger)log);
            if (log instanceof MessageBoxLog) {
                log.displayResult(true);
            }
            SdkUtils.reloadAvds();
        }
        catch (IOException e) {
            status = new Status(4, "org.eclipse.andmore.android", AndroidNLS.SdkUtils_COULD_NOT_REPAIR_AVD, (Throwable)e);
        }
        return status;
    }

    public static String getDefaultSkin(String targetName) {
        IAndroidTarget target = SdkUtils.getTargetByName(targetName);
        target.getDefaultSkin().getName();
        return target != null ? target.getDefaultSkin().getName() : "HVGA";
    }

    public static File getSkinFolder(String skinName, IAndroidTarget target) {
        String path = target.getPath(5);
        File skin = new File(path, skinName);
        if (!skin.exists() && !target.isPlatform()) {
            target = target.getParent();
            path = target.getPath(5);
            skin = new File(path, skinName);
        }
        return skin;
    }

    protected static class NullSdkLogger
    implements ILogger {
        private static NullSdkLogger logger;

        private NullSdkLogger() {
        }

        public static ILogger getLogger() {
            if (logger == null) {
                logger = new NullSdkLogger();
            }
            return logger;
        }

        public void error(Throwable arg0, String arg1, Object ... arg2) {
        }

        public void info(String arg0, Object ... arg1) {
        }

        public void verbose(String arg0, Object ... arg1) {
        }

        public void warning(String arg0, Object ... arg1) {
        }
    }
}

