/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.devices;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.DDMSUtils;
import org.eclipse.andmore.android.InstallPackageBean;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.wizards.installapp.DeployWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sequoyah.device.framework.model.IDeviceTypeDropSupport;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDeviceDropSupportHandler
implements IDeviceTypeDropSupport {
    private DropTargetEvent lastEvent = null;
    private List<File> availableAPKs = null;

    public boolean canDrop(IInstance instance, TransferData data, DropTargetEvent event) {
        return this.getFiles(event) != null && this.getFiles(event).size() > 0 || !"win32".equals(Platform.getOS());
    }

    public void drop(final IInstance instance, TransferData data, DropTargetEvent event) {
        final List<File> files = this.getFiles(event);
        Job installApksJob = new Job(AndroidNLS.AbstractDeviceDropSupportHandler_InstallingApksJobName){

            protected IStatus run(IProgressMonitor monitor) {
                final ArrayList<File> failedFiles = new ArrayList<File>();
                AbstractDeviceDropSupportHandler.this.availableAPKs = null;
                if (files != null) {
                    for (File apk : files) {
                        IStatus installationStatus = AbstractDeviceDropSupportHandler.this.installAPK(apk, instance);
                        if (installationStatus.isOK()) continue;
                        failedFiles.add(apk);
                    }
                }
                if (failedFiles.size() > 0) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            StringBuilder builder = new StringBuilder();
                            builder.append(AndroidNLS.AbstractDeviceDropSupportHandler_ApplicationsFailed);
                            builder.append("\n");
                            for (File f : failedFiles) {
                                builder.append("\n");
                                builder.append(f.getName());
                            }
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AndroidNLS.UI_InstallApp_InstallApp, (String)builder.toString());
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        installApksJob.schedule();
        this.lastEvent = null;
    }

    private synchronized IStatus installAPK(File apk, IInstance instance) {
        InstallPackageBean installBean = new InstallPackageBean();
        installBean.setCanOverwrite(DeployWizard.INSTALL_TYPE.UNINSTALL);
        installBean.setPackagePath(apk.getAbsolutePath());
        return DDMSUtils.installPackage(DDMSFacade.getSerialNumberByName(instance.getName()), installBean);
    }

    protected List<File> getFiles(DropTargetEvent event) {
        if (this.lastEvent == null || this.lastEvent != event) {
            this.lastEvent = event;
            this.availableAPKs = new ArrayList<File>();
            if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                String[] files = (String[])FileTransfer.getInstance().nativeToJava(event.currentDataType);
                if (files == null) {
                    try {
                        files = (String[])event.data;
                    }
                    catch (Exception exception) {
                        files = null;
                    }
                }
                if (files != null) {
                    int i = 0;
                    while (i < files.length) {
                        File f;
                        String filePath = files[i];
                        if (filePath.toLowerCase().endsWith(".apk") && (f = new File(filePath)).exists() && f.isFile() && f.canRead()) {
                            this.availableAPKs.add(f);
                        }
                        ++i;
                    }
                }
            }
        }
        return this.availableAPKs;
    }
}

