/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.obfuscate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Scanner;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.AndroidUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Bundle;

public class ObfuscatorManager {
    private static final String PROGUARD_PATH = "/files/proguard.cfg";
    private static final String PROGUARD_SDK_PATH = "tools/lib/proguard.cfg";
    private static final String PROGUARD_FILENAME = "proguard.cfg";
    private static final String PROGUARD_CONFIG_STATEMENT = "proguard.config=proguard.cfg";
    private static final String DEFAULT_PROPERTIES_FILENAME = "default.properties";
    private static final String PROJECT_PROPERTIES_FILENAME = "project.properties";
    private static final String NL = System.getProperty("line.separator");

    public static IStatus obfuscate(IProject project, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        File projectPropertiesFile = project.getFile(PROJECT_PROPERTIES_FILENAME).getLocation().toFile();
        File defaultPropertiesFile = project.getFile(DEFAULT_PROPERTIES_FILENAME).getLocation().toFile();
        if (projectPropertiesFile.canWrite()) {
            defaultPropertiesFile = projectPropertiesFile;
        }
        File proguardFile = project.getFile(PROGUARD_FILENAME).getLocation().toFile();
        try {
            ObfuscatorManager.addProguardLine(defaultPropertiesFile);
            if (!ObfuscatorManager.fileExists(proguardFile)) {
                ObfuscatorManager.copyProguardFile(project, monitor);
            }
            try {
                project.refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
        }
        catch (Exception e) {
            AndmoreLogger.error(ObfuscatorManager.class, (String)"Error while setting Proguard to obfuscate", (Throwable)e);
            status = new Status(4, "org.eclipse.andmore.android", "Could not set Proguard to obfuscate", (Throwable)e);
        }
        AndmoreLogger.collectUsageData((String)"obfuscation", (String)"obfuscate_project", (String)"operation_executed", (String)"org.eclipse.andmore.android", (String)AndroidPlugin.getDefault().getBundle().getVersion().toString());
        return status;
    }

    public static IStatus unobfuscate(IProject project) {
        IStatus status = Status.OK_STATUS;
        try {
            File projectPropertiesFile = project.getFile(PROJECT_PROPERTIES_FILENAME).getLocation().toFile();
            File defaultPropertiesFile = project.getFile(DEFAULT_PROPERTIES_FILENAME).getLocation().toFile();
            if (ObfuscatorManager.isProguardSet(defaultPropertiesFile)) {
                ObfuscatorManager.removeProguardLine(defaultPropertiesFile);
            }
            if (ObfuscatorManager.isProguardSet(projectPropertiesFile)) {
                ObfuscatorManager.removeProguardLine(projectPropertiesFile);
            }
            try {
                project.refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
        }
        catch (Exception e) {
            AndmoreLogger.error(ObfuscatorManager.class, (String)"Error while removing Proguard settings", (Throwable)e);
            status = new Status(4, "org.eclipse.andmore.android", "Could not remove Proguard settings", (Throwable)e);
        }
        AndmoreLogger.collectUsageData((String)"obfuscation", (String)"desobfuscate_project", (String)"operation_executed", (String)"org.eclipse.andmore.android", (String)AndroidPlugin.getDefault().getBundle().getVersion().toString());
        return status;
    }

    private static void write(File propertiesFile, String newContent) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(propertiesFile));
        try {
            out.write(newContent);
        }
        finally {
            if (out != null) {
                ((Writer)out).close();
            }
        }
    }

    private static String read(File propertiesFile, boolean ignoreProguardStatement) throws IOException {
        StringBuilder text = new StringBuilder();
        Scanner scanner = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(propertiesFile);
            scanner = new Scanner(stream);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (ignoreProguardStatement && line.contains(PROGUARD_CONFIG_STATEMENT)) continue;
                text.append(String.valueOf(line) + NL);
            }
        }
        finally {
            try {
                if (scanner != null) {
                    scanner.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                AndmoreLogger.info((String)("Could not close stream while reading obfuscator properties file. " + e.getMessage()));
            }
        }
        return text.toString();
    }

    private static boolean fileExists(File proguardFile) {
        return proguardFile != null && proguardFile.exists();
    }

    public static boolean isProguardSet(IProject project) {
        File projectPropertiesFile = project.getFile(PROJECT_PROPERTIES_FILENAME).getLocation().toFile();
        File defaultPropertiesFile = project.getFile(DEFAULT_PROPERTIES_FILENAME).getLocation().toFile();
        File proguardFile = project.getFile(PROGUARD_FILENAME).getLocation().toFile();
        return (ObfuscatorManager.isProguardSet(projectPropertiesFile) || ObfuscatorManager.isProguardSet(defaultPropertiesFile)) && ObfuscatorManager.fileExists(proguardFile);
    }

    private static boolean isProguardSet(File propertiesFile) {
        String defaultPropertiesContent = null;
        try {
            defaultPropertiesContent = ObfuscatorManager.read(propertiesFile, false);
        }
        catch (IOException e) {
            AndmoreLogger.error(ObfuscatorManager.class, (String)e.getMessage(), (Throwable)e);
        }
        return defaultPropertiesContent != null && defaultPropertiesContent.contains(PROGUARD_CONFIG_STATEMENT);
    }

    private static void addProguardLine(File propertiesFile) throws IOException {
        String currentContent = null;
        currentContent = ObfuscatorManager.read(propertiesFile, false);
        if (!currentContent.toString().contains(PROGUARD_CONFIG_STATEMENT)) {
            String newContent = currentContent.endsWith(NL) ? String.valueOf(currentContent) + PROGUARD_CONFIG_STATEMENT : String.valueOf(currentContent) + NL + PROGUARD_CONFIG_STATEMENT;
            ObfuscatorManager.write(propertiesFile, newContent);
        }
    }

    private static void removeProguardLine(File propertiesFile) throws IOException {
        String contentWithoutProguardStatement = null;
        contentWithoutProguardStatement = ObfuscatorManager.read(propertiesFile, true);
        ObfuscatorManager.write(propertiesFile, contentWithoutProguardStatement);
    }

    private static void copyProguardFile(IProject project, IProgressMonitor monitor) throws IOException, CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        URL proguardURL = ObfuscatorManager.getProguardFileURL();
        if (proguardURL != null) {
            InputStream is = null;
            try {
                is = proguardURL.openStream();
                IFile destFile = project.getFile(PROGUARD_FILENAME);
                destFile.create(is, 0, (IProgressMonitor)subMonitor);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    private static URL getProguardFileURL() {
        String sdkPath = AndroidUtils.getSDKPathByPreference();
        File sdkPathFile = sdkPath.isEmpty() ? new File(sdkPath) : null;
        File proguardFromSDK = null;
        if (sdkPathFile != null) {
            proguardFromSDK = new File(sdkPathFile, PROGUARD_SDK_PATH);
        }
        URL fileURL = null;
        if (proguardFromSDK != null && proguardFromSDK.canRead()) {
            try {
                fileURL = proguardFromSDK.toURI().toURL();
            }
            catch (MalformedURLException e) {
                AndmoreLogger.warn(ObfuscatorManager.class, (String)"Exception converting proguard template file to URL", (Throwable)e);
            }
        } else {
            Bundle bundle = AndroidPlugin.getDefault().getBundle();
            fileURL = bundle.getEntry(PROGUARD_PATH);
        }
        return fileURL;
    }
}

