/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.obfuscate.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.obfuscate.ObfuscatorManager;
import org.eclipse.andmore.android.obfuscate.ui.ObfuscateDialog;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.PlatformUI;

public class ObfuscateProjectsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ObfuscateDialog dialog = new ObfuscateDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                if (dialog.open() == 0) {
                    ArrayList<IProject> obfuscatedProjects = new ArrayList<IProject>();
                    ArrayList<IProject> selectedProjects = dialog.getSelectedProjects();
                    ArrayList<IProject> toDesobfuscate = new ArrayList<IProject>();
                    IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int i = 0;
                    while (i < allProjects.length) {
                        IProject projectN = allProjects[i];
                        try {
                            if (projectN.getNature("org.eclipse.andmore.AndroidNature") != null && projectN.isOpen() && ObfuscatorManager.isProguardSet(projectN)) {
                                obfuscatedProjects.add(projectN);
                                if (!selectedProjects.contains(projectN)) {
                                    toDesobfuscate.add(projectN);
                                }
                            }
                        }
                        catch (CoreException coreException) {}
                        ++i;
                    }
                    if (!obfuscatedProjects.containsAll(selectedProjects) || !toDesobfuscate.isEmpty()) {
                        ObfuscateProjectsHandler.this.toggleObfuscateMode(selectedProjects, toDesobfuscate);
                    }
                }
            }
        });
        return null;
    }

    private void toggleObfuscateMode(List<IProject> _obfuscatedProjects, List<IProject> _notObfuscatedProjects) {
        for (IProject iProject : _notObfuscatedProjects) {
            ObfuscatorManager.unobfuscate(iProject);
        }
        for (IProject iProject : _obfuscatedProjects) {
            ObfuscatorManager.obfuscate(iProject, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

