/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.obfuscate.ui;

import java.util.ArrayList;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.obfuscate.ObfuscatorManager;
import org.eclipse.andmore.android.obfuscate.ui.TreeViewerContentProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ObfuscateDialog
extends TitleAreaDialog {
    private final String OBFUSCATION_DIALOG_HELP = "org.eclipse.andmore.android.obfuscation-dialog";
    private CheckboxTreeViewer treeViewer;
    private Object[] selectedProjects;

    public ObfuscateDialog(Shell parentShell) {
        super(parentShell);
        this.setTitleImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android", (String)"icons/wizban/obfuscate.gif").createImage());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setSize(330, 300);
        newShell.setText(AndroidNLS.ObfuscateProjectsHandler_1);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        Monitor primary = shell.getMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent).setLayoutData((Object)new GridData(768));
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        mainComposite.setLayout((Layout)layout);
        this.treeViewer = new CheckboxTreeViewer(mainComposite, 2592);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String label = null;
                if (element instanceof IProject) {
                    label = ((IProject)element).getName();
                }
                return label;
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new TreeViewerContentProvider());
        ArrayList<IProject> projectsList = this.generateInputForTree();
        this.treeViewer.setInput(projectsList);
        for (IProject p : projectsList) {
            this.treeViewer.setChecked((Object)p, ObfuscatorManager.isProguardSet(p));
        }
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ObfuscateDialog.this.selectedProjects = ObfuscateDialog.this.treeViewer.getCheckedElements();
            }
        });
        this.treeViewer.expandAll();
        mainComposite.layout(true);
        this.setTitle(AndroidNLS.ObfuscateProjectsHandler_2);
        this.setMessage(AndroidNLS.ObfuscateProjectsHandler_3, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainComposite, "org.eclipse.andmore.android.obfuscation-dialog");
        return mainComposite;
    }

    private ArrayList<IProject> generateInputForTree() {
        ArrayList<IProject> androidProjects = new ArrayList<IProject>();
        IProject[] allProjectsList = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < allProjectsList.length) {
            IProject currentProject = allProjectsList[i];
            try {
                if (currentProject.getNature("org.eclipse.andmore.AndroidNature") != null && currentProject.isOpen()) {
                    androidProjects.add(currentProject);
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return androidProjects;
    }

    public ArrayList<IProject> getSelectedProjects() {
        ArrayList<IProject> list = new ArrayList<IProject>();
        if (this.selectedProjects != null) {
            int i = 0;
            while (i < this.selectedProjects.length) {
                list.add((IProject)this.selectedProjects[i]);
                ++i;
            }
        }
        return list;
    }
}

