/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.elements;

import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.model.AndroidProject;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ApplicationGroup
extends Composite {
    private final AndroidProject project;
    private Text packageName = null;
    private Text activityName = null;
    private Text applicationName = null;
    private Text minSdkVersionText;
    private String userChosenPackageName = null;
    private String userChosenActivityName = null;
    private String userChosenMinSdkVersion = null;
    private String userChosenApplicationName = null;
    private final String DEFAULT_ACTIVITY_NAME = "MainActivity";
    private final String DEFAULT_APP_NAME = "User Application";

    public ApplicationGroup(Composite parent, AndroidProject project) {
        super(parent, 0);
        this.project = project;
        this.createContents(this);
    }

    protected void createContents(Composite mainComposite) {
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(768));
        Composite packageComposite = new Composite(mainComposite, 0);
        packageComposite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(4, 0, true, false);
        packageComposite.setLayoutData((Object)data);
        Label applicationNameLabel = new Label(packageComposite, 0);
        applicationNameLabel.setText(AndroidNLS.UI_ApplicationGroup_ApplicationNameLabel);
        applicationNameLabel.setFont(mainComposite.getParent().getFont());
        this.applicationName = new Text(packageComposite, 2048);
        data = new GridData(4, 0, true, false);
        this.applicationName.setLayoutData((Object)data);
        this.applicationName.setFont(mainComposite.getParent().getFont());
        this.applicationName.setText("User Application");
        this.project.setApplicationName("User Application");
        Label packageLabel = new Label(packageComposite, 0);
        packageLabel.setText(AndroidNLS.UI_ApplicationGroup_PackageNameLabel);
        packageLabel.setFont(mainComposite.getParent().getFont());
        this.packageName = new Text(packageComposite, 2048);
        data = new GridData(4, 0, true, false);
        this.packageName.setLayoutData((Object)data);
        this.packageName.setFont(mainComposite.getParent().getFont());
        this.packageName.setText(this.project.getPackageName());
        Label activityLabel = new Label(packageComposite, 0);
        activityLabel.setText(AndroidNLS.UI_ApplicationGroup_ActivityNameLabel);
        activityLabel.setFont(mainComposite.getParent().getFont());
        this.activityName = new Text(packageComposite, 2048);
        data = new GridData(4, 0, true, false);
        this.activityName.setLayoutData((Object)data);
        this.activityName.setFont(mainComposite.getParent().getFont());
        this.activityName.setText("MainActivity");
        this.project.setActivityName("MainActivity");
        Label minSDKVersionLabel = new Label(packageComposite, 0);
        minSDKVersionLabel.setText(AndroidNLS.UI_ApplicationGroup_MinSDKVersionLabel);
        this.minSdkVersionText = new Text(packageComposite, 2048);
        data = new GridData(4, 0, true, false);
        this.minSdkVersionText.setLayoutData((Object)data);
        this.minSdkVersionText.setFont(mainComposite.getParent().getFont());
        String minSdkVersion = this.project.getMinSdkVersion();
        if (minSdkVersion != null) {
            this.minSdkVersionText.setText(minSdkVersion);
        } else {
            this.minSdkVersionText.setEnabled(false);
            final Runnable listener = new Runnable(){

                @Override
                public void run() {
                    AndroidPlugin.getDefault().removeSDKLoaderListener(this);
                    ApplicationGroup.this.minSdkVersionText.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationGroup.this.minSdkVersionText.setEnabled(true);
                            ApplicationGroup.this.minSdkVersionText.setText(ApplicationGroup.this.project.getMinSdkVersion());
                        }
                    });
                }
            };
            AndroidPlugin.getDefault().addSDKLoaderListener(listener);
            this.minSdkVersionText.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    AndroidPlugin.getDefault().removeSDKLoaderListener(listener);
                }
            });
        }
        this.minSdkVersionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ApplicationGroup.this.project.setMinSdkVersion(ApplicationGroup.this.minSdkVersionText.getText().trim());
                if (ApplicationGroup.this.minSdkVersionText.isFocusControl()) {
                    ApplicationGroup.this.userChosenMinSdkVersion = ApplicationGroup.this.minSdkVersionText.getText();
                }
                ApplicationGroup.this.notifyListeners(1546, new Event());
            }
        });
        this.applicationName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ApplicationGroup.this.project.setApplicationName(ApplicationGroup.this.applicationName.getText());
                if (ApplicationGroup.this.applicationName.isFocusControl()) {
                    ApplicationGroup.this.userChosenApplicationName = ApplicationGroup.this.applicationName.getText();
                }
                ApplicationGroup.this.notifyListeners(1546, new Event());
            }
        });
        this.activityName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ApplicationGroup.this.project.setActivityName(ApplicationGroup.this.activityName.getText());
                if (ApplicationGroup.this.activityName.isFocusControl()) {
                    ApplicationGroup.this.userChosenActivityName = ApplicationGroup.this.activityName.getText();
                }
                ApplicationGroup.this.notifyListeners(1546, new Event());
            }
        });
        this.packageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (ApplicationGroup.this.packageName.isFocusControl()) {
                    ApplicationGroup.this.userChosenPackageName = ApplicationGroup.this.packageName.getText();
                    ApplicationGroup.this.project.setUsingDefaultPackage(false);
                }
                if (!ApplicationGroup.this.project.isUsingDefaultPackage()) {
                    ApplicationGroup.this.project.setPackageName(ApplicationGroup.this.packageName.getText());
                }
                ApplicationGroup.this.notifyListeners(1546, new Event());
            }
        });
    }

    private void setElementsEnabled(boolean enabled) {
        this.packageName.setEnabled(enabled);
        this.activityName.setEnabled(enabled);
        this.applicationName.setEnabled(enabled);
    }

    public void updateDefaultName() {
        if (this.project.getSourceType() != AndroidProject.SourceTypes.NEW && this.project.getSourceType() != AndroidProject.SourceTypes.WIDGET && this.packageName != null) {
            this.project.setUsingDefaultPackage(true);
            this.project.setActivityName("");
            this.packageName.setText("");
            this.activityName.setText("");
            this.applicationName.setText("");
            this.setElementsEnabled(false);
        } else {
            this.project.setUsingDefaultPackage(this.userChosenPackageName == null);
            this.packageName.setText(this.userChosenPackageName == null ? this.project.getPackageName() : this.userChosenPackageName);
            this.activityName.setText(this.userChosenActivityName == null ? "MainActivity" : this.userChosenActivityName);
            this.applicationName.setText(this.userChosenApplicationName == null ? "User Application" : this.userChosenApplicationName);
            this.setElementsEnabled(true);
        }
    }

    public void updateMinSdkVersion() {
        this.minSdkVersionText.setEnabled(this.project.getSourceType() == AndroidProject.SourceTypes.NEW || this.project.getSourceType() == AndroidProject.SourceTypes.WIDGET);
        if (this.project.getSdkTarget() != null) {
            if (this.userChosenMinSdkVersion == null) {
                this.minSdkVersionText.setText(this.project.getSdkTarget().getVersion().getApiString());
            }
        } else {
            this.minSdkVersionText.setText("");
        }
    }

    public Text getActivityText() {
        return this.activityName;
    }

    public boolean isElementsEnabled() {
        return this.packageName.isEnabled() & this.activityName.isEnabled() & this.applicationName.isEnabled();
    }
}

