/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.installapp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.wizards.elements.FileChooser;
import org.eclipse.andmore.android.wizards.installapp.DeployWizard;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class DeployWizardPage
extends WizardPage {
    private FileChooser fileChooser = null;
    private String initialPackagePath = null;
    private String packageSelectionMessage = null;
    private String packagetext = null;
    private final String packageExtension = "apk";
    private Button overwiteRadio = null;
    private Button uninstallRadio = null;
    private Button doNothingRadio = null;
    private static final String contextId = "org.eclipse.andmore.android.install_app";
    private static DeployWizard.INSTALL_TYPE installType;
    private final String DSA_FILE_EXTENSION = ".DSA";
    private final String RSA_FILE_EXTENSION = ".RSA";
    private final String SF_FILE_EXTENSION = ".SF";
    private static String lastUsedPackage;

    static {
        lastUsedPackage = null;
    }

    public DeployWizardPage(String initialPackagePath, String selectPCKMessage, String browseButtonText, String packagetext) {
        super("");
        if (browseButtonText == null || packagetext == null || selectPCKMessage == null) {
            throw new IllegalArgumentException("Could not create Deploy Wizard: null argument");
        }
        this.initialPackagePath = initialPackagePath == null ? (lastUsedPackage != null ? lastUsedPackage : "") : initialPackagePath;
        this.packagetext = packagetext;
        this.packageSelectionMessage = selectPCKMessage;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 4);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainComposite, contextId);
        mainComposite.setLayout((Layout)new GridLayout());
        mainComposite.setLayoutData((Object)new GridData(768, 1040, true, true));
        Group packageGroup = new Group(mainComposite, 0);
        packageGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        packageGroup.setLayout((Layout)new GridLayout(3, false));
        packageGroup.setText(this.packagetext);
        this.fileChooser = new FileChooser((Composite)packageGroup, 0, null);
        this.fileChooser.setFilterExtensions(new String[]{"*.apk"});
        this.fileChooser.setLayoutData((Object)new GridData(4, 0, true, false));
        this.fileChooser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeployWizardPage.this.validateSelection();
            }
        });
        this.createOptionButtons(mainComposite);
        mainComposite.pack();
        this.setPageComplete(false);
        this.loadInitialValues();
        this.setControl((Control)mainComposite);
    }

    private void createOptionButtons(Composite mainComposite) {
        GridData data = new GridData(4, 4, true, false, 3, 1);
        this.overwiteRadio = new Button(mainComposite, 16);
        this.overwiteRadio.setText(AndroidNLS.UI_DeployWizardPage_ReplaceApp);
        this.overwiteRadio.setSelection(true);
        this.overwiteRadio.setLayoutData((Object)data);
        this.overwiteRadio.setData((Object)DeployWizard.INSTALL_TYPE.OVERWRITE);
        this.overwiteRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                installType = (DeployWizard.INSTALL_TYPE)((Object)DeployWizardPage.this.overwiteRadio.getData());
            }
        });
        this.uninstallRadio = new Button(mainComposite, 16);
        this.uninstallRadio.setText(AndroidNLS.UI_DeployWizardPage_UninstallApp);
        this.uninstallRadio.setSelection(true);
        this.uninstallRadio.setLayoutData((Object)data);
        this.uninstallRadio.setData((Object)DeployWizard.INSTALL_TYPE.UNINSTALL);
        this.uninstallRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                installType = (DeployWizard.INSTALL_TYPE)((Object)DeployWizardPage.this.uninstallRadio.getData());
            }
        });
        this.doNothingRadio = new Button(mainComposite, 16);
        this.doNothingRadio.setText(AndroidNLS.UI_DeployWizardPage_DoNothingApp);
        this.doNothingRadio.setSelection(true);
        this.doNothingRadio.setLayoutData((Object)data);
        this.doNothingRadio.setData((Object)DeployWizard.INSTALL_TYPE.DO_NOTHING);
        this.doNothingRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                installType = (DeployWizard.INSTALL_TYPE)((Object)DeployWizardPage.this.doNothingRadio.getData());
            }
        });
        this.overwiteRadio.setSelection(true);
        this.uninstallRadio.setSelection(false);
        this.doNothingRadio.setSelection(false);
        installType = DeployWizard.INSTALL_TYPE.OVERWRITE;
    }

    private void loadInitialValues() {
        if (this.initialPackagePath != null && this.initialPackagePath.length() != 0) {
            this.fileChooser.setText(this.initialPackagePath);
            this.validateSelection();
        } else {
            this.setMessage(this.packageSelectionMessage, 0);
        }
    }

    private synchronized void validateSelection() {
        String packagePath = this.fileChooser.getText();
        if (this.isValidPackage(packagePath)) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private boolean isValidPackage(String packagePath) {
        boolean result = false;
        Path path = new Path(packagePath);
        String extension = path.getFileExtension();
        result = path.toFile().isFile();
        if (!result) {
            this.setErrorMessage(AndroidNLS.UI_DeployWizardPage_PackageIsAFolder);
        } else {
            boolean bl = result = extension != null && extension.equals("apk") && path.isValidPath(path.toString());
            if (!result) {
                this.setErrorMessage(AndroidNLS.UI_DeployWizardPage_InvalidPath);
            } else {
                result = path.toFile().exists();
                if (!result) {
                    this.setErrorMessage(AndroidNLS.UI_DeployWizardPage_FileDoesNotExist);
                }
            }
        }
        if (result) {
            this.setMessage("", 0);
            result = this.isPackageSigned(packagePath);
            if (!result) {
                this.setErrorMessage(AndroidNLS.UI_DeployWizardPage_NotSignedMessage);
            }
        }
        return result;
    }

    private synchronized boolean isPackageSigned(String packagePath) {
        boolean result;
        block17: {
            ArrayList<String> SFFiles = new ArrayList<String>();
            ArrayList<String> RSAFiles = new ArrayList<String>();
            ArrayList<String> DSAFiles = new ArrayList<String>();
            result = false;
            JarFile jar = null;
            try {
                try {
                    jar = new JarFile(packagePath, false);
                    Enumeration<JarEntry> enu = jar.entries();
                    while (enu.hasMoreElements()) {
                        JarEntry entry = enu.nextElement();
                        if (entry.getName().toUpperCase().endsWith(".SF")) {
                            SFFiles.add(entry.getName().toUpperCase());
                            continue;
                        }
                        if (entry.getName().toUpperCase().endsWith(".RSA")) {
                            RSAFiles.add(entry.getName().toUpperCase());
                            continue;
                        }
                        if (!entry.getName().toUpperCase().endsWith(".DSA")) continue;
                        DSAFiles.add(entry.getName().toUpperCase());
                    }
                    if (!SFFiles.isEmpty()) {
                        for (String sfFile : SFFiles) {
                            Path p = new Path(sfFile);
                            boolean bl = result = DSAFiles.contains(String.valueOf(sfFile = p.removeFileExtension().toString()) + ".DSA") || RSAFiles.contains(String.valueOf(sfFile) + ".RSA");
                        }
                    }
                }
                catch (Exception e) {
                    AndmoreLogger.error(DeployWizardPage.class, (String)("Deploy: Could not verify file " + packagePath), (Throwable)e);
                    if (jar == null) break block17;
                    try {
                        jar.close();
                    }
                    catch (IOException e2) {
                        AndmoreLogger.error(DeployWizardPage.class, (String)"Error closing package after verification", (Throwable)e2);
                    }
                }
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {
                        AndmoreLogger.error(DeployWizardPage.class, (String)"Error closing package after verification", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public String getPackagePath() {
        String packagePath = this.fileChooser.getText();
        if (this.isValidPackage(packagePath)) {
            lastUsedPackage = packagePath;
        }
        return packagePath;
    }

    public DeployWizard.INSTALL_TYPE canOverwrite() {
        return installType;
    }
}

