/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.project;

import org.eclipse.andmore.android.Sample;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.model.AndroidProject;
import org.eclipse.andmore.android.wizards.project.SamplesSelectionAdapter;
import org.eclipse.andmore.android.wizards.project.TreeContentProvider;
import org.eclipse.andmore.android.wizards.project.TreeLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class SampleSelectionPage
extends WizardPage {
    private TreeViewer treeViewer;
    private final AndroidProject project;
    private Sample selection = null;
    private final String NEW_PROJECT_SAMPLE_HELP = "org.eclipse.andmore.android.newproj";

    public SampleSelectionPage(AndroidProject project) {
        super(AndroidNLS.UI_SampleSelectionPage_TitleSourcePage);
        this.project = project;
        this.setTitle(AndroidNLS.UI_SampleSelectionPage_WizardTitle);
        this.setDescription(AndroidNLS.UI_SampleSelectionPage_WizardDescription);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout());
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)new GridLayout());
        Label itemsTableLabel = new Label(mainComposite, 0);
        itemsTableLabel.setText(AndroidNLS.UI_SampleSelectionPage_SamplesTreeLabel);
        Composite composite = new Composite(mainComposite, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer(composite, 2564);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.heightHint = 250;
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider(this.project));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.treeViewer.setInput((Object)SdkUtils.getCurrentSdk());
        this.treeViewer.expandAll();
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SamplesSelectionAdapter(this, this.project));
        this.setControl((Control)mainComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.newproj");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.treeViewer.refresh();
            Tree tree = this.treeViewer.getTree();
            tree.deselectAll();
            if (this.selection != null) {
                TreeItem[] treeItemArray = this.treeViewer.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Sample sample;
                    TreeItem item = treeItemArray[n2];
                    if (item.getData() instanceof Sample && (sample = (Sample)item.getData()).getName().equals(this.selection.getName())) {
                        tree.setSelection(item);
                        tree.select(item);
                        this.project.setSample(sample);
                        this.setPageComplete(true);
                    }
                    ++n2;
                }
            }
            if (tree.getSelection().length == 0 && tree.getItemCount() > 0) {
                tree.setSelection(tree.getItem(0));
                tree.select(tree.getItem(0));
                this.project.setSample((Sample)tree.getItem(0).getData());
                this.setPageComplete(true);
            }
        } else {
            this.selection = this.project.getSample();
            this.setPageComplete(false);
        }
        super.setVisible(visible);
        this.getContainer().updateButtons();
    }

    public IWizardPage getPreviousPage() {
        return super.getPreviousPage();
    }
}

