/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.widget;

import com.android.sdklib.IAndroidTarget;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.preferences.DialogWithToggleUtils;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.model.AndroidProject;
import org.eclipse.andmore.android.wizards.widget.NewAndroidWidgetProjectMainPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewAndroidWidgetProjectWizard
extends BasicNewProjectResourceWizard
implements INewWizard {
    private static final String WIZARD_BANNER = "icons/wizban/widget_provider_prj_wiz.png";
    private final AndroidProject project = new AndroidProject();

    public boolean canFinish() {
        return this.project.getStatus().getSeverity() != 4 && !this.project.needMoreInformation();
    }

    public boolean performFinish() {
        DoSave doSave = new DoSave();
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)doSave);
        }
        catch (InvocationTargetException e) {
            String errMsg = NLS.bind((String)AndroidNLS.EXC_NewAndroidProjectWizard_AnErrorHasOccurredWhenCreatingTheProject, (Object)e.getCause().getLocalizedMessage());
            AndmoreLogger.error(NewAndroidWidgetProjectWizard.class, (String)errMsg, (Throwable)e);
            EclipseUtils.showErrorDialog((String)AndroidNLS.UI_GenericErrorDialogTitle, (String)errMsg, null);
        }
        catch (InterruptedException e) {
            String errMsg = NLS.bind((String)AndroidNLS.EXC_NewAndroidProjectWizard_AnErrorHasOccurredWhenCreatingTheProject, (Object)e.getLocalizedMessage());
            AndmoreLogger.error(NewAndroidWidgetProjectWizard.class, (String)errMsg, (Throwable)e);
            EclipseUtils.showErrorDialog((String)AndroidNLS.UI_GenericErrorDialogTitle, (String)errMsg, null);
        }
        if (doSave.saved) {
            try {
                AndmoreLogger.collectUsageData((String)"created", (String)"application_management", (String)this.project.getSourceType().name().toLowerCase(), (String)"org.eclipse.andmore.android", (String)AndroidPlugin.getDefault().getBundle().getVersion().toString());
            }
            catch (Throwable throwable) {}
        }
        return doSave.saved;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(AndroidNLS.UI_NewAndroidWidgetProjectWizard_TitleNewProjectWizard);
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(AndroidPlugin.getImageDescriptor(WIZARD_BANNER));
        this.project.setSourceType(AndroidProject.SourceTypes.WIDGET);
    }

    public boolean performCancel() {
        try {
            this.project.finalize();
        }
        catch (Throwable e) {
            AndmoreLogger.error(NewAndroidWidgetProjectWizard.class, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return super.performCancel();
    }

    public void addPages() {
        this.addPage((IWizardPage)new NewAndroidWidgetProjectMainPage(this.project));
    }

    private class DoSave
    implements IRunnableWithProgress {
        private static final String OPHONE_JAR = "oms.jar";
        private static final String OPHONESDK_PROMPT_KEY = "OphoneSDK";
        boolean saved = false;

        private DoSave() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            boolean autoBuild = ResourcesPlugin.getWorkspace().isAutoBuilding();
            IWorkspaceDescription wsd = ResourcesPlugin.getWorkspace().getDescription();
            wsd.setAutoBuilding(false);
            try {
                ResourcesPlugin.getWorkspace().setDescription(wsd);
            }
            catch (CoreException e) {
                AndmoreLogger.error(NewAndroidWidgetProjectWizard.class, (String)("Error cleaning workspace after project creation: " + e.getMessage()));
            }
            this.saved = NewAndroidWidgetProjectWizard.this.project.save(NewAndroidWidgetProjectWizard.this.getContainer(), monitor);
            NewAndroidWidgetProjectWizard.this.updatePerspective();
            IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(NewAndroidWidgetProjectWizard.this.project.getName());
            this.addOphoneSDK(p);
            try {
                p.build(15, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e1) {
                AndmoreLogger.error(NewAndroidWidgetProjectWizard.class, (String)("Sleep error when cleaning workspace after project creation: " + e1.getMessage()));
            }
            wsd.setAutoBuilding(autoBuild);
            try {
                ResourcesPlugin.getWorkspace().setDescription(wsd);
            }
            catch (CoreException e) {
                AndmoreLogger.error(NewAndroidWidgetProjectWizard.class, (String)("Error cleaning workspace after project creation: " + e.getMessage()));
            }
        }

        private void addOphoneSDK(IProject p) {
            IJavaProject javaProject;
            boolean addClasspath;
            IAndroidTarget sdkTarget = NewAndroidWidgetProjectWizard.this.project.getSdkTarget();
            File platformLocation = new File(sdkTarget.getLocation());
            File[] listFiles = platformLocation.listFiles();
            boolean found = false;
            int i = 0;
            File file = null;
            while (!found && i < listFiles.length) {
                file = listFiles[i];
                if (file.getName().equals(OPHONE_JAR)) {
                    found = true;
                }
                ++i;
            }
            if (found && (addClasspath = DialogWithToggleUtils.showQuestion((String)OPHONESDK_PROMPT_KEY, (String)AndroidNLS.NewAndroidProjectWizard_OPhonePromptTitle, (String)AndroidNLS.NewAndroidProjectWizard_OPhonePromptMessage)) && (javaProject = JavaCore.create((IProject)p)) != null && javaProject.exists()) {
                try {
                    javaProject.open((IProgressMonitor)new NullProgressMonitor());
                    IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
                    IClasspathEntry[] newClasspath = new IClasspathEntry[rawClasspath.length + 1];
                    System.arraycopy(rawClasspath, 0, newClasspath, 0, rawClasspath.length);
                    newClasspath[newClasspath.length - 1] = JavaCore.newLibraryEntry((IPath)new Path(file.getAbsolutePath()), null, null);
                    javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (JavaModelException e) {
                    AndmoreLogger.error(NewAndroidWidgetProjectWizard.class, (String)("Error while setting up the oms.jar on the project classpath: " + e.getMessage()));
                }
            }
        }
    }
}

