/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.state;

import com.google.common.base.Joiner;
import java.util.List;
import org.eclipse.andmore.gltrace.state.GLAbstractAtomicProperty;
import org.eclipse.andmore.gltrace.state.GLStateType;

public class GLObjectProperty
extends GLAbstractAtomicProperty {
    private final Object mDefaultValue;
    private Object mCurrentValue;
    private static final Joiner JOINER = Joiner.on((String)", ");

    public GLObjectProperty(GLStateType type, Object defaultValue) {
        super(type);
        this.mDefaultValue = this.mCurrentValue = defaultValue;
    }

    @Override
    public boolean isDefault() {
        return this.mDefaultValue != null & this.mDefaultValue.equals(this.mCurrentValue);
    }

    @Override
    public void setValue(Object newValue) {
        this.mCurrentValue = newValue;
    }

    @Override
    public String getStringValue() {
        if (this.mCurrentValue == null) {
            return "null";
        }
        if (this.mCurrentValue instanceof List) {
            return "[" + JOINER.join((Iterable)((List)this.mCurrentValue)) + "]";
        }
        return this.mCurrentValue.toString();
    }

    public String toString() {
        return (Object)((Object)this.getType()) + "=" + this.getStringValue();
    }

    @Override
    public Object getValue() {
        return this.mCurrentValue;
    }
}

