/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.views.detail;

import java.util.Arrays;
import java.util.List;
import org.eclipse.andmore.gltrace.state.GLCompositeProperty;
import org.eclipse.andmore.gltrace.state.GLSparseArrayProperty;
import org.eclipse.andmore.gltrace.state.GLStateType;
import org.eclipse.andmore.gltrace.state.GLStringProperty;
import org.eclipse.andmore.gltrace.state.IGLProperty;
import org.eclipse.andmore.gltrace.views.FitToCanvasAction;
import org.eclipse.andmore.gltrace.views.SaveImageAction;
import org.eclipse.andmore.gltrace.views.detail.IStateDetailProvider;
import org.eclipse.andmore.gltrace.widgets.ImageCanvas;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class TextureImageDetailsProvider
implements IStateDetailProvider {
    private ImageCanvas mImageCanvas;
    private FitToCanvasAction mFitToCanvasAction;
    private SaveImageAction mSaveImageAction;
    private List<IContributionItem> mToolBarItems;

    @Override
    public boolean isApplicable(IGLProperty state) {
        return this.getTextureImageProperty(state) != null;
    }

    @Override
    public void createControl(Composite parent) {
        this.mImageCanvas = new ImageCanvas(parent);
        this.mImageCanvas.setFitToCanvas(false);
        this.mFitToCanvasAction = new FitToCanvasAction(false, this.mImageCanvas);
        this.mSaveImageAction = new SaveImageAction(this.mImageCanvas);
        this.mToolBarItems = Arrays.asList(new ActionContributionItem((IAction)this.mFitToCanvasAction), new ActionContributionItem((IAction)this.mSaveImageAction));
    }

    @Override
    public void disposeControl() {
        this.mImageCanvas.dispose();
        this.mImageCanvas = null;
    }

    @Override
    public Control getControl() {
        return this.mImageCanvas;
    }

    @Override
    public void updateControl(IGLProperty state) {
        IGLProperty imageProperty = this.getTextureImageProperty(state);
        if (imageProperty == null) {
            return;
        }
        String texturePath = ((GLStringProperty)imageProperty).getStringValue();
        if (texturePath != null) {
            this.mImageCanvas.setImage(new Image((Device)Display.getDefault(), texturePath));
            this.mImageCanvas.setFitToCanvas(false);
            return;
        }
    }

    private IGLProperty getTextureImageProperty(IGLProperty state) {
        if (state.getType() == GLStateType.TEXTURE_IMAGE) {
            return state;
        }
        IGLProperty img = this.getImageFromPerTextureLevelState(state);
        if (img != null) {
            return img;
        }
        return this.getFirstMipmapImage(state);
    }

    private IGLProperty getImageFromPerTextureLevelState(IGLProperty state) {
        if (state != null && state.getType() != GLStateType.PER_TEXTURE_LEVEL_STATE) {
            state = state.getParent();
        }
        if (state == null || state.getType() != GLStateType.PER_TEXTURE_LEVEL_STATE) {
            return null;
        }
        return ((GLCompositeProperty)state).getProperty(GLStateType.TEXTURE_IMAGE);
    }

    private IGLProperty getFirstMipmapImage(IGLProperty state) {
        if (state != null && state.getType() != GLStateType.PER_TEXTURE_STATE) {
            state = state.getParent();
        }
        if (state == null || state.getType() != GLStateType.PER_TEXTURE_STATE) {
            return null;
        }
        IGLProperty mipmaps = ((GLCompositeProperty)state).getProperty(GLStateType.TEXTURE_MIPMAPS);
        if (!(mipmaps instanceof GLSparseArrayProperty)) {
            return null;
        }
        IGLProperty perTextureLevelState = ((GLSparseArrayProperty)mipmaps).getProperty(0);
        return this.getImageFromPerTextureLevelState(perTextureLevelState);
    }

    @Override
    public List<IContributionItem> getToolBarItems() {
        return this.mToolBarItems;
    }
}

