/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.hierarchyviewer.views;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.actions.PixelPerfectAutoRefreshAction;
import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import com.android.hierarchyviewerlib.ui.PixelPerfectControls;
import com.android.hierarchyviewerlib.ui.PixelPerfectLoupe;
import com.android.hierarchyviewerlib.ui.PixelPerfectPixelPanel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class PixelPerfectLoupeView
extends ViewPart
implements PixelPerfectModel.IImageChangeListener {
    public static final String ID = "org.eclipse.andmore.hierarchyviewer.views.PixelPerfectLoupeView";
    private PixelPerfectLoupe mPixelPerfectLoupe;
    private Action mShowInLoupeAction = new Action("&Show Overlay", 2){

        public void run() {
            PixelPerfectLoupeView.this.mPixelPerfectLoupe.setShowOverlay(this.isChecked());
        }
    };

    public void createPartControl(Composite parent) {
        this.mShowInLoupeAction.setAccelerator(SWT.MOD1 + 83);
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        Image image = imageLoader.loadImage("show-overlay.png", Display.getDefault());
        this.mShowInLoupeAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
        this.mShowInLoupeAction.setToolTipText("Show the overlay in the loupe view");
        this.mShowInLoupeAction.setEnabled(PixelPerfectModel.getModel().getOverlayImage() != null);
        PixelPerfectModel.getModel().addImageChangeListener((PixelPerfectModel.IImageChangeListener)this);
        GridLayout loupeLayout = new GridLayout();
        loupeLayout.marginHeight = 0;
        loupeLayout.marginWidth = 0;
        loupeLayout.verticalSpacing = 0;
        loupeLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)loupeLayout);
        Composite pixelPerfectLoupeBorder = new Composite(parent, 2048);
        pixelPerfectLoupeBorder.setLayoutData((Object)new GridData(1808));
        GridLayout pixelPerfectLoupeBorderGridLayout = new GridLayout();
        pixelPerfectLoupeBorderGridLayout.marginHeight = 0;
        pixelPerfectLoupeBorderGridLayout.marginWidth = 0;
        pixelPerfectLoupeBorderGridLayout.verticalSpacing = 0;
        pixelPerfectLoupeBorderGridLayout.horizontalSpacing = 0;
        pixelPerfectLoupeBorder.setLayout((Layout)pixelPerfectLoupeBorderGridLayout);
        this.mPixelPerfectLoupe = new PixelPerfectLoupe(pixelPerfectLoupeBorder);
        this.mPixelPerfectLoupe.setLayoutData((Object)new GridData(1808));
        PixelPerfectPixelPanel pixelPerfectPixelPanel = new PixelPerfectPixelPanel(pixelPerfectLoupeBorder);
        pixelPerfectPixelPanel.setLayoutData((Object)new GridData(768));
        PixelPerfectControls pixelPerfectControls = new PixelPerfectControls(parent);
        pixelPerfectControls.setLayoutData((Object)new GridData(768));
        this.placeActions();
    }

    private void placeActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager mm = actionBars.getMenuManager();
        mm.removeAll();
        mm.add((IAction)PixelPerfectAutoRefreshAction.getAction());
        mm.add((IAction)this.mShowInLoupeAction);
        IToolBarManager tm = actionBars.getToolBarManager();
        tm.removeAll();
        tm.add((IAction)PixelPerfectAutoRefreshAction.getAction());
        tm.add((IAction)this.mShowInLoupeAction);
    }

    public void dispose() {
        super.dispose();
        PixelPerfectModel.getModel().removeImageChangeListener((PixelPerfectModel.IImageChangeListener)this);
    }

    public void setFocus() {
        this.mPixelPerfectLoupe.setFocus();
    }

    public void crosshairMoved() {
    }

    public void treeChanged() {
    }

    public void imageChanged() {
    }

    public void imageLoaded() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Image overlayImage = PixelPerfectModel.getModel().getOverlayImage();
                PixelPerfectLoupeView.this.mShowInLoupeAction.setEnabled(overlayImage != null);
            }
        });
    }

    public void overlayChanged() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PixelPerfectLoupeView.this.mShowInLoupeAction.setEnabled(PixelPerfectModel.getModel().getOverlayImage() != null);
            }
        });
    }

    public void overlayTransparencyChanged() {
    }

    public void selectionChanged() {
    }

    public void zoomChanged() {
    }
}

