/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.ndk.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.ndk.internal.NativeAbi;
import org.eclipse.andmore.ndk.internal.NdkManager;
import org.eclipse.andmore.ndk.internal.launch.NdkLaunchConstants;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class NdkHelper {
    private static final String MAKE = "make";
    private static final String CORE_MAKEFILE_PATH = "/build/core/build-local.mk";

    public static Collection<NativeAbi> getApplicationAbis(IProject project, IProgressMonitor monitor) {
        CommandLauncher launcher = new CommandLauncher();
        launcher.setProject(project);
        String[] args = new String[]{"--no-print-dir", "-f", String.valueOf(NdkManager.getNdkLocation()) + CORE_MAKEFILE_PATH, "-C", project.getLocation().toOSString(), "DUMP_APP_ABI"};
        try {
            launcher.execute(NdkHelper.getPathToMake(), args, null, project.getLocation(), monitor);
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.printErrorToConsole((String)e.getLocalizedMessage(), (Object[])new Object[0]);
            return Collections.emptyList();
        }
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, monitor);
        String abis = stdout.toString().trim();
        EnumSet<NativeAbi> nativeAbis = EnumSet.noneOf(NativeAbi.class);
        String[] stringArray = abis.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String abi = stringArray[n2];
            if (abi.equals("all")) {
                return EnumSet.allOf(NativeAbi.class);
            }
            try {
                nativeAbis.add(NativeAbi.getByString(abi));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{"Unknown Application ABI: ", abi});
            }
            ++n2;
        }
        return nativeAbis;
    }

    public static String getToolchainPrefix(IProject project, NativeAbi abi, IProgressMonitor monitor) {
        CommandLauncher launcher = new CommandLauncher();
        launcher.setProject(project);
        String[] args = new String[]{"--no-print-dir", "-f", String.valueOf(NdkManager.getNdkLocation()) + CORE_MAKEFILE_PATH, "-C", project.getLocation().toOSString(), "DUMP_TOOLCHAIN_PREFIX", "APP_ABI=" + abi.getAbi()};
        try {
            launcher.execute(NdkHelper.getPathToMake(), args, null, project.getLocation(), monitor);
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.printErrorToConsole((String)e.getLocalizedMessage(), (Object[])new Object[0]);
            return null;
        }
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, monitor);
        return stdout.toString().trim();
    }

    private static IPath getPathToMake() {
        return NdkHelper.getFullPathTo(MAKE);
    }

    private static synchronized IPath getFullPathTo(String executable) {
        Path ndkRoot;
        IPath prebuilt;
        if (Platform.getOS().equals("win32")) {
            executable = String.valueOf(executable) + ".exe";
        }
        if (!(prebuilt = (ndkRoot = new Path(NdkManager.getNdkLocation())).append("prebuilt")).toFile().exists() || !prebuilt.toFile().canRead()) {
            return new Path(executable);
        }
        File[] platforms = prebuilt.toFile().listFiles();
        if (platforms != null) {
            File[] fileArray = platforms;
            int n = platforms.length;
            int n2 = 0;
            while (n2 < n) {
                File p = fileArray[n2];
                IPath exePath = prebuilt.append(p.getName()).append("bin").append(executable);
                if (exePath.toFile().exists()) {
                    return exePath;
                }
                ++n2;
            }
        }
        return new Path(executable);
    }

    public static void setLaunchConfigDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
        config.setAttribute("org.eclipse.andmore.ndk.ndklaunch.gdb", NdkLaunchConstants.DEFAULT_GDB);
        config.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", "");
        config.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", "5039");
        config.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", "localhost");
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote_attach");
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", NdkLaunchConstants.DEFAULT_PROGRAM);
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "gdbserver");
        ArrayList<String> solibPaths = new ArrayList<String>(2);
        solibPaths.add(NdkLaunchConstants.DEFAULT_SOLIB_PATH);
        config.setAttribute("org.eclipse.andmore.ndk.ndklaunch.solib", solibPaths);
    }
}

