/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout;

import com.android.ide.common.api.DrawingStyle;
import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.InsertType;
import com.android.ide.common.api.Point;
import com.android.ide.common.api.Rect;
import org.eclipse.andmore.common.layout.FrameLayoutRule;

public class HorizontalScrollViewRule
extends FrameLayoutRule {
    @Override
    public void onChildInserted(INode child, INode parent, InsertType insertType) {
        super.onChildInserted(child, parent, insertType);
        String fillParent = this.getFillParentValueName();
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", fillParent);
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", fillParent);
    }

    public void onCreate(INode node, INode parent, InsertType insertType) {
        super.onCreate(node, parent, insertType);
        if (insertType.isCreate()) {
            INode linearLayout = node.appendChild("android.widget.LinearLayout");
            linearLayout.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "horizontal");
        }
    }

    @Override
    public DropFeedback onDropMove(INode targetNode, IDragElement[] elements, DropFeedback feedback, Point p) {
        DropFeedback f = super.onDropMove(targetNode, elements, feedback, p);
        if (targetNode.getChildren().length > 0) {
            f.invalidTarget = true;
        }
        return f;
    }

    @Override
    protected void drawFeedback(IGraphics gc, INode targetNode, IDragElement[] elements, DropFeedback feedback) {
        if (targetNode.getChildren().length > 0) {
            Rect b = targetNode.getBounds();
            if (b.isValid()) {
                gc.useStyle(DrawingStyle.DROP_RECIPIENT);
                gc.drawRect(b);
            }
        } else {
            super.drawFeedback(gc, targetNode, elements, feedback);
        }
    }
}

