/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout;

import com.android.ide.common.api.IMenuCallback;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.INodeHandler;
import com.android.ide.common.api.RuleAction;
import java.util.List;

public class PropertyCallback
implements IMenuCallback {
    private final List<? extends INode> mTargetNodes;
    private final String mUndoLabel;
    private final String mUri;
    private final String mAttribute;

    public PropertyCallback(List<? extends INode> targetNodes, String undoLabel, String uri, String attribute) {
        this.mTargetNodes = targetNodes;
        this.mUndoLabel = undoLabel;
        this.mUri = uri;
        this.mAttribute = attribute;
    }

    public void action(RuleAction action, List<? extends INode> selectedNodes, final String valueId, final Boolean newValue) {
        if (this.mTargetNodes != null && this.mTargetNodes.size() > 0) {
            selectedNodes = this.mTargetNodes;
        }
        if (selectedNodes == null || selectedNodes.size() == 0) {
            return;
        }
        final List<? extends INode> nodes = selectedNodes;
        selectedNodes.get(0).editXml(this.mUndoLabel, new INodeHandler(){

            public void handle(INode n) {
                for (INode targetNode : nodes) {
                    if (valueId != null) {
                        targetNode.setAttribute(PropertyCallback.this.mUri, PropertyCallback.this.mAttribute, valueId);
                        continue;
                    }
                    if (!$assertionsDisabled && newValue == null) {
                        throw new AssertionError();
                    }
                    targetNode.setAttribute(PropertyCallback.this.mUri, PropertyCallback.this.mAttribute, Boolean.toString(newValue));
                }
            }
        });
    }
}

