/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout;

import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.IFeedbackPainter;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.IMenuCallback;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.INodeHandler;
import com.android.ide.common.api.InsertType;
import com.android.ide.common.api.Point;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.RuleAction;
import com.android.ide.common.api.SegmentType;
import com.android.utils.Pair;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.common.layout.BaseLayoutRule;
import org.eclipse.andmore.common.layout.relative.ConstraintPainter;
import org.eclipse.andmore.common.layout.relative.DeletionHandler;
import org.eclipse.andmore.common.layout.relative.GuidelinePainter;
import org.eclipse.andmore.common.layout.relative.MoveHandler;
import org.eclipse.andmore.common.layout.relative.ResizeHandler;

public class RelativeLayoutRule
extends BaseLayoutRule {
    private static final String ACTION_SHOW_STRUCTURE = "_structure";
    private static final String ACTION_SHOW_CONSTRAINTS = "_constraints";
    private static final String ACTION_CENTER_VERTICAL = "_centerVert";
    private static final String ACTION_CENTER_HORIZONTAL = "_centerHoriz";
    private static final URL ICON_CENTER_VERTICALLY = RelativeLayoutRule.class.getResource("centerVertically.png");
    private static final URL ICON_CENTER_HORIZONTALLY = RelativeLayoutRule.class.getResource("centerHorizontally.png");
    private static final URL ICON_SHOW_STRUCTURE = BaseLayoutRule.class.getResource("structure.png");
    private static final URL ICON_SHOW_CONSTRAINTS = BaseLayoutRule.class.getResource("constraints.png");
    public static boolean sShowStructure = false;
    public static boolean sShowConstraints = true;

    public List<String> getSelectionHint(INode parentNode, INode childNode) {
        ArrayList<String> infos = new ArrayList<String>(18);
        this.addAttr("layout_above", childNode, infos);
        this.addAttr("layout_below", childNode, infos);
        this.addAttr("layout_toLeftOf", childNode, infos);
        this.addAttr("layout_toRightOf", childNode, infos);
        this.addAttr("layout_alignBaseline", childNode, infos);
        this.addAttr("layout_alignTop", childNode, infos);
        this.addAttr("layout_alignBottom", childNode, infos);
        this.addAttr("layout_alignLeft", childNode, infos);
        this.addAttr("layout_alignRight", childNode, infos);
        this.addAttr("layout_alignParentTop", childNode, infos);
        this.addAttr("layout_alignParentBottom", childNode, infos);
        this.addAttr("layout_alignParentLeft", childNode, infos);
        this.addAttr("layout_alignParentRight", childNode, infos);
        this.addAttr("layout_alignWithParentIfMissing", childNode, infos);
        this.addAttr("layout_centerHorizontal", childNode, infos);
        this.addAttr("layout_centerInParent", childNode, infos);
        this.addAttr("layout_centerVertical", childNode, infos);
        return infos;
    }

    private void addAttr(String propertyName, INode childNode, List<String> infos) {
        String a = childNode.getStringAttr("http://schemas.android.com/apk/res/android", propertyName);
        if (a != null && a.length() > 0) {
            if (propertyName.startsWith("layout_")) {
                propertyName = propertyName.substring("layout_".length());
            }
            a = RelativeLayoutRule.stripIdPrefix(a);
            String s = String.valueOf(propertyName) + ": " + a;
            infos.add(s);
        }
    }

    public void paintSelectionFeedback(IGraphics graphics, INode parentNode, List<? extends INode> childNodes, Object view) {
        super.paintSelectionFeedback(graphics, parentNode, childNodes, view);
        boolean showDependents = true;
        if (sShowStructure) {
            childNodes = Arrays.asList(parentNode.getChildren());
            showDependents = false;
        } else if (!sShowConstraints) {
            return;
        }
        ConstraintPainter.paintSelectionFeedback(graphics, parentNode, childNodes, showDependents);
    }

    public DropFeedback onDropEnter(INode targetNode, Object targetView, IDragElement[] elements) {
        return new DropFeedback((Object)new MoveHandler(targetNode, elements, this.mRulesEngine), (IFeedbackPainter)new GuidelinePainter());
    }

    public DropFeedback onDropMove(INode targetNode, IDragElement[] elements, DropFeedback feedback, Point p) {
        if (elements == null || elements.length == 0 || feedback == null) {
            return null;
        }
        MoveHandler state = (MoveHandler)feedback.userData;
        int offsetX = p.x + (feedback.dragBounds != null ? feedback.dragBounds.x : 0);
        int offsetY = p.y + (feedback.dragBounds != null ? feedback.dragBounds.y : 0);
        state.updateMove(feedback, elements, offsetX, offsetY, feedback.modifierMask);
        feedback.requestPaint = true;
        return feedback;
    }

    public void onDropLeave(INode targetNode, IDragElement[] elements, DropFeedback feedback) {
    }

    public void onDropped(final INode targetNode, final IDragElement[] elements, DropFeedback feedback, Point p) {
        if (feedback == null) {
            return;
        }
        final MoveHandler state = (MoveHandler)feedback.userData;
        final Map<String, Pair<String, String>> idMap = RelativeLayoutRule.getDropIdMap(targetNode, elements, feedback.isCopy || !feedback.sameCanvas);
        targetNode.editXml("Dropped", new INodeHandler(){

            public void handle(INode n) {
                int index = -1;
                state.removeCycles();
                INode previous = null;
                IDragElement[] iDragElementArray = elements;
                int n2 = elements.length;
                int n3 = 0;
                while (n3 < n2) {
                    IDragElement element = iDragElementArray[n3];
                    String fqcn = element.getFqcn();
                    if (index >= 0) {
                        ++index;
                    }
                    INode newChild = targetNode.insertChildAt(fqcn, index);
                    RelativeLayoutRule.addAttributes(newChild, element, idMap, BaseLayoutRule.DEFAULT_ATTR_FILTER);
                    RelativeLayoutRule.addInnerElements(newChild, element, idMap);
                    if (previous == null) {
                        state.applyConstraints(newChild);
                        previous = newChild;
                    } else {
                        state.attachPrevious(previous, newChild);
                        previous = newChild;
                    }
                    ++n3;
                }
            }
        });
    }

    public void onChildInserted(INode node, INode parent, InsertType insertType) {
    }

    public void onRemovingChildren(List<INode> deleted, INode parent, boolean moved) {
        super.onRemovingChildren(deleted, parent, moved);
        if (!moved) {
            DeletionHandler handler = new DeletionHandler(deleted, Collections.<INode>emptyList(), parent);
            handler.updateConstraints();
        }
    }

    @Override
    public DropFeedback onResizeBegin(INode child, INode parent, SegmentType horizontalEdgeType, SegmentType verticalEdgeType, Object childView, Object parentView) {
        ResizeHandler state = new ResizeHandler(parent, child, this.mRulesEngine, horizontalEdgeType, verticalEdgeType);
        return new DropFeedback((Object)state, (IFeedbackPainter)new GuidelinePainter());
    }

    @Override
    public void onResizeUpdate(DropFeedback feedback, INode child, INode parent, Rect newBounds, int modifierMask) {
        if (feedback == null) {
            return;
        }
        ResizeHandler state = (ResizeHandler)feedback.userData;
        state.updateResize(feedback, child, newBounds, modifierMask);
    }

    @Override
    public void onResizeEnd(DropFeedback feedback, INode child, INode parent, Rect newBounds) {
        if (feedback == null) {
            return;
        }
        final ResizeHandler state = (ResizeHandler)feedback.userData;
        child.editXml("Resize", new INodeHandler(){

            public void handle(INode n) {
                state.removeCycles();
                state.applyConstraints(n);
            }
        });
    }

    @Override
    public void addLayoutActions(List<RuleAction> actions, final INode parentNode, final List<? extends INode> children) {
        super.addLayoutActions(actions, parentNode, children);
        actions.add(this.createGravityAction(Collections.singletonList(parentNode), "gravity"));
        actions.add((RuleAction)RuleAction.createSeparator((int)25));
        actions.add(this.createMarginAction(parentNode, children));
        IMenuCallback callback = new IMenuCallback(){

            public void action(RuleAction action, List<? extends INode> selectedNodes, String valueId, Boolean newValue) {
                final String id = action.getId();
                if (id.equals(RelativeLayoutRule.ACTION_CENTER_VERTICAL) || id.equals(RelativeLayoutRule.ACTION_CENTER_HORIZONTAL)) {
                    parentNode.editXml("Center", new INodeHandler(){

                        public void handle(INode n) {
                            if (id.equals(RelativeLayoutRule.ACTION_CENTER_VERTICAL)) {
                                for (INode child : children) {
                                    RelativeLayoutRule.this.centerVertically(child);
                                }
                            } else if (id.equals(RelativeLayoutRule.ACTION_CENTER_HORIZONTAL)) {
                                for (INode child : children) {
                                    RelativeLayoutRule.this.centerHorizontally(child);
                                }
                            }
                            (this).RelativeLayoutRule.this.mRulesEngine.redraw();
                        }
                    });
                } else if (id.equals(RelativeLayoutRule.ACTION_SHOW_CONSTRAINTS)) {
                    sShowConstraints = !sShowConstraints;
                    RelativeLayoutRule.this.mRulesEngine.redraw();
                } else {
                    if (!$assertionsDisabled && !id.equals(RelativeLayoutRule.ACTION_SHOW_STRUCTURE)) {
                        throw new AssertionError();
                    }
                    sShowStructure = !sShowStructure;
                    RelativeLayoutRule.this.mRulesEngine.redraw();
                }
            }
        };
        if (children != null && children.size() > 0) {
            actions.add((RuleAction)RuleAction.createSeparator((int)150));
            actions.add(RuleAction.createAction((String)ACTION_CENTER_VERTICAL, (String)"Center Vertically", (IMenuCallback)callback, (URL)ICON_CENTER_VERTICALLY, (int)160, (boolean)false));
            actions.add(RuleAction.createAction((String)ACTION_CENTER_HORIZONTAL, (String)"Center Horizontally", (IMenuCallback)callback, (URL)ICON_CENTER_HORIZONTALLY, (int)170, (boolean)false));
        }
        actions.add((RuleAction)RuleAction.createSeparator((int)80));
        actions.add((RuleAction)RuleAction.createToggle((String)ACTION_SHOW_CONSTRAINTS, (String)"Show Constraints", (boolean)sShowConstraints, (IMenuCallback)callback, (URL)ICON_SHOW_CONSTRAINTS, (int)180, (boolean)false));
        actions.add((RuleAction)RuleAction.createToggle((String)ACTION_SHOW_STRUCTURE, (String)"Show All Relationships", (boolean)sShowStructure, (IMenuCallback)callback, (URL)ICON_SHOW_STRUCTURE, (int)190, (boolean)false));
    }

    private void centerHorizontally(INode node) {
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignParentLeft", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignLeft", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_toRightOf", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerHorizontal", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignParentRight", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignRight", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_toLeftOf", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerHorizontal", null);
        if (!"true".equals(node.getStringAttr("http://schemas.android.com/apk/res/android", "layout_centerInParent"))) {
            if ("true".equals(node.getStringAttr("http://schemas.android.com/apk/res/android", "layout_centerVertical"))) {
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerVertical", null);
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerInParent", "true");
            } else {
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerHorizontal", "true");
            }
        }
    }

    private void centerVertically(INode node) {
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignParentTop", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignTop", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_below", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignParentBottom", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignBottom", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_above", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerVertical", null);
        node.setAttribute("http://schemas.android.com/apk/res/android", "layout_alignBaseline", null);
        if (!"true".equals(node.getStringAttr("http://schemas.android.com/apk/res/android", "layout_centerInParent"))) {
            if ("true".equals(node.getStringAttr("http://schemas.android.com/apk/res/android", "layout_centerHorizontal"))) {
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerHorizontal", null);
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerInParent", "true");
            } else {
                node.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerVertical", "true");
            }
        }
    }
}

