/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout.grid;

import com.android.ide.common.api.DrawingStyle;
import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.IFeedbackPainter;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.SegmentType;
import com.android.utils.Pair;
import org.eclipse.andmore.common.layout.GridLayoutRule;
import org.eclipse.andmore.common.layout.grid.GridDropHandler;
import org.eclipse.andmore.common.layout.grid.GridMatch;
import org.eclipse.andmore.common.layout.grid.GridModel;

public class GridLayoutPainter {
    public static IFeedbackPainter createDropFeedbackPainter(GridLayoutRule rule, IDragElement[] elements) {
        return new DropFeedbackPainter(rule, elements);
    }

    public static void paintStructure(DrawingStyle style, INode layout, IGraphics gc, GridModel grid) {
        Rect b = layout.getBounds();
        gc.useStyle(style);
        int row = 0;
        while (row < grid.actualRowCount) {
            int y = grid.getRowY(row);
            gc.drawLine(b.x, y, b.x2(), y);
            ++row;
        }
        int column = 0;
        while (column < grid.actualColumnCount) {
            int x = grid.getColumnX(column);
            gc.drawLine(x, b.y, x, b.y2());
            ++column;
        }
    }

    public static void paintGrid(INode layout, IGraphics gc) {
        Rect b = layout.getBounds();
        int oldAlpha = gc.getAlpha();
        gc.useStyle(DrawingStyle.GUIDELINE);
        gc.setAlpha(128);
        int y1 = b.y + 32;
        int y2 = b.y2() - 32;
        int y = y1;
        while (y < y2) {
            int x1 = b.x + 32;
            int x2 = b.x2() - 32;
            int x = x1;
            while (x < x2) {
                gc.drawPoint(x, y);
                x += 16;
            }
            y += 16;
        }
        gc.setAlpha(oldAlpha);
    }

    public static void paintResizeFeedback(IGraphics gc, INode layout, GridModel grid) {
        GridLayoutPainter.paintStructure(DrawingStyle.GRID, layout, gc, grid);
    }

    public static boolean paintStructure(Object view, DrawingStyle style, INode layout, IGraphics gc) {
        Pair<int[], int[]> cellBounds = GridModel.getAxisBounds(view);
        if (cellBounds != null) {
            int[] xs = (int[])cellBounds.getFirst();
            int[] ys = (int[])cellBounds.getSecond();
            Rect b = layout.getBounds();
            gc.useStyle(style);
            int row = 0;
            while (row < ys.length) {
                int y = ys[row] + b.y;
                gc.drawLine(b.x, y, b.x2(), y);
                ++row;
            }
            int column = 0;
            while (column < xs.length) {
                int x = xs[column] + b.x;
                gc.drawLine(x, b.y, x, b.y2());
                ++column;
            }
            return true;
        }
        return false;
    }

    private static class DropFeedbackPainter
    implements IFeedbackPainter {
        private final GridLayoutRule mRule;
        private final IDragElement[] mElements;

        public DropFeedbackPainter(GridLayoutRule rule, IDragElement[] elements) {
            this.mRule = rule;
            this.mElements = elements;
        }

        public void paint(IGraphics gc, INode node, DropFeedback feedback) {
            Rect b = node.getBounds();
            if (!b.isValid()) {
                return;
            }
            gc.useStyle(DrawingStyle.DROP_RECIPIENT);
            gc.drawRect(b);
            GridDropHandler data = (GridDropHandler)feedback.userData;
            if (!GridLayoutRule.sGridMode) {
                this.paintFreeFormDropFeedback(gc, node, feedback, b, data);
            } else {
                this.paintGridModeDropFeedback(gc, b, data);
            }
        }

        private void paintFreeFormDropFeedback(IGraphics gc, INode node, DropFeedback feedback, Rect b, GridDropHandler data) {
            GridModel grid = data.getGrid();
            if (GridLayoutRule.sSnapToGrid) {
                GridLayoutPainter.paintGrid(node, gc);
            }
            GridLayoutPainter.paintStructure(DrawingStyle.GRID, node, gc, grid);
            GridMatch rowMatch = data.getRowMatch();
            GridMatch columnMatch = data.getColumnMatch();
            if (rowMatch == null || columnMatch == null) {
                return;
            }
            IDragElement first = this.mElements[0];
            Rect dragBounds = first.getBounds();
            int offsetX = 0;
            int offsetY = 0;
            if (rowMatch.type == SegmentType.BOTTOM) {
                offsetY -= dragBounds.h;
            } else if (rowMatch.type == SegmentType.BASELINE) {
                offsetY -= feedback.dragBaseline;
            }
            if (columnMatch.type == SegmentType.RIGHT) {
                offsetX -= dragBounds.w;
            } else if (columnMatch.type == SegmentType.CENTER_HORIZONTAL) {
                offsetX -= dragBounds.w / 2;
            }
            int y = rowMatch.matchedLine;
            int x = columnMatch.matchedLine;
            Rect bounds = first.getBounds();
            if (rowMatch.margin != Integer.MIN_VALUE && rowMatch.margin > 0) {
                int y2;
                int y1;
                gc.useStyle(DrawingStyle.DISTANCE);
                int centerX = bounds.w / 2 + offsetX + x;
                if (rowMatch.type == SegmentType.TOP) {
                    y1 = offsetY + y - 1;
                    y2 = rowMatch.matchedLine - rowMatch.margin;
                } else {
                    assert (rowMatch.type == SegmentType.BOTTOM);
                    y1 = bounds.h + offsetY + y - 1;
                    y2 = rowMatch.matchedLine + rowMatch.margin;
                }
                gc.drawLine(b.x, y1, b.x2(), y1);
                gc.drawLine(b.x, y2, b.x2(), y2);
                gc.drawString(Integer.toString(rowMatch.margin), centerX - 3, y1 + (y2 - y1 - 16) / 2);
            } else {
                gc.useStyle(rowMatch.margin == 0 ? DrawingStyle.DISTANCE : (rowMatch.createCell ? DrawingStyle.GUIDELINE_DASHED : DrawingStyle.GUIDELINE));
                gc.drawLine(b.x, y, b.x2(), y);
            }
            if (columnMatch.margin != Integer.MIN_VALUE && columnMatch.margin > 0) {
                int x2;
                int x1;
                gc.useStyle(DrawingStyle.DISTANCE);
                int centerY = bounds.h / 2 + offsetY + y;
                if (columnMatch.type == SegmentType.LEFT) {
                    x1 = offsetX + x - 1;
                    x2 = columnMatch.matchedLine - columnMatch.margin;
                } else {
                    assert (columnMatch.type == SegmentType.RIGHT);
                    x1 = bounds.w + offsetX + x - 1;
                    x2 = columnMatch.matchedLine + columnMatch.margin;
                }
                gc.drawLine(x1, b.y, x1, b.y2());
                gc.drawLine(x2, b.y, x2, b.y2());
                gc.drawString(Integer.toString(columnMatch.margin), x1 + (x2 - x1 - 16) / 2, centerY - 3);
            } else {
                gc.useStyle(columnMatch.margin == 0 ? DrawingStyle.DISTANCE : (columnMatch.createCell ? DrawingStyle.GUIDELINE_DASHED : DrawingStyle.GUIDELINE));
                gc.drawLine(x, b.y, x, b.y2());
            }
            gc.useStyle(DrawingStyle.DROP_PREVIEW);
            offsetX += x - bounds.x;
            offsetY += y - bounds.y;
            IDragElement[] iDragElementArray = this.mElements;
            int n = this.mElements.length;
            int n2 = 0;
            while (n2 < n) {
                IDragElement element = iDragElementArray[n2];
                if (element == first) {
                    this.mRule.drawElement(gc, first, offsetX, offsetY);
                    if (feedback.dragBaseline != -1) {
                        int x1 = dragBounds.x + offsetX;
                        int y1 = dragBounds.y + offsetY + feedback.dragBaseline;
                        gc.drawLine(x1, y1, x1 + dragBounds.w, y1);
                    }
                } else {
                    b = element.getBounds();
                    if (b.isValid()) {
                        gc.drawRect(b.x + offsetX, b.y + offsetY, b.x + offsetX + b.w, b.y + offsetY + b.h);
                    }
                }
                ++n2;
            }
        }

        private void paintGridModeDropFeedback(IGraphics gc, Rect b, GridDropHandler data) {
            int radius = this.mRule.getNewCellSize();
            GridModel grid = data.getGrid();
            gc.useStyle(DrawingStyle.GUIDELINE);
            int row = 1;
            while (row < grid.actualRowCount) {
                int y = grid.getRowY(row);
                gc.drawLine(b.x, y - radius, b.x2(), y - radius);
                gc.drawLine(b.x, y + radius, b.x2(), y + radius);
                ++row;
            }
            int column = 1;
            while (column < grid.actualColumnCount) {
                int x = grid.getColumnX(column);
                gc.drawLine(x - radius, b.y, x - radius, b.y2());
                gc.drawLine(x + radius, b.y, x + radius, b.y2());
                ++column;
            }
            gc.drawRect(b.x, b.y, b.x2(), b.y2());
            gc.drawRect(b.x + 2 * radius, b.y + 2 * radius, b.x2() - 2 * radius, b.y2() - 2 * radius);
            GridMatch columnMatch = data.getColumnMatch();
            GridMatch rowMatch = data.getRowMatch();
            int column2 = columnMatch.cellIndex;
            int row2 = rowMatch.cellIndex;
            boolean createColumn = columnMatch.createCell;
            boolean createRow = rowMatch.createCell;
            Rect cellBounds = grid.getCellBounds(row2, column2, 1, 1);
            IDragElement first = this.mElements[0];
            Rect dragBounds = first.getBounds();
            int offsetX = cellBounds.x - dragBounds.x;
            int offsetY = cellBounds.y - dragBounds.y;
            gc.useStyle(DrawingStyle.DROP_ZONE_ACTIVE);
            if (createColumn) {
                gc.fillRect(new Rect(cellBounds.x - radius, cellBounds.y + (createRow ? -radius : radius), 2 * radius + 1, cellBounds.h - (createRow ? 0 : 2 * radius)));
                offsetX -= radius + dragBounds.w / 2;
            }
            if (createRow) {
                gc.fillRect(new Rect(cellBounds.x + radius, cellBounds.y - radius, cellBounds.w - 2 * radius, 2 * radius + 1));
                offsetY -= radius + dragBounds.h / 2;
            } else if (!createColumn) {
                gc.fillRect(new Rect(cellBounds.x + radius, cellBounds.y + radius, cellBounds.w - 2 * radius, cellBounds.h - 2 * radius));
            }
            gc.useStyle(DrawingStyle.DROP_PREVIEW);
            Rect bounds = first.getBounds();
            int x = offsetX;
            int y = offsetY;
            if (columnMatch.type == SegmentType.RIGHT) {
                x += cellBounds.w - bounds.w;
            } else if (columnMatch.type == SegmentType.CENTER_HORIZONTAL) {
                x += cellBounds.w / 2 - bounds.w / 2;
            }
            if (rowMatch.type == SegmentType.BOTTOM) {
                y += cellBounds.h - bounds.h;
            } else if (rowMatch.type == SegmentType.CENTER_VERTICAL) {
                y += cellBounds.h / 2 - bounds.h / 2;
            }
            this.mRule.drawElement(gc, first, x, y);
        }
    }
}

