/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout.relative;

import com.android.ide.common.api.DrawingStyle;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.Margins;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.SegmentType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.andmore.common.layout.relative.ConstraintType;
import org.eclipse.andmore.common.layout.relative.DependencyGraph;
import org.eclipse.andmore.common.layout.relative.Match;

public class ConstraintPainter {
    private static final int ARROW_SIZE = 5;
    private static final int PARENT_RECT_SIZE = 12;

    static void paintConstraint(IGraphics graphics, Rect sourceBounds, Match match) {
        Rect targetBounds = match.edge.node.getBounds();
        ConstraintType type = match.type;
        assert (type != null);
        ConstraintPainter.paintConstraint(graphics, type, match.with.node, sourceBounds, match.edge.node, targetBounds, null, true);
    }

    private static void paintConstraint(IGraphics graphics, DependencyGraph.Constraint constraint, Set<DependencyGraph.Constraint> allConstraints) {
        DependencyGraph.ViewData source = constraint.from;
        DependencyGraph.ViewData target = constraint.to;
        INode sourceNode = source.node;
        INode targetNode = target.node;
        if (sourceNode == targetNode) {
            return;
        }
        Rect sourceBounds = sourceNode.getBounds();
        Rect targetBounds = targetNode.getBounds();
        ConstraintPainter.paintConstraint(graphics, constraint.type, sourceNode, sourceBounds, targetNode, targetBounds, allConstraints, false);
    }

    public static void paintSelectionFeedback(IGraphics graphics, INode parentNode, List<? extends INode> childNodes, boolean showDependents) {
        DependencyGraph dependencyGraph = new DependencyGraph(parentNode);
        Set<INode> horizontalDeps = dependencyGraph.dependsOn(childNodes, false);
        Set<INode> verticalDeps = dependencyGraph.dependsOn(childNodes, true);
        HashSet<INode> deps = new HashSet<INode>(horizontalDeps.size() + verticalDeps.size());
        deps.addAll(horizontalDeps);
        deps.addAll(verticalDeps);
        if (deps.size() > 0) {
            graphics.useStyle(DrawingStyle.DEPENDENCY);
            for (INode iNode : deps) {
                if (childNodes.contains(iNode)) continue;
                Rect bounds = iNode.getBounds();
                graphics.fillRect(bounds);
            }
        }
        graphics.useStyle(DrawingStyle.GUIDELINE);
        for (INode iNode : childNodes) {
            DependencyGraph.ViewData view = dependencyGraph.getView(iNode);
            if (view == null) continue;
            if (showDependents) {
                ConstraintPainter.paintConstraints(graphics, view.dependedOnBy);
            }
            ConstraintPainter.paintConstraints(graphics, view.dependsOn);
        }
    }

    private static void paintConstraints(IGraphics graphics, List<DependencyGraph.Constraint> constraints) {
        HashSet<DependencyGraph.Constraint> mutableConstraintSet = new HashSet<DependencyGraph.Constraint>(constraints);
        for (DependencyGraph.Constraint constraint : constraints) {
            if (constraint.type != ConstraintType.ALIGN_BASELINE) continue;
            for (DependencyGraph.Constraint c : constraints) {
                if (c.type != ConstraintType.ALIGN_BOTTOM || c.to.node != constraint.to.node) continue;
                mutableConstraintSet.remove(c);
            }
        }
        for (DependencyGraph.Constraint constraint : constraints) {
            if (!mutableConstraintSet.contains(constraint)) continue;
            ConstraintPainter.paintConstraint(graphics, constraint, mutableConstraintSet);
        }
    }

    private static void paintConstraint(IGraphics graphics, ConstraintType type, INode sourceNode, Rect sourceBounds, INode targetNode, Rect targetBounds, Set<DependencyGraph.Constraint> allConstraints, boolean highlightTargetEdge) {
        SegmentType sourceSegmentTypeX = type.sourceSegmentTypeX;
        SegmentType sourceSegmentTypeY = type.sourceSegmentTypeY;
        SegmentType targetSegmentTypeX = type.targetSegmentTypeX;
        SegmentType targetSegmentTypeY = type.targetSegmentTypeY;
        if (sourceSegmentTypeX == SegmentType.CENTER_VERTICAL && targetSegmentTypeX == SegmentType.CENTER_VERTICAL) {
            ConstraintPainter.paintHorizontalCenterConstraint(graphics, sourceBounds, targetBounds);
            return;
        }
        if (sourceSegmentTypeY == SegmentType.CENTER_HORIZONTAL && targetSegmentTypeY == SegmentType.CENTER_HORIZONTAL) {
            ConstraintPainter.paintVerticalCenterConstraint(graphics, sourceBounds, targetBounds);
            return;
        }
        if (allConstraints != null && (type == ConstraintType.LAYOUT_ABOVE || type == ConstraintType.LAYOUT_BELOW || type == ConstraintType.LAYOUT_LEFT_OF || type == ConstraintType.LAYOUT_RIGHT_OF) && ConstraintPainter.paintCornerConstraint(graphics, type, sourceNode, sourceBounds, targetNode, targetBounds, allConstraints)) {
            return;
        }
        if (sourceSegmentTypeX == SegmentType.UNKNOWN) {
            ConstraintPainter.paintVerticalConstraint(graphics, type, sourceNode, sourceBounds, targetNode, targetBounds, highlightTargetEdge);
            return;
        }
        if (sourceSegmentTypeY == SegmentType.UNKNOWN) {
            ConstraintPainter.paintHorizontalConstraint(graphics, type, sourceNode, sourceBounds, targetNode, targetBounds, highlightTargetEdge);
            return;
        }
        assert (false);
    }

    private static boolean paintCornerConstraint(IGraphics graphics, ConstraintType type, INode sourceNode, Rect sourceBounds, INode targetNode, Rect targetBounds, Set<DependencyGraph.Constraint> allConstraints) {
        SegmentType sourceSegmentTypeX = type.sourceSegmentTypeX;
        SegmentType sourceSegmentTypeY = type.sourceSegmentTypeY;
        SegmentType targetSegmentTypeX = type.targetSegmentTypeX;
        SegmentType targetSegmentTypeY = type.targetSegmentTypeY;
        ConstraintType opposite1 = null;
        ConstraintType opposite2 = null;
        switch (type) {
            case LAYOUT_ABOVE: 
            case LAYOUT_BELOW: {
                opposite1 = ConstraintType.LAYOUT_LEFT_OF;
                opposite2 = ConstraintType.LAYOUT_RIGHT_OF;
                break;
            }
            case LAYOUT_LEFT_OF: 
            case LAYOUT_RIGHT_OF: {
                opposite1 = ConstraintType.LAYOUT_ABOVE;
                opposite2 = ConstraintType.LAYOUT_BELOW;
                break;
            }
            default: {
                return false;
            }
        }
        DependencyGraph.Constraint pair = null;
        for (DependencyGraph.Constraint constraint : allConstraints) {
            if (constraint.type != opposite1 && constraint.type != opposite2 || constraint.to.node != targetNode || constraint.from.node != sourceNode) continue;
            pair = constraint;
            break;
        }
        if (pair != null) {
            if (sourceSegmentTypeX == SegmentType.UNKNOWN) {
                sourceSegmentTypeX = pair.type.sourceSegmentTypeX;
            }
            if (sourceSegmentTypeY == SegmentType.UNKNOWN) {
                sourceSegmentTypeY = pair.type.sourceSegmentTypeY;
            }
            if (targetSegmentTypeX == SegmentType.UNKNOWN) {
                targetSegmentTypeX = pair.type.targetSegmentTypeX;
            }
            if (targetSegmentTypeY == SegmentType.UNKNOWN) {
                targetSegmentTypeY = pair.type.targetSegmentTypeY;
            }
            int x1 = sourceSegmentTypeX == SegmentType.LEFT ? sourceBounds.x + 1 * sourceBounds.w / 4 : sourceBounds.x + 3 * sourceBounds.w / 4;
            int y1 = sourceSegmentTypeY == SegmentType.TOP ? sourceBounds.y + 1 * sourceBounds.h / 4 : sourceBounds.y + 3 * sourceBounds.h / 4;
            int x2 = targetSegmentTypeX == SegmentType.LEFT ? targetBounds.x + 1 * targetBounds.w / 4 : targetBounds.x + 3 * targetBounds.w / 4;
            int y2 = targetSegmentTypeY == SegmentType.TOP ? targetBounds.y + 1 * targetBounds.h / 4 : targetBounds.y + 3 * targetBounds.h / 4;
            graphics.useStyle(DrawingStyle.GUIDELINE);
            graphics.drawArrow(x1, y1, x2, y2, 5);
            allConstraints.remove(pair);
            return true;
        }
        return false;
    }

    private static void paintVerticalConstraint(IGraphics graphics, ConstraintType type, INode sourceNode, Rect sourceBounds, INode targetNode, Rect targetBounds, boolean highlightTargetEdge) {
        int endX;
        int startX;
        int sharedY;
        int minRight;
        int maxLeft;
        int center;
        int targetY;
        SegmentType sourceSegmentTypeY = type.sourceSegmentTypeY;
        SegmentType targetSegmentTypeY = type.targetSegmentTypeY;
        Margins targetMargins = targetNode.getMargins();
        assert (sourceSegmentTypeY != SegmentType.UNKNOWN);
        assert (targetBounds != null);
        int sourceY = sourceSegmentTypeY.getY(sourceNode, sourceBounds);
        int n = targetY = targetSegmentTypeY == SegmentType.UNKNOWN ? sourceY : targetSegmentTypeY.getY(targetNode, targetBounds);
        if (highlightTargetEdge && type.isRelativeToParentEdge()) {
            graphics.useStyle(DrawingStyle.DROP_ZONE_ACTIVE);
            graphics.fillRect(targetBounds.x, targetY - 6, targetBounds.x2(), targetY + 6);
        }
        if ((center = ((maxLeft = Math.max(sourceBounds.x, targetBounds.x)) + (minRight = Math.min(sourceBounds.x2(), targetBounds.x2()))) / 2) > sourceBounds.x && center < sourceBounds.x2()) {
            if (targetSegmentTypeY == SegmentType.BOTTOM && targetMargins.bottom > 5) {
                int sharedY2 = targetY + targetMargins.bottom;
                if (sourceY > sharedY2 + 2) {
                    graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
                    graphics.drawLine(targetBounds.x, sharedY2, targetBounds.x2(), sharedY2);
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(center, sourceY, center, sharedY2 + 2, 5);
                    graphics.drawArrow(center, targetY, center, sharedY2 - 3, 5);
                } else {
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(center, targetY, center, sourceY, 5);
                }
                return;
            }
            if (targetSegmentTypeY == SegmentType.TOP && targetMargins.top > 5) {
                int sharedY3 = targetY - targetMargins.top;
                if (sourceY < sharedY3 - 2) {
                    graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
                    graphics.drawLine(targetBounds.x, sharedY3, targetBounds.x2(), sharedY3);
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(center, sourceY, center, sharedY3 - 3, 5);
                    graphics.drawArrow(center, targetY, center, sharedY3 + 3, 5);
                } else {
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(center, targetY, center, sourceY, 5);
                }
                return;
            }
            if (sourceY == targetY) {
                if (sourceSegmentTypeY == SegmentType.BOTTOM || sourceSegmentTypeY == SegmentType.BASELINE) {
                    sourceY -= 10;
                } else if (sourceSegmentTypeY == SegmentType.TOP) {
                    sourceY += 10;
                } else {
                    assert (sourceSegmentTypeY == SegmentType.CENTER_HORIZONTAL) : sourceSegmentTypeY;
                    sourceY += sourceBounds.h / 2 - 10;
                }
            } else if (sourceSegmentTypeY == SegmentType.BASELINE) {
                sourceY = targetY - 10;
            }
            graphics.useStyle(DrawingStyle.GUIDELINE);
            graphics.drawArrow(center, sourceY, center, targetY, 5);
            return;
        }
        int n2 = sharedY = targetSegmentTypeY == SegmentType.UNKNOWN ? sourceY : targetSegmentTypeY.getY(targetNode, targetBounds);
        if (type.relativeToMargin) {
            if (targetSegmentTypeY == SegmentType.TOP) {
                sharedY -= targetMargins.top;
            } else if (targetSegmentTypeY == SegmentType.BOTTOM) {
                sharedY += targetMargins.bottom;
            }
        }
        if (center <= sourceBounds.x) {
            startX = targetBounds.x + targetBounds.w / 4;
            endX = sourceBounds.x2();
        } else {
            assert (center >= sourceBounds.x2());
            startX = sourceBounds.x;
            endX = targetBounds.x + 3 * targetBounds.w / 4;
        }
        graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
        graphics.drawLine(startX, sharedY, endX, sharedY);
        if (Math.abs(sharedY - sourceY) < 10) {
            if (sourceSegmentTypeY == SegmentType.BASELINE) {
                sourceY = sharedY - 10;
            } else if (sourceSegmentTypeY == SegmentType.TOP) {
                sharedY = sourceY;
                sourceY = sharedY + 10;
            } else {
                sharedY = sourceY;
                sourceY = sharedY - 10;
            }
        }
        graphics.useStyle(DrawingStyle.GUIDELINE);
        int x = sourceBounds.x + (sourceSegmentTypeY == SegmentType.BASELINE ? sourceBounds.w / 2 : sourceBounds.w / 4);
        graphics.drawArrow(x, sourceY, x, sharedY, 5);
        int tx = targetBounds.centerX();
        if (targetSegmentTypeY == SegmentType.TOP) {
            int ty = targetBounds.y;
            int margin = targetMargins.top;
            if (margin == 0 || !type.relativeToMargin) {
                graphics.drawArrow(tx, ty + 10, tx, ty, 5);
            } else {
                graphics.drawArrow(tx, ty, tx, ty - margin, 5);
            }
        } else if (targetSegmentTypeY == SegmentType.BOTTOM) {
            int ty = targetBounds.y2();
            int margin = targetMargins.bottom;
            if (margin == 0 || !type.relativeToMargin) {
                graphics.drawArrow(tx, ty - 10, tx, ty, 5);
            } else {
                graphics.drawArrow(tx, ty, tx, ty + margin, 5);
            }
        } else {
            assert (targetSegmentTypeY == SegmentType.BASELINE) : targetSegmentTypeY;
            int ty = targetSegmentTypeY.getY(targetNode, targetBounds);
            graphics.drawArrow(tx, ty - 10, tx, ty, 5);
        }
    }

    private static void paintHorizontalConstraint(IGraphics graphics, ConstraintType type, INode sourceNode, Rect sourceBounds, INode targetNode, Rect targetBounds, boolean highlightTargetEdge) {
        int endY;
        int startY;
        int sharedX;
        int minBottom;
        int maxTop;
        int center;
        int targetX;
        SegmentType sourceSegmentTypeX = type.sourceSegmentTypeX;
        SegmentType targetSegmentTypeX = type.targetSegmentTypeX;
        Margins targetMargins = targetNode.getMargins();
        assert (sourceSegmentTypeX != SegmentType.UNKNOWN);
        assert (targetBounds != null);
        int sourceX = sourceSegmentTypeX.getX(sourceNode, sourceBounds);
        int n = targetX = targetSegmentTypeX == SegmentType.UNKNOWN ? sourceX : targetSegmentTypeX.getX(targetNode, targetBounds);
        if (highlightTargetEdge && type.isRelativeToParentEdge()) {
            graphics.useStyle(DrawingStyle.DROP_ZONE_ACTIVE);
            graphics.fillRect(targetX - 6, targetBounds.y, targetX + 6, targetBounds.y2());
        }
        if ((center = ((maxTop = Math.max(sourceBounds.y, targetBounds.y)) + (minBottom = Math.min(sourceBounds.y2(), targetBounds.y2()))) / 2) > sourceBounds.y && center < sourceBounds.y2()) {
            if (targetSegmentTypeX == SegmentType.RIGHT && targetMargins.right > 5) {
                int sharedX2 = targetX + targetMargins.right;
                if (sourceX > sharedX2 + 2) {
                    graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
                    graphics.drawLine(sharedX2, targetBounds.y, sharedX2, targetBounds.y2());
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(sourceX, center, sharedX2 + 2, center, 5);
                    graphics.drawArrow(targetX, center, sharedX2 - 3, center, 5);
                } else {
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(targetX, center, sourceX, center, 5);
                }
                return;
            }
            if (targetSegmentTypeX == SegmentType.LEFT && targetMargins.left > 5) {
                int sharedX3 = targetX - targetMargins.left;
                if (sourceX < sharedX3 - 2) {
                    graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
                    graphics.drawLine(sharedX3, targetBounds.y, sharedX3, targetBounds.y2());
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(sourceX, center, sharedX3 - 3, center, 5);
                    graphics.drawArrow(targetX, center, sharedX3 + 3, center, 5);
                } else {
                    graphics.useStyle(DrawingStyle.GUIDELINE);
                    graphics.drawArrow(targetX, center, sourceX, center, 5);
                }
                return;
            }
            if (sourceX == targetX) {
                if (sourceSegmentTypeX == SegmentType.RIGHT) {
                    sourceX -= 10;
                } else if (sourceSegmentTypeX == SegmentType.LEFT) {
                    sourceX += 10;
                } else {
                    assert (sourceSegmentTypeX == SegmentType.CENTER_VERTICAL) : sourceSegmentTypeX;
                    sourceX += sourceBounds.w / 2 - 10;
                }
            }
            graphics.useStyle(DrawingStyle.GUIDELINE);
            graphics.drawArrow(sourceX, center, targetX, center, 5);
            return;
        }
        int n2 = sharedX = targetSegmentTypeX == SegmentType.UNKNOWN ? sourceX : targetSegmentTypeX.getX(targetNode, targetBounds);
        if (type.relativeToMargin) {
            if (targetSegmentTypeX == SegmentType.LEFT) {
                sharedX -= targetMargins.left;
            } else if (targetSegmentTypeX == SegmentType.RIGHT) {
                sharedX += targetMargins.right;
            }
        }
        if (center <= sourceBounds.y) {
            startY = targetBounds.y + targetBounds.h / 4;
            endY = sourceBounds.y2();
        } else {
            assert (center >= sourceBounds.y2());
            startY = sourceBounds.y;
            endY = targetBounds.y + 3 * targetBounds.h / 2;
        }
        int y = sourceBounds.y + sourceBounds.h / 4;
        graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
        graphics.drawLine(sharedX, startY, sharedX, endY);
        if (Math.abs(sharedX - sourceX) < 10) {
            if (sourceSegmentTypeX == SegmentType.LEFT) {
                sharedX = sourceX;
                sourceX = sharedX + 10;
            } else {
                sharedX = sourceX;
                sourceX = sharedX - 10;
            }
        }
        graphics.useStyle(DrawingStyle.GUIDELINE);
        graphics.drawArrow(sourceX, y, sharedX, y, 5);
        int ty = targetBounds.centerY();
        if (targetSegmentTypeX == SegmentType.LEFT) {
            int tx = targetBounds.x;
            int margin = targetMargins.left;
            if (margin == 0 || !type.relativeToMargin) {
                graphics.drawArrow(tx + 10, ty, tx, ty, 5);
            } else {
                graphics.drawArrow(tx, ty, tx - margin, ty, 5);
            }
        } else {
            assert (targetSegmentTypeX == SegmentType.RIGHT);
            int tx = targetBounds.x2();
            int margin = targetMargins.right;
            if (margin == 0 || !type.relativeToMargin) {
                graphics.drawArrow(tx - 10, ty, tx, ty, 5);
            } else {
                graphics.drawArrow(tx, ty, tx + margin, ty, 5);
            }
        }
    }

    private static void paintVerticalCenterConstraint(IGraphics graphics, Rect sourceBounds, Rect targetBounds) {
        graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
        graphics.drawLine(targetBounds.x, targetBounds.centerY(), targetBounds.x2(), targetBounds.centerY());
        graphics.useStyle(DrawingStyle.GUIDELINE);
        graphics.drawLine(sourceBounds.x, sourceBounds.centerY(), sourceBounds.x2(), sourceBounds.centerY());
    }

    private static void paintHorizontalCenterConstraint(IGraphics graphics, Rect sourceBounds, Rect targetBounds) {
        graphics.useStyle(DrawingStyle.GUIDELINE_DASHED);
        graphics.drawLine(targetBounds.centerX(), targetBounds.y, targetBounds.centerX(), targetBounds.y2());
        graphics.useStyle(DrawingStyle.GUIDELINE);
        graphics.drawLine(sourceBounds.centerX(), sourceBounds.y, sourceBounds.centerX(), sourceBounds.y2());
    }
}

