/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout.relative;

import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.INode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.common.layout.BaseViewRule;
import org.eclipse.andmore.common.layout.relative.ConstraintType;

class DependencyGraph {
    static final String CHAIN_FORMAT = "%1$s=>%2$s";
    private static final String DEPENDENCY_FORMAT = "%1$s %2$s %3$s";
    private final Map<String, ViewData> mIdToView = new HashMap<String, ViewData>();
    private final Map<INode, ViewData> mNodeToView = new HashMap<INode, ViewData>();

    DependencyGraph(INode layout) {
        INode[] nodes = layout.getChildren();
        String parentId = layout.getStringAttr("http://schemas.android.com/apk/res/android", "id");
        parentId = parentId != null ? BaseViewRule.stripIdPrefix(parentId) : "RelativeLayout";
        ViewData parentView = new ViewData(layout, parentId);
        this.mNodeToView.put(layout, parentView);
        if (parentId != null) {
            this.mIdToView.put(parentId, parentView);
        }
        INode[] iNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            INode child = iNodeArray[n2];
            String id = child.getStringAttr("http://schemas.android.com/apk/res/android", "id");
            if (id != null) {
                id = BaseViewRule.stripIdPrefix(id);
            }
            ViewData view = new ViewData(child, id);
            this.mNodeToView.put(child, view);
            if (id != null) {
                this.mIdToView.put(id, view);
            }
            ++n2;
        }
        for (ViewData view : this.mNodeToView.values()) {
            INode.IAttribute[] iAttributeArray = view.node.getLiveAttributes();
            int n3 = iAttributeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                INode.IAttribute attribute = iAttributeArray[n4];
                String name = attribute.getName();
                ConstraintType type = ConstraintType.fromAttribute(name);
                if (type != null) {
                    String value = attribute.getValue();
                    if (type.targetParent) {
                        if (value.equals("true")) {
                            Constraint constraint = new Constraint(type, view, parentView);
                            view.dependsOn.add(constraint);
                            parentView.dependedOnBy.add(constraint);
                        }
                    } else {
                        String targetId = BaseViewRule.stripIdPrefix(value);
                        ViewData target = this.mIdToView.get(targetId);
                        if (target != view && target != null) {
                            Constraint constraint = new Constraint(type, view, target);
                            view.dependsOn.add(constraint);
                            target.dependedOnBy.add(constraint);
                        }
                    }
                }
                ++n4;
            }
        }
    }

    public ViewData getView(IDragElement element) {
        IDragElement.IDragAttribute attribute = element.getAttribute("http://schemas.android.com/apk/res/android", "id");
        if (attribute != null) {
            String id = attribute.getValue();
            id = BaseViewRule.stripIdPrefix(id);
            return this.getView(id);
        }
        return null;
    }

    public ViewData getView(String id) {
        return this.mIdToView.get(id);
    }

    public ViewData getView(INode node) {
        return this.mNodeToView.get(node);
    }

    public Set<INode> dependsOn(Collection<? extends INode> nodes, boolean vertical) {
        ArrayList<ViewData> reachable = new ArrayList<ViewData>();
        HashSet<ViewData> visiting = new HashSet<ViewData>();
        for (INode iNode : nodes) {
            ViewData view = this.mNodeToView.get(iNode);
            if (view == null) continue;
            this.findBackwards(view, visiting, reachable, vertical, view);
        }
        HashSet<INode> hashSet = new HashSet<INode>(reachable.size());
        for (ViewData v : reachable) {
            hashSet.add(v.node);
        }
        return hashSet;
    }

    private void findBackwards(ViewData view, Set<ViewData> visiting, List<ViewData> reachable, boolean vertical, ViewData start) {
        visiting.add(view);
        reachable.add(view);
        for (Constraint constraint : view.dependedOnBy) {
            if (vertical && !constraint.type.verticalEdge || !vertical && !constraint.type.horizontalEdge) continue;
            assert (constraint.to == view);
            ViewData from = constraint.from;
            if (visiting.contains(from)) {
                List<Constraint> path = this.getPathTo(start.node, view.node, vertical);
                if (path == null) continue;
                System.out.println(Constraint.describePath(path, null, null));
                continue;
            }
            this.findBackwards(from, visiting, reachable, vertical, start);
        }
        visiting.remove(view);
    }

    public List<Constraint> getPathTo(INode from, INode to, boolean vertical) {
        HashSet<ViewData> visiting = new HashSet<ViewData>();
        ArrayList<Constraint> path = new ArrayList<Constraint>();
        ViewData view = this.mNodeToView.get(from);
        if (view != null) {
            return this.findForwards(view, visiting, path, vertical, to);
        }
        return null;
    }

    private List<Constraint> findForwards(ViewData view, Set<ViewData> visiting, List<Constraint> path, boolean vertical, INode target) {
        visiting.add(view);
        for (Constraint constraint : view.dependsOn) {
            if (vertical && !constraint.type.verticalEdge || !vertical && !constraint.type.horizontalEdge) continue;
            try {
                List<Constraint> chain;
                path.add(constraint);
                if (constraint.to.node == target) {
                    ArrayList<Constraint> arrayList = new ArrayList<Constraint>(path);
                    return arrayList;
                }
                assert (constraint.from == view);
                ViewData to = constraint.to;
                if (visiting.contains(to) || (chain = this.findForwards(to, visiting, path, vertical, target)) == null) continue;
                List<Constraint> list = chain;
                return list;
            }
            finally {
                path.remove(constraint);
            }
        }
        visiting.remove(view);
        return null;
    }

    static class Constraint {
        public final ConstraintType type;
        public final ViewData from;
        public final ViewData to;

        Constraint(ConstraintType type, ViewData from, ViewData to) {
            this.type = type;
            this.from = from;
            this.to = to;
        }

        static String describePath(List<Constraint> path, String newName, String newId) {
            String s = "";
            int i = path.size() - 1;
            while (i >= 0) {
                Constraint constraint = path.get(i);
                String suffix = i == path.size() - 1 ? constraint.to.id : s;
                s = String.format(DependencyGraph.DEPENDENCY_FORMAT, constraint.from.id, Constraint.stripLayoutAttributePrefix(constraint.type.name), suffix);
                --i;
            }
            if (newName != null) {
                s = String.format(DependencyGraph.DEPENDENCY_FORMAT, s, Constraint.stripLayoutAttributePrefix(newName), BaseViewRule.stripIdPrefix(newId));
            }
            return s;
        }

        private static String stripLayoutAttributePrefix(String name) {
            if (name.startsWith("layout_")) {
                return name.substring("layout_".length());
            }
            return name;
        }
    }

    static class ViewData {
        public final INode node;
        public final String id;
        public final List<Constraint> dependsOn = new ArrayList<Constraint>(4);
        public final List<Constraint> dependedOnBy = new ArrayList<Constraint>(8);

        ViewData(INode node, String id) {
            this.node = node;
            this.id = id;
        }
    }
}

