/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout.relative;

import com.android.ide.common.api.Segment;
import org.eclipse.andmore.common.layout.relative.ConstraintType;
import org.eclipse.andmore.common.layout.relative.GuidelineHandler;

class Match {
    public final Segment with;
    public final Segment edge;
    public final int delta;
    public final ConstraintType type;
    public boolean cycle;
    private final GuidelineHandler mHandler;

    public Match(GuidelineHandler handler, Segment edge, Segment with, ConstraintType type, int delta) {
        this.mHandler = handler;
        this.edge = edge;
        this.with = with;
        this.type = type;
        this.delta = delta;
    }

    public String getConstraint(boolean generateId) {
        if (this.type.targetParent) {
            return String.valueOf(this.type.name) + '=' + "true";
        }
        String id = this.edge.id;
        if (id == null || id.length() == -1) {
            if (!generateId) {
                id = "<generated>";
            } else {
                id = this.edge.node.getStringAttr("http://schemas.android.com/apk/res/android", "id");
                if (id == null || id.length() == 0) {
                    id = this.mHandler.getRulesEngine().getUniqueId(this.edge.node.getFqcn());
                    this.edge.node.setAttribute("http://schemas.android.com/apk/res/android", "id", id);
                }
            }
        }
        return String.valueOf(this.type.name) + '=' + id;
    }

    public String toString() {
        return "Match [type=" + (Object)((Object)this.type) + ", delta=" + this.delta + ", edge=" + this.edge + "]";
    }
}

