/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout.relative;

import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IClientRulesEngine;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.MarginType;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.Segment;
import com.android.ide.common.api.SegmentType;
import java.util.Collections;
import java.util.Set;
import org.eclipse.andmore.common.layout.BaseLayoutRule;
import org.eclipse.andmore.common.layout.relative.GuidelineHandler;
import org.eclipse.andmore.common.layout.relative.Match;

public class ResizeHandler
extends GuidelineHandler {
    private final SegmentType mHorizontalEdgeType;
    private final SegmentType mVerticalEdgeType;

    public ResizeHandler(INode layout, INode resized, IClientRulesEngine rulesEngine, SegmentType horizontalEdgeType, SegmentType verticalEdgeType) {
        super(layout, rulesEngine);
        Set<INode> nodes;
        assert (horizontalEdgeType != null || verticalEdgeType != null);
        assert (horizontalEdgeType != SegmentType.BASELINE && verticalEdgeType != SegmentType.BASELINE);
        assert (horizontalEdgeType != SegmentType.CENTER_HORIZONTAL && verticalEdgeType != SegmentType.CENTER_HORIZONTAL);
        assert (horizontalEdgeType != SegmentType.CENTER_VERTICAL && verticalEdgeType != SegmentType.CENTER_VERTICAL);
        this.mHorizontalEdgeType = horizontalEdgeType;
        this.mVerticalEdgeType = verticalEdgeType;
        this.mDraggedNodes = nodes = Collections.singleton(resized);
        this.mHorizontalDeps = this.mDependencyGraph.dependsOn(nodes, false);
        this.mVerticalDeps = this.mDependencyGraph.dependsOn(nodes, true);
        if (horizontalEdgeType != null) {
            if (horizontalEdgeType == SegmentType.TOP) {
                this.mMoveTop = true;
            } else if (horizontalEdgeType == SegmentType.BOTTOM) {
                this.mMoveBottom = true;
            }
        }
        if (verticalEdgeType != null) {
            if (verticalEdgeType == SegmentType.LEFT) {
                this.mMoveLeft = true;
            } else if (verticalEdgeType == SegmentType.RIGHT) {
                this.mMoveRight = true;
            }
        }
        INode[] iNodeArray = layout.getChildren();
        int n = iNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            INode child = iNodeArray[n2];
            if (child != resized) {
                String id = child.getStringAttr("http://schemas.android.com/apk/res/android", "id");
                this.addBounds(child, id, !this.mHorizontalDeps.contains(child), !this.mVerticalDeps.contains(child));
            }
            ++n2;
        }
        this.addBounds(layout, layout.getStringAttr("http://schemas.android.com/apk/res/android", "id"), true, true);
    }

    @Override
    protected void snapVertical(Segment vEdge, int x, Rect newBounds) {
        int maxDistance = BaseLayoutRule.getMaxMatchDistance();
        if (vEdge.edgeType == SegmentType.LEFT) {
            int margin;
            int n = margin = this.mSnap ? 0 : Math.abs(newBounds.x - x);
            if (margin > maxDistance) {
                this.mLeftMargin = margin;
            } else {
                newBounds.w += newBounds.x - x;
                newBounds.x = x;
            }
        } else if (vEdge.edgeType == SegmentType.RIGHT) {
            int margin;
            int n = margin = this.mSnap ? 0 : Math.abs(newBounds.x - (x - newBounds.w));
            if (margin > maxDistance) {
                this.mRightMargin = margin;
            } else {
                newBounds.w = x - newBounds.x;
            }
        } else assert (false) : vEdge;
    }

    @Override
    protected void snapHorizontal(Segment hEdge, int y, Rect newBounds) {
        int maxDistance = BaseLayoutRule.getMaxMatchDistance();
        if (hEdge.edgeType == SegmentType.TOP) {
            int margin;
            int n = margin = this.mSnap ? 0 : Math.abs(newBounds.y - y);
            if (margin > maxDistance) {
                this.mTopMargin = margin;
            } else {
                newBounds.h += newBounds.y - y;
                newBounds.y = y;
            }
        } else if (hEdge.edgeType == SegmentType.BOTTOM) {
            int margin;
            int n = margin = this.mSnap ? 0 : Math.abs(newBounds.y - (y - newBounds.h));
            if (margin > maxDistance) {
                this.mBottomMargin = margin;
            } else {
                newBounds.h = y - newBounds.y;
            }
        } else assert (false) : hEdge;
    }

    @Override
    protected boolean isEdgeTypeCompatible(SegmentType edge, SegmentType dragged, int delta) {
        boolean compatible = super.isEdgeTypeCompatible(edge, dragged, delta);
        if (compatible && !this.mSnap) {
            switch (dragged) {
                case LEFT: 
                case TOP: {
                    return delta <= 0;
                }
            }
            return delta >= 0;
        }
        return compatible;
    }

    public void updateResize(DropFeedback feedback, INode child, Rect newBounds, int modifierMask) {
        Match match;
        this.mSnap = (modifierMask & 2) == 0;
        this.mBounds = newBounds;
        this.clearSuggestions();
        Rect b = newBounds;
        Segment hEdge = null;
        Segment vEdge = null;
        String childId = child.getStringAttr("http://schemas.android.com/apk/res/android", "id");
        if (this.mHorizontalEdgeType == SegmentType.TOP) {
            hEdge = new Segment(b.y, b.x, b.x2(), child, childId, this.mHorizontalEdgeType, MarginType.NO_MARGIN);
        } else if (this.mHorizontalEdgeType == SegmentType.BOTTOM) {
            hEdge = new Segment(b.y2(), b.x, b.x2(), child, childId, this.mHorizontalEdgeType, MarginType.NO_MARGIN);
        } else assert (this.mHorizontalEdgeType == null);
        if (this.mVerticalEdgeType == SegmentType.LEFT) {
            vEdge = new Segment(b.x, b.y, b.y2(), child, childId, this.mVerticalEdgeType, MarginType.NO_MARGIN);
        } else if (this.mVerticalEdgeType == SegmentType.RIGHT) {
            vEdge = new Segment(b.x2(), b.y, b.y2(), child, childId, this.mVerticalEdgeType, MarginType.NO_MARGIN);
        } else assert (this.mVerticalEdgeType == null);
        this.mRightMargin = 0;
        this.mLeftMargin = 0;
        this.mBottomMargin = 0;
        this.mTopMargin = 0;
        if (hEdge != null && this.mHorizontalEdges.size() > 0) {
            this.mHorizontalSuggestions = this.findClosest(hEdge, this.mHorizontalEdges);
            match = this.pickBestMatch(this.mHorizontalSuggestions);
            if (!(match == null || this.mSnap && Math.abs(match.delta) >= BaseLayoutRule.getMaxMatchDistance())) {
                if (this.mHorizontalDeps.contains(match.edge.node)) {
                    match.cycle = true;
                }
                this.snapHorizontal(hEdge, match.edge.at, newBounds);
                if (hEdge.edgeType == SegmentType.TOP) {
                    this.mCurrentTopMatch = match;
                } else if (hEdge.edgeType == SegmentType.BOTTOM) {
                    this.mCurrentBottomMatch = match;
                } else {
                    assert (hEdge.edgeType == SegmentType.CENTER_HORIZONTAL || hEdge.edgeType == SegmentType.BASELINE) : hEdge;
                    this.mCurrentTopMatch = match;
                }
            }
        }
        if (vEdge != null && this.mVerticalEdges.size() > 0) {
            this.mVerticalSuggestions = this.findClosest(vEdge, this.mVerticalEdges);
            match = this.pickBestMatch(this.mVerticalSuggestions);
            if (!(match == null || this.mSnap && Math.abs(match.delta) >= BaseLayoutRule.getMaxMatchDistance())) {
                if (this.mVerticalDeps.contains(match.edge.node)) {
                    match.cycle = true;
                }
                this.snapVertical(vEdge, match.edge.at, newBounds);
                if (vEdge.edgeType == SegmentType.LEFT) {
                    this.mCurrentLeftMatch = match;
                } else if (vEdge.edgeType == SegmentType.RIGHT) {
                    this.mCurrentRightMatch = match;
                } else {
                    assert (vEdge.edgeType == SegmentType.CENTER_VERTICAL);
                    this.mCurrentLeftMatch = match;
                }
            }
        }
        this.checkCycles(feedback);
    }
}

