/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.resources.platform;

import com.android.ide.common.api.IAttributeInfo;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.google.common.base.Splitter;
import java.util.EnumSet;
import java.util.regex.Pattern;

public class AttributeInfo
implements IAttributeInfo {
    private String mName;
    private EnumSet<IAttributeInfo.Format> mFormats;
    private String[] mEnumValues;
    private String[] mFlagValues;
    private String mJavaDoc;
    private String mDeprecatedDoc;
    private String mDefinedBy;
    private static final Pattern INTEGER_PATTERN = Pattern.compile("-?[0-9]+");
    private static final Pattern FLOAT_PATTERN = Pattern.compile("-?[0-9]?(\\.[0-9]+)?");
    private static final Pattern DIMENSION_PATTERN = Pattern.compile("-?[0-9]+(\\.[0-9]+)?(dp|dip|sp|px|pt|in|mm)");

    public AttributeInfo(String name, EnumSet<IAttributeInfo.Format> formats) {
        this.mName = name;
        this.mFormats = formats;
    }

    public AttributeInfo(String name, EnumSet<IAttributeInfo.Format> formats, String javadoc) {
        this.mName = name;
        this.mFormats = formats;
        this.mJavaDoc = javadoc;
    }

    public AttributeInfo(AttributeInfo info) {
        this.mName = info.mName;
        this.mFormats = info.mFormats;
        this.mEnumValues = info.mEnumValues;
        this.mFlagValues = info.mFlagValues;
        this.mJavaDoc = info.mJavaDoc;
        this.mDeprecatedDoc = info.mDeprecatedDoc;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public EnumSet<IAttributeInfo.Format> getFormats() {
        return this.mFormats;
    }

    public String[] getEnumValues() {
        return this.mEnumValues;
    }

    public String[] getFlagValues() {
        return this.mFlagValues;
    }

    public String getJavaDoc() {
        return this.mJavaDoc;
    }

    public String getDeprecatedDoc() {
        return this.mDeprecatedDoc;
    }

    public AttributeInfo setEnumValues(String[] values) {
        this.mEnumValues = values;
        return this;
    }

    public AttributeInfo setFlagValues(String[] values) {
        this.mFlagValues = values;
        return this;
    }

    public void setJavaDoc(String javaDoc) {
        this.mJavaDoc = javaDoc;
    }

    public void setDeprecatedDoc(String deprecatedDoc) {
        this.mDeprecatedDoc = deprecatedDoc;
    }

    public void setDefinedBy(String definedBy) {
        this.mDefinedBy = definedBy;
    }

    public String getDefinedBy() {
        return this.mDefinedBy;
    }

    public boolean isValid(String value, ResourceRepository projectResources, ResourceRepository frameworkResources) {
        int typeBegin;
        if (this.mFormats.contains(IAttributeInfo.Format.STRING) || this.mFormats.isEmpty()) {
            return true;
        }
        if (value.isEmpty()) {
            return this.mFormats.contains(IAttributeInfo.Format.FLAG);
        }
        char first = value.charAt(0);
        if (first == '@' || first == '?') {
            String url;
            int typeEnd;
            if (value.equals("@null")) {
                return true;
            }
            if (value.startsWith("@+id/") || value.startsWith("@id/")) {
                return true;
            }
            if (value.startsWith("@android:") || value.startsWith("?android:")) {
                if (frameworkResources != null) {
                    return frameworkResources.hasResourceItem(value);
                }
            } else if (projectResources != null) {
                return projectResources.hasResourceItem(value);
            }
            if ((typeEnd = (url = value).indexOf(47, 1)) != -1) {
                String typeName;
                ResourceType type;
                typeBegin = url.startsWith("@+") ? 2 : 1;
                int colon = url.lastIndexOf(58, typeEnd);
                if (colon != -1) {
                    typeBegin = colon + 1;
                }
                if ((type = ResourceType.getEnum((String)(typeName = url.substring(typeBegin, typeEnd)))) != null) {
                    return true;
                }
            } else if (value.startsWith("?")) {
                if (projectResources != null) {
                    return projectResources.hasResourceItem(ResourceType.ATTR, value.substring("?".length()));
                }
                return true;
            }
        }
        if (this.mFormats.contains(IAttributeInfo.Format.ENUM) && this.mEnumValues != null) {
            String[] stringArray = this.mEnumValues;
            typeBegin = this.mEnumValues.length;
            int n = 0;
            while (n < typeBegin) {
                String e = stringArray[n];
                if (value.equals(e)) {
                    return true;
                }
                ++n;
            }
        }
        if (this.mFormats.contains(IAttributeInfo.Format.FLAG) && this.mFlagValues != null) {
            for (String v : Splitter.on((char)'|').split((CharSequence)value)) {
                String[] stringArray = this.mFlagValues;
                int n = this.mFlagValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String e = stringArray[n2];
                    if (v.equals(e)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        if (this.mFormats.contains(IAttributeInfo.Format.DIMENSION) && DIMENSION_PATTERN.matcher(value).matches()) {
            return true;
        }
        if (this.mFormats.contains(IAttributeInfo.Format.BOOLEAN) && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))) {
            return true;
        }
        if (this.mFormats.contains(IAttributeInfo.Format.FLOAT) && (Character.isDigit(first) || first == '-' || first == '.')) {
            if (FLOAT_PATTERN.matcher(value).matches()) {
                return true;
            }
            try {
                Float.parseFloat(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.mFormats.contains(IAttributeInfo.Format.INTEGER) && (Character.isDigit(first) || first == '-') && INTEGER_PATTERN.matcher(value).matches()) {
            return true;
        }
        if (this.mFormats.contains(IAttributeInfo.Format.COLOR) && first == '#' && value.length() <= 9) {
            try {
                Long.parseLong(value.substring(1), 16);
                return true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.mFormats.contains(IAttributeInfo.Format.FRACTION);
    }
}

