/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.resources.platform;

import org.eclipse.andmore.common.resources.platform.AttributeInfo;

public class DeclareStyleableInfo {
    private final String mStyleName;
    private final AttributeInfo[] mAttributes;
    private String mJavaDoc;
    private String[] mParents;

    public DeclareStyleableInfo(String styleName, AttributeInfo[] attributes) {
        this.mStyleName = styleName;
        this.mAttributes = attributes == null ? new AttributeInfo[]{} : attributes;
    }

    public DeclareStyleableInfo(String styleName, DeclareStyleableInfo existing) {
        AttributeInfo[] attrs;
        this.mStyleName = styleName;
        this.mJavaDoc = existing.getJavaDoc();
        String[] parents = existing.getParents();
        if (parents != null) {
            this.mParents = new String[parents.length];
            System.arraycopy(parents, 0, this.mParents, 0, parents.length);
        }
        if ((attrs = existing.getAttributes()) == null || attrs.length == 0) {
            this.mAttributes = new AttributeInfo[0];
        } else {
            this.mAttributes = new AttributeInfo[attrs.length];
            System.arraycopy(attrs, 0, this.mAttributes, 0, attrs.length);
        }
    }

    public String getStyleName() {
        return this.mStyleName;
    }

    public AttributeInfo[] getAttributes() {
        return this.mAttributes;
    }

    public String getJavaDoc() {
        return this.mJavaDoc;
    }

    public void setJavaDoc(String javaDoc) {
        this.mJavaDoc = javaDoc;
    }

    public void setParents(String[] parents) {
        this.mParents = parents;
    }

    public String[] getParents() {
        return this.mParents;
    }
}

