/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal;

import com.android.SdkConstants;
import com.android.sdklib.repository.FullRevision;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.Messages;
import org.osgi.framework.Version;

public class VersionCheck {
    private static final FullRevision MIN_TOOLS_REV = new FullRevision(23, 0, 0, 0);
    private static final Pattern sPluginVersionPattern = Pattern.compile("^plugin.version=(\\d+)\\.(\\d+)\\.(\\d+).*$");
    private static final Pattern sSourcePropPattern = Pattern.compile("^Pkg.Revision=(.*)$");

    public static boolean checkVersion(String osSdkPath, AndmoreAndroidPlugin.CheckSdkErrorHandler errorHandler) {
        FullRevision toolsRevision;
        block61: {
            BufferedReader reader;
            int minMicroVersion;
            int minMinorVersion;
            int minMajorVersion;
            block54: {
                AndmoreAndroidPlugin.getDefault();
                String osLibs = String.valueOf(osSdkPath) + SdkConstants.OS_SDK_TOOLS_LIB_FOLDER;
                minMajorVersion = -1;
                minMinorVersion = -1;
                minMicroVersion = -1;
                reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(String.valueOf(osLibs) + "plugin.prop"));
                    while ((line = reader.readLine()) != null) {
                        Matcher m = sPluginVersionPattern.matcher(line);
                        if (!m.matches()) continue;
                        minMajorVersion = Integer.parseInt(m.group(1));
                        minMinorVersion = Integer.parseInt(m.group(2));
                        minMicroVersion = Integer.parseInt(m.group(3));
                        break;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (reader == null) break block54;
                    try {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            reader = null;
                            break block54;
                        }
                    }
                    catch (Throwable throwable) {
                        reader = null;
                        throw throwable;
                    }
                    reader = null;
                    break block54;
                }
                catch (IOException iOException) {
                    try {
                        if (reader == null) break block54;
                    }
                    catch (Throwable throwable) {
                        block58: {
                            if (reader != null) {
                                try {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException iOException2) {
                                        reader = null;
                                        break block58;
                                    }
                                }
                                catch (Throwable throwable2) {
                                    reader = null;
                                    throw throwable2;
                                }
                                reader = null;
                            }
                        }
                        throw throwable;
                    }
                    try {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException3) {
                            reader = null;
                            break block54;
                        }
                    }
                    catch (Throwable throwable) {
                        reader = null;
                        throw throwable;
                    }
                    reader = null;
                    break block54;
                }
                if (reader == null) break block54;
                try {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        reader = null;
                        break block54;
                    }
                }
                catch (Throwable throwable) {
                    reader = null;
                    throw throwable;
                }
                reader = null;
            }
            if (minMajorVersion == -1 || minMinorVersion == -1 || minMicroVersion == -1) {
                return errorHandler.handleWarning(AndmoreAndroidPlugin.CheckSdkErrorHandler.Solution.OPEN_SDK_MANAGER, Messages.VersionCheck_Plugin_Version_Failed);
            }
            File buildToolsFolder = new File(osSdkPath, "build-tools");
            if (!buildToolsFolder.isDirectory()) {
                return errorHandler.handleWarning(AndmoreAndroidPlugin.CheckSdkErrorHandler.Solution.OPEN_SDK_MANAGER, Messages.VersionCheck_Build_Tool_Missing);
            }
            String osTools = String.valueOf(osSdkPath) + SdkConstants.OS_SDK_TOOLS_FOLDER;
            toolsRevision = new FullRevision(Integer.MAX_VALUE);
            try {
                String line;
                reader = new BufferedReader(new FileReader(String.valueOf(osTools) + "source.properties"));
                while ((line = reader.readLine()) != null) {
                    Matcher m = sSourcePropPattern.matcher(line);
                    if (!m.matches()) continue;
                    try {
                        toolsRevision = FullRevision.parseRevision((String)m.group(1));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (reader == null) break block61;
                try {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        reader = null;
                        break block61;
                    }
                }
                catch (Throwable throwable) {
                    reader = null;
                    throw throwable;
                }
                reader = null;
                break block61;
            }
            catch (IOException iOException) {
                try {
                    if (reader == null) break block61;
                }
                catch (Throwable throwable) {
                    block65: {
                        if (reader != null) {
                            try {
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException4) {
                                    reader = null;
                                    break block65;
                                }
                            }
                            catch (Throwable throwable3) {
                                reader = null;
                                throw throwable3;
                            }
                            reader = null;
                        }
                    }
                    throw throwable;
                }
                try {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException5) {
                        reader = null;
                        break block61;
                    }
                }
                catch (Throwable throwable) {
                    reader = null;
                    throw throwable;
                }
                reader = null;
                break block61;
            }
            if (reader == null) break block61;
            try {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    reader = null;
                    break block61;
                }
            }
            catch (Throwable throwable) {
                reader = null;
                throw throwable;
            }
            reader = null;
        }
        if (toolsRevision.compareTo(MIN_TOOLS_REV, FullRevision.PreviewComparison.IGNORE) < 0) {
            return errorHandler.handleWarning(AndmoreAndroidPlugin.CheckSdkErrorHandler.Solution.OPEN_SDK_MANAGER, String.format(Messages.VersionCheck_Tools_Too_Old, MIN_TOOLS_REV, toolsRevision));
        }
        return true;
    }

    private static boolean compatibleVersion(int minMajorVersion, int minMinorVersion, int minMicroVersion, Version version) {
        boolean valid = true;
        if (version.getMajor() < minMajorVersion) {
            valid = false;
        } else if (version.getMajor() == minMajorVersion) {
            if (version.getMinor() < minMinorVersion) {
                valid = false;
            } else if (version.getMinor() == minMinorVersion && version.getMicro() < minMicroVersion) {
                valid = false;
            }
        }
        return valid;
    }
}

