/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.assetstudio;

import com.android.resources.ResourceFolderType;
import org.eclipse.andmore.internal.assetstudio.AssetType;
import org.eclipse.andmore.internal.assetstudio.CreateAssetSetWizardState;
import org.eclipse.andmore.internal.project.ProjectChooserHelper;
import org.eclipse.andmore.internal.resources.ResourceNameValidator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ChooseAssetTypePage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private final CreateAssetSetWizardState mValues;
    private ProjectChooserHelper.ProjectCombo mProjectButton;
    private Button mClipboardButton;
    private Text mNameText;
    private boolean mNameModified;
    private Label mResourceName;

    public ChooseAssetTypePage(CreateAssetSetWizardState values) {
        super("chooseAssetTypePage");
        this.mValues = values;
        this.setTitle("Choose Icon Set Type");
        this.setDescription("Select the type of icon set to create:");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        AssetType[] assetTypeArray = AssetType.values();
        int n = assetTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AssetType type = assetTypeArray[n2];
            Button button = new Button(container, 16);
            button.setData((Object)type);
            button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
            button.setSelection(type == this.mValues.type);
            button.setText(type.getDisplayName());
            button.addSelectionListener((SelectionListener)this);
            ++n2;
        }
        Label separator = new Label(container, 258);
        GridData gdSeparator = new GridData(4, 0x1000000, false, false, 3, 1);
        gdSeparator.heightHint = 20;
        separator.setLayoutData((Object)gdSeparator);
        Label projectLabel = new Label(container, 0);
        projectLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        projectLabel.setText("Project:");
        ProjectChooserHelper helper = new ProjectChooserHelper(this.getShell(), null);
        this.mProjectButton = new ProjectChooserHelper.ProjectCombo(helper, container, this.mValues.project);
        this.mProjectButton.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.mProjectButton.addSelectionListener(this);
        Label assetLabel = new Label(container, 0);
        assetLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        assetLabel.setText("Icon Name:");
        this.mNameText = new Text(container, 2048);
        this.mNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mNameText.addModifyListener((ModifyListener)this);
        Label resourceLabel = new Label(container, 0);
        resourceLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        resourceLabel.setText("Resource:");
        this.mResourceName = new Label(container, 0);
        this.mResourceName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mClipboardButton = new Button(container, 0x800000);
        this.mClipboardButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mClipboardButton.setText("Copy Name to Clipboard");
        this.mClipboardButton.addSelectionListener((SelectionListener)this);
        this.updateAssetType();
        this.validatePage();
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ChooseAssetTypePage.this.mNameText.setFocus();
            }
        });
    }

    private void updateAssetType() {
        if (!this.mNameModified) {
            String replace = "name";
            String suggestedName = String.format(this.mValues.type.getDefaultNameFormat(), replace);
            this.mNameText.setText(suggestedName);
            this.mValues.outputName = suggestedName;
            this.updateResourceLabel();
            this.mNameModified = false;
            int start = suggestedName.indexOf(replace);
            if (start != -1) {
                this.mNameText.setSelection(start, start + replace.length());
            } else {
                this.mNameText.selectAll();
            }
        } else {
            this.mNameText.selectAll();
        }
    }

    private void updateResourceLabel() {
        this.mResourceName.setText("@drawable/" + this.getOutputName());
    }

    public boolean canFlipToNextPage() {
        return this.mValues.project != null;
    }

    public void widgetSelected(SelectionEvent e) {
        Object data;
        Object source = e.getSource();
        if (source == this.mProjectButton) {
            this.mValues.project = this.mProjectButton.getSelectedProject();
            this.validatePage();
        } else if (source == this.mClipboardButton) {
            Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
            TextTransfer textTransfer = TextTransfer.getInstance();
            clipboard.setContents(new Object[]{this.mResourceName.getText()}, new Transfer[]{textTransfer});
            clipboard.dispose();
        } else if (source instanceof Button && (data = ((Button)source).getData()) instanceof AssetType) {
            CreateAssetSetWizardState.sLastType = this.mValues.type = (AssetType)((Object)data);
            this.updateAssetType();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        Object source = e.getSource();
        if (source == this.mNameText) {
            this.mNameModified = true;
            this.mValues.outputName = this.mNameText.getText().trim();
            this.updateResourceLabel();
        }
        this.validatePage();
    }

    private String getOutputName() {
        return this.mNameText.getText().trim();
    }

    private void validatePage() {
        String error = null;
        if (this.mValues.project == null) {
            error = "Please select an Android project.";
        } else {
            String outputName = this.getOutputName();
            if (outputName == null || outputName.length() == 0) {
                error = "Please enter a name";
            } else {
                ResourceNameValidator validator = ResourceNameValidator.create(true, ResourceFolderType.DRAWABLE);
                error = validator.isValid(outputName);
            }
        }
        this.setPageComplete(error == null);
        if (error != null) {
            this.setMessage(error, 3);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }
}

