/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.assetstudio;

import com.android.utils.Pair;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.assetstudio.ChooseAssetTypePage;
import org.eclipse.andmore.internal.assetstudio.ConfigureAssetSetPage;
import org.eclipse.andmore.internal.assetstudio.CreateAssetSetWizardState;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CreateAssetSetWizard
extends Wizard
implements INewWizard {
    private ChooseAssetTypePage mChooseAssetPage;
    private ConfigureAssetSetPage mConfigureAssetPage;
    private IProject mInitialProject;
    private List<IResource> mCreatedFiles;
    private CreateAssetSetWizardState mValues = new CreateAssetSetWizardState();

    public CreateAssetSetWizard() {
        this.setWindowTitle("Create Asset Set");
    }

    public void addPages() {
        this.mValues.project = this.mInitialProject;
        this.mChooseAssetPage = new ChooseAssetTypePage(this.mValues);
        this.mConfigureAssetPage = new ConfigureAssetSetPage(this.mValues);
        this.addPage((IWizardPage)this.mChooseAssetPage);
        this.addPage((IWizardPage)this.mConfigureAssetPage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        Map<String, Map<String, BufferedImage>> categories = ConfigureAssetSetPage.generateImages(this.mValues, false, null);
        IProject project = this.mValues.project;
        boolean yesToAll = false;
        this.mCreatedFiles = new ArrayList<IResource>();
        for (Map<String, BufferedImage> previews : categories.values()) {
            block14: for (Map.Entry<String, BufferedImage> entry : previews.entrySet()) {
                String relativePath = entry.getKey();
                Path dest = new Path(relativePath);
                IFile file = project.getFile((IPath)dest);
                if (file.exists()) {
                    if (!yesToAll) {
                        MessageDialog dialog = new MessageDialog(null, "File Already Exists", null, String.format("%1$s already exists.\nWould you like to replace it?", file.getProjectRelativePath().toOSString()), 3, new String[]{"Yes", "No", "Cancel", "Yes to All"}, 0);
                        int result = dialog.open();
                        switch (result) {
                            case 0: {
                                break;
                            }
                            case 3: {
                                yesToAll = true;
                                break;
                            }
                            case 1: {
                                continue block14;
                            }
                            case -1: 
                            case 2: {
                                return false;
                            }
                        }
                    }
                    try {
                        file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        AndmoreAndroidPlugin.log(e, null, new Object[0]);
                    }
                }
                AdtUtils.createWsParentDirectory(file.getParent());
                BufferedImage image = entry.getValue();
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)image, "PNG", stream);
                    byte[] bytes = stream.toByteArray();
                    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                    file.create((InputStream)is, true, null);
                    this.mCreatedFiles.add((IResource)file);
                }
                catch (IOException e) {
                    AndmoreAndroidPlugin.log(e, null, new Object[0]);
                }
                catch (CoreException e) {
                    AndmoreAndroidPlugin.log(e, null, new Object[0]);
                }
                try {
                    file.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    AndmoreAndroidPlugin.log(e, null, new Object[0]);
                }
            }
        }
        this.selectFiles(project, this.mCreatedFiles);
        return true;
    }

    private void selectFiles(IProject project, List<? extends IResource> createdFiles) {
        IWorkbench workbench = AndmoreAndroidPlugin.getDefault().getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView("org.eclipse.jdt.ui.PackageExplorer");
        if (viewPart != null) {
            IWorkbenchPartSite site = viewPart.getSite();
            IJavaProject javaProject = null;
            try {
                javaProject = BaseProjectHelper.getJavaProject(project);
            }
            catch (CoreException e) {
                AndmoreAndroidPlugin.log(e, null, new Object[0]);
            }
            ISelectionProvider provider = site.getSelectionProvider();
            if (provider != null) {
                ArrayList<TreePath> pathList = new ArrayList<TreePath>();
                for (IResource iResource : createdFiles) {
                    ArrayList<Object> segments = new ArrayList<Object>();
                    segments.add(iResource);
                    IContainer folder = iResource.getParent();
                    if (folder != null && !(folder instanceof IProject)) {
                        segments.add(folder);
                        folder = folder.getParent();
                        if (folder != null && !(folder instanceof IProject)) {
                            segments.add(folder);
                        }
                    }
                    segments.add(javaProject);
                    Collections.reverse(segments);
                    TreePath path = new TreePath(segments.toArray());
                    pathList.add(path);
                }
                TreePath[] treePathArray = pathList.toArray(new TreePath[pathList.size()]);
                TreeSelection selection = new TreeSelection(treePathArray);
                provider.setSelection((ISelection)selection);
                provider.setSelection((ISelection)selection);
                viewPart.setFocus();
            }
        }
    }

    void setProject(IProject project) {
        this.mInitialProject = project;
        this.mValues.project = project;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setHelpAvailable(false);
        this.mValues.project = this.mInitialProject = this.guessProject(selection);
    }

    private IProject guessProject(IStructuredSelection selection) {
        IEditorInput input;
        IEditorPart activeEditor;
        IWorkbenchPage page;
        if (selection == null) {
            return null;
        }
        for (Object element : selection.toList()) {
            if (element instanceof IAdaptable) {
                IResource res = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                IProject project = res != null ? res.getProject() : null;
                try {
                    if (project == null) continue;
                    if (!project.hasNature("org.eclipse.andmore.AndroidNature")) {
                    }
                }
                catch (CoreException coreException) {}
                continue;
                return project;
            }
            if (!(element instanceof Pair)) continue;
            Pair pair = (Pair)element;
            return (IProject)pair.getFirst();
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (activeEditor = page.getActiveEditor()) instanceof AndroidXmlEditor && (input = ((AndroidXmlEditor)activeEditor).getEditorInput()) instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            return fileInput.getFile().getProject();
        }
        IJavaProject[] projects = AdtUtils.getOpenAndroidProjects();
        if (projects != null && projects.length == 1) {
            return projects[0].getProject();
        }
        return null;
    }

    List<IResource> getCreatedFiles() {
        return this.mCreatedFiles;
    }
}

