/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.assetstudio;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.assetstudio.AssetType;
import org.eclipse.andmore.internal.wizards.templates.TemplateManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.RGB;

public class CreateAssetSetWizardState
implements GraphicGeneratorContext {
    public static AssetType sLastType = AssetType.LAUNCHER;
    public AssetType type = sLastType;
    public String outputName;
    public int minSdk = -1;
    public IProject project;
    public boolean trim = true;
    public SourceType sourceType = SourceType.TEXT;
    public String clipartName;
    public File imagePath;
    public String text = "aA";
    public int padding = 15;
    public GraphicGenerator.Shape shape = GraphicGenerator.Shape.SQUARE;
    public boolean crop;
    public boolean holoDark;
    public RGB background = new RGB(255, 0, 0);
    public RGB foreground = new RGB(0, 0, 0);
    private Font mTextFont;
    private Map<String, BufferedImage> mImageCache = null;

    public Font getTextFont() {
        if (this.mTextFont == null) {
            String familyName;
            String[] fontNames;
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] stringArray = fontNames = env.getAvailableFontFamilyNames();
            int n = fontNames.length;
            int n2 = 0;
            while (n2 < n) {
                familyName = stringArray[n2];
                if (familyName.equals("Helvetica")) {
                    this.mTextFont = new Font(familyName, 1, 512);
                    break;
                }
                ++n2;
            }
            if (this.mTextFont == null) {
                stringArray = fontNames;
                n = fontNames.length;
                n2 = 0;
                while (n2 < n) {
                    familyName = stringArray[n2];
                    if (familyName.equals("Arial")) {
                        this.mTextFont = new Font(familyName, 1, 512);
                        break;
                    }
                    ++n2;
                }
                if (this.mTextFont == null) {
                    this.mTextFont = new Font("SansSerif", 1, 512);
                }
            }
        }
        return this.mTextFont;
    }

    public void setTextFont(Font textFont) {
        this.mTextFont = textFont;
    }

    public BufferedImage loadImageResource(String relativeName) {
        try {
            return this.getCachedImage(relativeName, true);
        }
        catch (IOException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
            return null;
        }
    }

    BufferedImage getCachedImage(String path, boolean isPluginRelative) throws IOException {
        BufferedImage image;
        BufferedImage bufferedImage = image = this.mImageCache != null ? this.mImageCache.get(path) : null;
        if (image == null) {
            image = CreateAssetSetWizardState.getImage(path, isPluginRelative);
            if (this.mImageCache == null) {
                this.mImageCache = new HashMap<String, BufferedImage>();
            }
            this.mImageCache.put(path, image);
        }
        return image;
    }

    static BufferedImage getImage(String path, boolean isPluginRelative) throws IOException {
        BufferedImage image = null;
        if (isPluginRelative) {
            image = GraphicGenerator.getStencilImage((String)path);
        } else {
            File file;
            if (path.equals("launcher_icon")) {
                file = TemplateManager.getTemplateLocation("projects/NewAndroidApplication/root/res/drawable-xhdpi/ic_launcher.png");
                if (file != null) {
                    path = file.getPath();
                } else {
                    image = GraphicGenerator.getStencilImage((String)"user.png");
                }
            }
            file = new File(path);
            if (image == null) {
                image = ImageIO.read(file);
            }
        }
        if (image == null) {
            image = new BufferedImage(1, 1, 2);
        }
        return image;
    }

    public static enum SourceType {
        IMAGE,
        CLIPART,
        TEXT;

    }
}

