/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.build;

import java.util.List;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.build.ConvertSwitchDialog;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public class ConvertSwitchQuickFixProcessor
implements IQuickFixProcessor {
    public boolean hasCorrections(ICompilationUnit cu, int problemId) {
        return problemId == 0x20000099;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] location) throws CoreException {
        int i;
        ICompilationUnit compilationUnit;
        boolean foundError;
        int caret;
        int errorLength;
        int errorStart;
        block25: {
            if (location == null || location.length == 0) {
                return null;
            }
            ASTNode coveringNode = context.getCoveringNode();
            if (coveringNode == null) {
                return null;
            }
            if (coveringNode.getNodeType() == 42 && (coveringNode = coveringNode.getParent()) == null) {
                return null;
            }
            if (coveringNode.getNodeType() != 40) {
                return null;
            }
            QualifiedName name = (QualifiedName)coveringNode;
            if (!name.getFullyQualifiedName().startsWith("R.")) {
                return null;
            }
            IProblemLocation error = location[0];
            errorStart = error.getOffset();
            errorLength = error.getLength();
            caret = context.getSelectionOffset();
            foundError = false;
            compilationUnit = context.getCompilationUnit();
            IResource file = compilationUnit.getResource();
            if (file != null) {
                TextFileDocumentProvider provider = new TextFileDocumentProvider();
                try {
                    try {
                        provider.connect((Object)file);
                        IDocument document = provider.getDocument((Object)file);
                        if (document != null) {
                            List<IMarker> markers = AdtUtils.findMarkersOnLine("org.eclipse.core.resources.problemmarker", file, document, errorStart);
                            for (IMarker marker : markers) {
                                String message = marker.getAttribute("message", "");
                                if (!message.contains("constant expressions")) continue;
                                foundError = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        AndmoreAndroidPlugin.log(e, "Can't validate error message in %1$s", file.getName());
                        provider.disconnect((Object)file);
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    provider.disconnect((Object)file);
                    throw throwable;
                }
                provider.disconnect((Object)file);
            }
        }
        if (!foundError) {
            return null;
        }
        IBuffer buffer = compilationUnit.getBuffer();
        boolean sameLine = false;
        if (caret <= errorStart) {
            i = errorStart;
            while (i >= 0) {
                if (i <= caret) {
                    sameLine = true;
                } else {
                    char c = buffer.getChar(i);
                    if (c != '\n') {
                        --i;
                        continue;
                    }
                }
                break;
            }
        } else {
            i = errorStart + errorLength;
            int n = buffer.getLength();
            while (i < n) {
                if (i >= caret) {
                    sameLine = true;
                } else {
                    char c = buffer.getChar(i);
                    if (c != '\n') {
                        ++i;
                        continue;
                    }
                }
                break;
            }
        }
        if (sameLine) {
            String expression = buffer.getText(errorStart, errorLength);
            return new IJavaCompletionProposal[]{new MigrateProposal(expression)};
        }
        return null;
    }

    private class MigrateProposal
    implements IJavaCompletionProposal {
        private String mExpression;

        private MigrateProposal(String expression) {
            this.mExpression = expression;
        }

        public void apply(IDocument document) {
            Shell shell = AndmoreAndroidPlugin.getShell();
            ConvertSwitchDialog dialog = new ConvertSwitchDialog(shell, this.mExpression);
            dialog.open();
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return "As of ADT 14, resource fields cannot be used as switch cases. Invoke this fix to get more information.";
        }

        public String getDisplayString() {
            return "Migrate Android Code";
        }

        public Image getImage() {
            return AndmoreAndroidPlugin.getAndroidLogo();
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public int getRelevance() {
            return 50;
        }
    }
}

