/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.build;

import com.android.SdkConstants;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.internal.build.DefaultSourceChangeHandler;
import org.eclipse.andmore.internal.build.SourceFileData;
import org.eclipse.andmore.internal.build.builders.BaseBuilder;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.project.ProjectHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;

public abstract class SourceProcessor {
    public static final int COMPILE_STATUS_NONE = 0;
    public static final int COMPILE_STATUS_CODE = 1;
    public static final int COMPILE_STATUS_RES = 2;
    private final Map<IFile, SourceFileData> mFiles = new HashMap<IFile, SourceFileData>();
    private final IJavaProject mJavaProject;
    private BuildToolInfo mBuildToolInfo;
    private final IFolder mGenFolder;
    private final DefaultSourceChangeHandler mDeltaVisitor;
    private final List<IFile> mToCompile = new ArrayList<IFile>();
    private final List<IFile> mRemoved = new ArrayList<IFile>();
    private int mLastCompilationStatus = 0;

    public static String quote(String path) {
        if (SdkConstants.CURRENT_PLATFORM == 2) {
            if (path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - 1);
            }
            return "\"" + path + "\"";
        }
        return path;
    }

    protected SourceProcessor(IJavaProject javaProject, BuildToolInfo buildToolInfo, IFolder genFolder, DefaultSourceChangeHandler deltaVisitor) {
        this.mJavaProject = javaProject;
        this.mBuildToolInfo = buildToolInfo;
        this.mGenFolder = genFolder;
        this.mDeltaVisitor = deltaVisitor;
        this.mDeltaVisitor.init(this);
        IProject project = javaProject.getProject();
        this.buildSourceFileList();
        this.loadOutputAndDependencies();
        boolean mustCompile = this.loadState(project);
        if (mustCompile) {
            this.mToCompile.addAll(this.mFiles.keySet());
        }
    }

    protected SourceProcessor(IJavaProject javaProject, BuildToolInfo buildToolInfo, IFolder genFolder) {
        this(javaProject, buildToolInfo, genFolder, new DefaultSourceChangeHandler());
    }

    public void setBuildToolInfo(BuildToolInfo buildToolInfo) {
        this.mBuildToolInfo = buildToolInfo;
    }

    IFile isOutput(IFile file) {
        for (SourceFileData data : this.mFiles.values()) {
            if (!data.generated(file)) continue;
            return data.getSourceFile();
        }
        return null;
    }

    List<IFile> isDependency(IFile file) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (SourceFileData data : this.mFiles.values()) {
            if (!data.dependsOn(file)) continue;
            files.add(data.getSourceFile());
        }
        return files;
    }

    void addData(SourceFileData data) {
        this.mFiles.put(data.getSourceFile(), data);
    }

    SourceFileData getFileData(IFile file) {
        return this.mFiles.get(file);
    }

    Collection<SourceFileData> getAllFileData() {
        return this.mFiles.values();
    }

    public final DefaultSourceChangeHandler getChangeHandler() {
        return this.mDeltaVisitor;
    }

    final IJavaProject getJavaProject() {
        return this.mJavaProject;
    }

    final BuildToolInfo getBuildToolInfo() {
        return this.mBuildToolInfo;
    }

    final IFolder getGenFolder() {
        return this.mGenFolder;
    }

    final List<IFile> getToCompile() {
        return this.mToCompile;
    }

    final List<IFile> getRemovedFile() {
        return this.mRemoved;
    }

    final void addFileToCompile(IFile file) {
        this.mToCompile.add(file);
    }

    public final void prepareFullBuild(IProject project) {
        this.mDeltaVisitor.reset();
        this.mToCompile.clear();
        this.mRemoved.clear();
        this.buildSourceFileList();
        this.mToCompile.addAll(this.mFiles.keySet());
        this.saveState(project);
    }

    public final void doneVisiting(IProject project) {
        this.mergeFileModifications(this.mDeltaVisitor);
        this.mDeltaVisitor.reset();
        this.saveState(project);
    }

    protected abstract Set<String> getExtensions();

    protected abstract String getSavePropertyName();

    public final int compileFiles(BaseBuilder builder, IProject project, IAndroidTarget projectTarget, List<IPath> sourceFolders, List<File> libraryProjectsOut, IProgressMonitor monitor) throws CoreException {
        this.mLastCompilationStatus = 0;
        if (this.mToCompile.size() == 0 && this.mRemoved.size() == 0) {
            return this.mLastCompilationStatus;
        }
        for (IFile sourceFile : this.mRemoved) {
            int pos = this.mToCompile.indexOf(sourceFile);
            if (pos == -1) continue;
            this.mToCompile.remove(pos);
        }
        ArrayList<IFile> stillNeedCompilation = new ArrayList<IFile>();
        this.doCompileFiles(this.mToCompile, builder, project, projectTarget, sourceFolders, stillNeedCompilation, libraryProjectsOut, monitor);
        this.mToCompile.clear();
        this.mToCompile.addAll(stillNeedCompilation);
        for (IFile sourceFile : this.mRemoved) {
            SourceFileData data = this.getFileData(sourceFile);
            if (data == null) continue;
            this.doRemoveFiles(data);
        }
        for (IFile removedFile : this.mRemoved) {
            this.mFiles.remove(removedFile);
        }
        this.mRemoved.clear();
        this.saveState(project);
        return this.mLastCompilationStatus;
    }

    protected abstract void doCompileFiles(List<IFile> var1, BaseBuilder var2, IProject var3, IAndroidTarget var4, List<IPath> var5, List<IFile> var6, List<File> var7, IProgressMonitor var8) throws CoreException;

    protected void setCompilationStatus(int status) {
        this.mLastCompilationStatus |= status;
    }

    protected void doRemoveFiles(SourceFileData data) throws CoreException {
        List<IFile> outputFiles = data.getOutputFiles();
        for (IFile outputFile : outputFiles) {
            if (!outputFile.exists()) continue;
            outputFile.getLocation().toFile().delete();
        }
    }

    public final boolean loadState(IProject project) {
        return ProjectHelper.loadBooleanProperty((IResource)project, this.getSavePropertyName(), true);
    }

    public final void saveState(IProject project) {
        ProjectHelper.saveStringProperty((IResource)project, this.getSavePropertyName(), Boolean.toString(this.mToCompile.size() > 0));
    }

    protected abstract void loadOutputAndDependencies();

    protected IPath getSourceFolderFor(IFile file) {
        List<IPath> sourceFolders = BaseProjectHelper.getSourceClasspaths(this.getJavaProject());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (IPath sourceFolderPath : sourceFolders) {
            IFolder sourceFolder = root.getFolder(sourceFolderPath);
            if (!sourceFolder.exists() || sourceFolder.equals((Object)this.getGenFolder())) continue;
            IFile parent = file;
            while ((parent = parent.getParent()) != null) {
                if (!parent.equals((Object)sourceFolder)) continue;
                return sourceFolderPath;
            }
        }
        return null;
    }

    private final void buildSourceFileList() {
        this.mFiles.clear();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        List<IPath> sourceFolderPathList = BaseProjectHelper.getSourceClasspaths(this.mJavaProject);
        for (IPath sourceFolderPath : sourceFolderPathList) {
            IFolder sourceFolder = root.getFolder(sourceFolderPath);
            if (!sourceFolder.exists() || sourceFolder.equals((Object)this.getGenFolder())) continue;
            this.scanFolderForSourceFiles(sourceFolder, sourceFolder);
        }
    }

    private void scanFolderForSourceFiles(IFolder sourceFolder, IFolder folder) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                switch (r.getType()) {
                    case 1: {
                        String extension;
                        String string = extension = r.exists() ? r.getFileExtension() : null;
                        if (extension == null || !this.getExtensions().contains(extension.toLowerCase(Locale.US))) break;
                        this.mFiles.put((IFile)r, new SourceFileData((IFile)r));
                        break;
                    }
                    case 2: {
                        this.scanFolderForSourceFiles(sourceFolder, (IFolder)r);
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    private void mergeFileModifications(DefaultSourceChangeHandler visitor) {
        int index;
        Set<IFile> toRemove = visitor.getRemovedFiles();
        Set<IFile> toCompile = visitor.getFilesToCompile();
        for (IFile r : toRemove) {
            if (this.mRemoved.indexOf(r) == -1) {
                this.mRemoved.add(r);
            }
            if ((index = this.mToCompile.indexOf(r)) == -1) continue;
            this.mToCompile.remove(index);
        }
        for (IFile r : toCompile) {
            if (this.mToCompile.indexOf(r) == -1) {
                this.mToCompile.add(r);
            }
            if ((index = this.mRemoved.indexOf(r)) == -1) continue;
            this.mRemoved.remove(index);
        }
    }
}

