/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.ui.internal.text.XMLDocumentRegionEdgeMatcher;

public class AndroidXmlCharacterMatcher
extends XMLDocumentRegionEdgeMatcher {
    public IRegion match(IDocument doc, int offset) {
        if (offset < 0 || offset >= doc.getLength()) {
            return null;
        }
        IRegion match = this.findOppositeTag(doc, offset);
        if (match != null) {
            return match;
        }
        return super.match(doc, offset);
    }

    private IRegion findOppositeTag(IDocument document, int offset) {
        int target;
        if (!(document instanceof IStructuredDocument)) {
            return null;
        }
        IStructuredDocument doc = (IStructuredDocument)document;
        IStructuredDocumentRegion region = doc.getRegionAtCharacterOffset(offset);
        if (region == null) {
            return null;
        }
        ITextRegion subRegion = region.getRegionAtCharacterOffset(offset);
        if (subRegion == null) {
            return null;
        }
        ITextRegionList subRegions = region.getRegions();
        int index = subRegions.indexOf(subRegion);
        String type = subRegion.getType();
        boolean isOpenTag = false;
        boolean isCloseTag = false;
        if (type.equals("XML_TAG_OPEN")) {
            isOpenTag = true;
        } else if (type.equals("XML_END_TAG_OPEN")) {
            isCloseTag = true;
        } else if (!type.equals("XML_TAG_CLOSE") && !type.equals("XML_TAG_NAME") && subRegion.getStart() + region.getStartOffset() == offset) {
            if ((region = doc.getRegionAtCharacterOffset(--offset)) == null) {
                return null;
            }
            subRegion = region.getRegionAtCharacterOffset(offset);
            if (subRegion == null) {
                return null;
            }
            type = subRegion.getType();
            subRegions = region.getRegions();
            index = subRegions.indexOf(subRegion);
        }
        if (type.equals("XML_TAG_CLOSE") || type.equals("XML_TAG_NAME")) {
            int i = index;
            while (i >= 0) {
                subRegion = subRegions.get(i);
                type = subRegion.getType();
                if (type.equals("XML_TAG_OPEN")) {
                    isOpenTag = true;
                    break;
                }
                if (type.equals("XML_END_TAG_OPEN")) {
                    isCloseTag = true;
                    break;
                }
                --i;
            }
        }
        if (isOpenTag) {
            target = AndroidXmlCharacterMatcher.findTagForwards(doc, subRegion.getStart() + region.getStartOffset(), 0);
            return new Region(target, 1);
        }
        if (isCloseTag) {
            target = AndroidXmlCharacterMatcher.findTagBackwards(doc, subRegion.getStart() + region.getStartOffset(), -1);
            return new Region(target, 1);
        }
        return null;
    }

    public static int findTagBackwards(IStructuredDocument doc, int offset, int targetTagBalance) {
        int tagBalance = 0;
        IStructuredDocumentRegion region = doc.getRegionAtCharacterOffset(offset);
        if (region != null) {
            boolean inEmptyTag = true;
            while (region != null) {
                int regionStart = region.getStartOffset();
                ITextRegionList subRegions = region.getRegions();
                int i = subRegions.size() - 1;
                while (i >= 0) {
                    ITextRegion subRegion = subRegions.get(i);
                    int subRegionStart = regionStart + subRegion.getStart();
                    if (subRegionStart < offset) {
                        String type = subRegion.getType();
                        if ("XML_TAG_OPEN".equals(type)) {
                            if (!inEmptyTag) {
                                --tagBalance;
                            }
                            if (tagBalance == targetTagBalance) {
                                return subRegionStart;
                            }
                        } else if ("XML_END_TAG_OPEN".equals(type)) {
                            ++tagBalance;
                        } else if ("XML_EMPTY_TAG_CLOSE".equals(type)) {
                            inEmptyTag = true;
                        } else if ("XML_TAG_CLOSE".equals(type)) {
                            inEmptyTag = false;
                        }
                    }
                    --i;
                }
                region = region.getPrevious();
            }
        }
        return -1;
    }

    public static int findTagForwards(IStructuredDocument doc, int start, int targetTagBalance) {
        int tagBalance = 0;
        IStructuredDocumentRegion region = doc.getRegionAtCharacterOffset(start);
        if (region != null) {
            while (region != null) {
                int regionStart = region.getStartOffset();
                ITextRegionList subRegions = region.getRegions();
                int i = 0;
                int n = subRegions.size();
                while (i < n) {
                    ITextRegion subRegion = subRegions.get(i);
                    int subRegionStart = regionStart + subRegion.getStart();
                    int subRegionEnd = regionStart + subRegion.getEnd();
                    if (subRegionEnd >= start) {
                        String type = subRegion.getType();
                        if ("XML_TAG_OPEN".equals(type)) {
                            ++tagBalance;
                        } else if ("XML_END_TAG_OPEN".equals(type)) {
                            if (--tagBalance == targetTagBalance) {
                                return subRegionStart;
                            }
                        } else if ("XML_EMPTY_TAG_CLOSE".equals(type) && --tagBalance == targetTagBalance) {
                            return -1;
                        }
                    }
                    ++i;
                }
                region = region.getNext();
            }
        }
        return -1;
    }
}

