/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class XmlEditorMultiOutline
extends Page
implements IContentOutlinePage,
ISelectionChangedListener {
    private boolean mDisposed;
    private PageBook mPageBook;
    private IContentOutlinePage mCurrentPage;
    private IActionBars mActionBars;
    private IContentOutlinePage mEmptyPage;
    private List<ISelectionChangedListener> mListeners;
    private ISelection mSelection;

    public Control getControl() {
        return this.mPageBook;
    }

    public void createControl(Composite parent) {
        this.mPageBook = new PageBook(parent, 0);
    }

    public void dispose() {
        this.mDisposed = true;
        this.mListeners = null;
        if (this.mPageBook != null && !this.mPageBook.isDisposed()) {
            this.mPageBook.dispose();
            this.mPageBook = null;
        }
        if (this.mEmptyPage != null) {
            this.mEmptyPage.dispose();
            this.mEmptyPage = null;
        }
    }

    public boolean isDisposed() {
        return this.mDisposed;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
    }

    public void setActionBars(IActionBars actionBars) {
        this.mActionBars = actionBars;
        if (this.mCurrentPage != null) {
            this.setPageActive(this.mCurrentPage);
        }
    }

    public void setFocus() {
        if (this.mCurrentPage != null) {
            this.mCurrentPage.setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<ISelectionChangedListener>(2);
        }
        this.mListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.mSelection;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void setPageActive(IContentOutlinePage page) {
        if (page == null) {
            if (this.mEmptyPage == null) {
                this.mEmptyPage = new EmptyPage();
            }
            page = this.mEmptyPage;
        }
        if (this.mCurrentPage != null) {
            this.mCurrentPage.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        page.addSelectionChangedListener((ISelectionChangedListener)this);
        this.mCurrentPage = page;
        if (this.mPageBook == null) {
            return;
        }
        Control control = page.getControl();
        if (control == null || control.isDisposed()) {
            if (page instanceof IPageBookViewPage) {
                try {
                    ((IPageBookViewPage)page).init(this.getSite());
                }
                catch (PartInitException e) {
                    AndmoreAndroidPlugin.log(e, null, new Object[0]);
                }
            }
            page.createControl((Composite)this.mPageBook);
            page.setActionBars(this.mActionBars);
            control = page.getControl();
        }
        this.mPageBook.showPage(control);
    }

    public void setSelection(ISelection selection) {
        this.mSelection = selection;
        if (this.mListeners != null) {
            SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
            int i = 0;
            while (i < this.mListeners.size()) {
                this.mListeners.get(i).selectionChanged(e);
                ++i;
            }
        }
    }

    private static class EmptyPage
    implements IContentOutlinePage {
        private Composite mControl;

        private EmptyPage() {
        }

        public void createControl(Composite parent) {
            this.mControl = new Composite(parent, 0);
        }

        public void dispose() {
        }

        public Control getControl() {
            return this.mControl;
        }

        public void setActionBars(IActionBars actionBars) {
        }

        public void setFocus() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }
}

