/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.animator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.andmore.common.resources.platform.DeclareStyleableInfo;
import org.eclipse.andmore.internal.editors.animator.AnimatorDescriptors;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.IDescriptorProvider;
import org.eclipse.andmore.internal.editors.descriptors.XmlnsAttributeDescriptor;

public class AnimDescriptors
implements IDescriptorProvider {
    private ElementDescriptor mDescriptor;
    private ElementDescriptor[] mRootDescriptors;
    private Map<String, ElementDescriptor> nameToDescriptor;

    @Override
    public ElementDescriptor getDescriptor() {
        if (this.mDescriptor == null) {
            this.mDescriptor = new ElementDescriptor("", this.getRootElementDescriptors());
        }
        return this.mDescriptor;
    }

    @Override
    public ElementDescriptor[] getRootElementDescriptors() {
        return this.mRootDescriptors;
    }

    public ElementDescriptor getElementDescriptor(String mRootTag) {
        ElementDescriptor descriptor;
        if (this.nameToDescriptor == null) {
            this.nameToDescriptor = new HashMap<String, ElementDescriptor>();
            ElementDescriptor[] elementDescriptorArray = this.getRootElementDescriptors();
            int n = elementDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                descriptor = elementDescriptorArray[n2];
                this.nameToDescriptor.put(descriptor.getXmlName(), descriptor);
                ++n2;
            }
        }
        if ((descriptor = this.nameToDescriptor.get(mRootTag)) == null) {
            descriptor = this.getDescriptor();
        }
        return descriptor;
    }

    public synchronized void updateDescriptors(Map<String, DeclareStyleableInfo> styleMap) {
        if (styleMap == null) {
            return;
        }
        XmlnsAttributeDescriptor xmlns = new XmlnsAttributeDescriptor("android", "http://schemas.android.com/apk/res/android");
        ArrayList<ElementDescriptor> descriptors = new ArrayList<ElementDescriptor>();
        String sdkUrl = "http://developer.android.com/guide/topics/graphics/view-animation.html";
        ElementDescriptor set = AnimatorDescriptors.addElement(descriptors, styleMap, "set", "Set", "AnimationSet", "Animation", "A container that holds other animation elements (<alpha>, <scale>, <translate>, <rotate>) or other <set> elements. ", sdkUrl, xmlns, null, true);
        AnimatorDescriptors.addElement(descriptors, styleMap, "alpha", "Alpha", "AlphaAnimation", "Animation", "A fade-in or fade-out animation.", sdkUrl, xmlns, null, true);
        AnimatorDescriptors.addElement(descriptors, styleMap, "scale", "Scale", "ScaleAnimation", "Animation", "A resizing animation. You can specify the center point of the image from which it grows outward (or inward) by specifying pivotX and pivotY. For example, if these values are 0, 0 (top-left corner), all growth will be down and to the right.", sdkUrl, xmlns, null, true);
        AnimatorDescriptors.addElement(descriptors, styleMap, "rotate", "Rotate", "RotateAnimation", "Animation", "A rotation animation.", sdkUrl, xmlns, null, true);
        AnimatorDescriptors.addElement(descriptors, styleMap, "translate", "Translate", "TranslateAnimation", "Animation", "A vertical and/or horizontal motion. Supports the following attributes in any of the following three formats: values from -100 to 100 ending with \"%\", indicating a percentage relative to itself; values from -100 to 100 ending in \"%p\", indicating a percentage relative to its parent; a float value with no suffix, indicating an absolute value.", sdkUrl, xmlns, null, true);
        this.mRootDescriptors = descriptors.toArray(new ElementDescriptor[descriptors.size()]);
        if (set != null) {
            set.setChildren(this.mRootDescriptors);
        }
    }
}

